/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputSplit;
import org.apache.hadoop.hive.ql.io.HiveContextAwareRecordReader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class BucketizedHiveRecordReader<K extends WritableComparable, V extends Writable>
extends HiveContextAwareRecordReader<K, V> {
    protected final BucketizedHiveInputSplit split;
    protected final InputFormat inputFormat;
    protected final JobConf jobConf;
    protected final Reporter reporter;
    protected RecordReader curReader;
    protected long progress;
    protected int idx;

    public BucketizedHiveRecordReader(InputFormat inputFormat, BucketizedHiveInputSplit bucketizedSplit, JobConf jobConf, Reporter reporter) throws IOException {
        this.split = bucketizedSplit;
        this.inputFormat = inputFormat;
        this.jobConf = jobConf;
        this.reporter = reporter;
        this.initNextRecordReader();
    }

    @Override
    public void doClose() throws IOException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
        }
        this.idx = 0;
    }

    public K createKey() {
        return (K)((WritableComparable)this.curReader.createKey());
    }

    public V createValue() {
        return (V)((Writable)this.curReader.createValue());
    }

    public long getPos() throws IOException {
        if (this.curReader != null) {
            return this.curReader.getPos();
        }
        return 0L;
    }

    public float getProgress() throws IOException {
        return Math.min(1.0f, (float)(this.curReader == null ? this.progress : this.curReader.getPos()) / (float)this.split.getLength());
    }

    @Override
    public boolean doNext(K key, V value) throws IOException {
        while (this.curReader == null || !this.curReader.next(key, value)) {
            if (this.initNextRecordReader()) continue;
            return false;
        }
        return true;
    }

    protected boolean initNextRecordReader() throws IOException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
            if (this.idx > 0) {
                this.progress += this.split.getLength(this.idx - 1);
            }
        }
        if (this.idx == this.split.getNumSplits()) {
            return false;
        }
        try {
            this.curReader = this.inputFormat.getRecordReader(this.split.getSplit(this.idx), this.jobConf, this.reporter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ++this.idx;
        return true;
    }
}

