/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.BucketMapJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.ColumnPruner;
import org.apache.hadoop.hive.ql.optimizer.GroupByOptimizer;
import org.apache.hadoop.hive.ql.optimizer.JoinReorder;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.ReduceSinkDeDuplication;
import org.apache.hadoop.hive.ql.optimizer.SamplePruner;
import org.apache.hadoop.hive.ql.optimizer.SortedMergeBucketMapJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.lineage.Generator;
import org.apache.hadoop.hive.ql.optimizer.pcr.PartitionConditionRemover;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcessor;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.ppd.PredicatePushDown;

public class Optimizer {
    private ParseContext pctx;
    private List<Transform> transformations;

    public void initialize(HiveConf hiveConf) {
        this.transformations = new ArrayList<Transform>();
        this.transformations.add(new Generator());
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTCP)) {
            this.transformations.add(new ColumnPruner());
        }
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTPPD)) {
            this.transformations.add(new PredicatePushDown());
            this.transformations.add(new PartitionPruner());
            this.transformations.add(new PartitionConditionRemover());
        }
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTGROUPBY)) {
            this.transformations.add(new GroupByOptimizer());
        }
        this.transformations.add(new SamplePruner());
        this.transformations.add(new MapJoinProcessor());
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTBUCKETMAPJOIN)) {
            this.transformations.add(new BucketMapJoinOptimizer());
            if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTSORTMERGEBUCKETMAPJOIN)) {
                this.transformations.add(new SortedMergeBucketMapJoinOptimizer());
            }
        }
        this.transformations.add(new UnionProcessor());
        this.transformations.add(new JoinReorder());
        if (HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATION)) {
            this.transformations.add(new ReduceSinkDeDuplication());
        }
    }

    public ParseContext optimize() throws SemanticException {
        for (Transform t : this.transformations) {
            this.pctx = t.transform(this.pctx);
        }
        return this.pctx;
    }

    public ParseContext getPctx() {
        return this.pctx;
    }

    public void setPctx(ParseContext pctx) {
        this.pctx = pctx;
    }
}

