/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class HiveResultSetMetaData
implements ResultSetMetaData {
    private List<String> columnNames;
    private List<String> columnTypes;

    public HiveResultSetMetaData(List<String> columnNames, List<String> columnTypes) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        switch (this.getColumnType(column)) {
            case -5: 
            case 12: {
                return 32;
            }
            case -6: {
                return 2;
            }
            case 16: {
                return 8;
            }
            case 4: 
            case 8: {
                return 16;
            }
        }
        return 32;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnNames.get(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnNames.get(column - 1);
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (this.columnTypes == null) {
            throw new SQLException("Could not determine column type name for ResultSet");
        }
        if (column < 1 || column > this.columnTypes.size()) {
            throw new SQLException("Invalid column value: " + column);
        }
        String type = this.columnTypes.get(column - 1);
        return HiveResultSetMetaData.hiveTypeToSqlType(type);
    }

    public static int hiveTypeToSqlType(String type) throws SQLException {
        if ("string".equalsIgnoreCase(type)) {
            return 12;
        }
        if ("float".equalsIgnoreCase(type)) {
            return 6;
        }
        if ("double".equalsIgnoreCase(type)) {
            return 8;
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return 16;
        }
        if ("tinyint".equalsIgnoreCase(type)) {
            return -6;
        }
        if ("smallint".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("int".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("bigint".equalsIgnoreCase(type)) {
            return -5;
        }
        if (type.startsWith("map<")) {
            return 12;
        }
        if (type.startsWith("array<")) {
            return 12;
        }
        if (type.startsWith("struct<")) {
            return 12;
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (this.columnTypes == null) {
            throw new SQLException("Could not determine column type name for ResultSet");
        }
        if (column < 1 || column > this.columnTypes.size()) {
            throw new SQLException("Invalid column value: " + column);
        }
        String type = this.columnTypes.get(column - 1);
        if ("string".equalsIgnoreCase(type)) {
            return "string";
        }
        if ("float".equalsIgnoreCase(type)) {
            return "float";
        }
        if ("double".equalsIgnoreCase(type)) {
            return "double";
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return "boolean";
        }
        if ("tinyint".equalsIgnoreCase(type)) {
            return "tinyint";
        }
        if ("smallint".equalsIgnoreCase(type)) {
            return "smallint";
        }
        if ("int".equalsIgnoreCase(type)) {
            return "int";
        }
        if ("bigint".equalsIgnoreCase(type)) {
            return "bigint";
        }
        if (type.startsWith("map<")) {
            return "string";
        }
        if (type.startsWith("array<")) {
            return "string";
        }
        if (type.startsWith("struct<")) {
            return "string";
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        if (8 == this.getColumnType(column)) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (8 == this.getColumnType(column)) {
            return -1;
        }
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }
}

