/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.MapTaskStatus;
import org.apache.hadoop.mapred.ReduceTaskStatus;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.TaskAttemptID;

abstract class TaskStatus
implements Writable,
Cloneable {
    static final Log LOG = LogFactory.getLog((String)TaskStatus.class.getName());
    private final TaskAttemptID taskid;
    private float progress;
    private volatile State runState;
    private String diagnosticInfo;
    private String stateString;
    private String taskTracker;
    private long startTime;
    private long finishTime;
    private long outputSize;
    private volatile Phase phase = Phase.STARTING;
    private Counters counters;
    private boolean includeCounters;
    private SortedRanges.Range nextRecordRange = new SortedRanges.Range();

    public TaskStatus() {
        this.taskid = new TaskAttemptID();
    }

    public TaskStatus(TaskAttemptID taskid, float progress, State runState, String diagnosticInfo, String stateString, String taskTracker, Phase phase, Counters counters) {
        this.taskid = taskid;
        this.progress = progress;
        this.runState = runState;
        this.diagnosticInfo = diagnosticInfo;
        this.stateString = stateString;
        this.taskTracker = taskTracker;
        this.phase = phase;
        this.counters = counters;
        this.includeCounters = true;
    }

    public TaskAttemptID getTaskID() {
        return this.taskid;
    }

    public abstract boolean getIsMap();

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public State getRunState() {
        return this.runState;
    }

    public String getTaskTracker() {
        return this.taskTracker;
    }

    public void setTaskTracker(String tracker) {
        this.taskTracker = tracker;
    }

    public void setRunState(State runState) {
        this.runState = runState;
    }

    public String getDiagnosticInfo() {
        return this.diagnosticInfo;
    }

    public void setDiagnosticInfo(String info) {
        this.diagnosticInfo = this.diagnosticInfo == null ? info : this.diagnosticInfo.concat(info);
    }

    public String getStateString() {
        return this.stateString;
    }

    public void setStateString(String stateString) {
        this.stateString = stateString;
    }

    public SortedRanges.Range getNextRecordRange() {
        return this.nextRecordRange;
    }

    public void setNextRecordRange(SortedRanges.Range nextRecordRange) {
        this.nextRecordRange = nextRecordRange;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public long getShuffleFinishTime() {
        return 0L;
    }

    void setShuffleFinishTime(long shuffleFinishTime) {
    }

    public long getSortFinishTime() {
        return 0L;
    }

    void setSortFinishTime(long sortFinishTime) {
    }

    public long getStartTime() {
        return this.startTime;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public Phase getPhase() {
        return this.phase;
    }

    void setPhase(Phase phase) {
        Phase oldPhase = this.getPhase();
        if (oldPhase != phase) {
            if (phase == Phase.SORT) {
                this.setShuffleFinishTime(System.currentTimeMillis());
            } else if (phase == Phase.REDUCE) {
                this.setSortFinishTime(System.currentTimeMillis());
            }
        }
        this.phase = phase;
    }

    boolean inTaskCleanupPhase() {
        return this.phase == Phase.CLEANUP && (this.runState == State.FAILED_UNCLEAN || this.runState == State.KILLED_UNCLEAN);
    }

    public boolean getIncludeCounters() {
        return this.includeCounters;
    }

    public void setIncludeCounters(boolean send) {
        this.includeCounters = send;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setCounters(Counters counters) {
        this.counters = counters;
    }

    public long getOutputSize() {
        return this.outputSize;
    }

    void setOutputSize(long l) {
        this.outputSize = l;
    }

    public List<TaskAttemptID> getFetchFailedMaps() {
        return null;
    }

    synchronized void addFetchFailedMap(TaskAttemptID mapTaskId) {
    }

    synchronized void statusUpdate(float progress, String state, Counters counters) {
        this.setProgress(progress);
        this.setStateString(state);
        this.setCounters(counters);
    }

    synchronized void statusUpdate(TaskStatus status) {
        this.progress = status.getProgress();
        this.runState = status.getRunState();
        this.stateString = status.getStateString();
        this.nextRecordRange = status.getNextRecordRange();
        this.setDiagnosticInfo(status.getDiagnosticInfo());
        if (status.getStartTime() != 0L) {
            this.startTime = status.getStartTime();
        }
        if (status.getFinishTime() != 0L) {
            this.finishTime = status.getFinishTime();
        }
        this.phase = status.getPhase();
        this.counters = status.getCounters();
        this.outputSize = status.outputSize;
    }

    synchronized void statusUpdate(State runState, float progress, String state, Phase phase, long finishTime) {
        this.setRunState(runState);
        this.setProgress(progress);
        this.setStateString(state);
        this.setPhase(phase);
        if (finishTime != 0L) {
            this.finishTime = finishTime;
        }
    }

    synchronized void clearStatus() {
        this.diagnosticInfo = "";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.toString());
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.taskid.write(out);
        out.writeFloat(this.progress);
        WritableUtils.writeEnum(out, this.runState);
        Text.writeString(out, this.diagnosticInfo);
        Text.writeString(out, this.stateString);
        WritableUtils.writeEnum(out, this.phase);
        out.writeLong(this.startTime);
        out.writeLong(this.finishTime);
        out.writeBoolean(this.includeCounters);
        out.writeLong(this.outputSize);
        if (this.includeCounters) {
            this.counters.write(out);
        }
        this.nextRecordRange.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.taskid.readFields(in);
        this.progress = in.readFloat();
        this.runState = WritableUtils.readEnum(in, State.class);
        this.diagnosticInfo = Text.readString(in);
        this.stateString = Text.readString(in);
        this.phase = WritableUtils.readEnum(in, Phase.class);
        this.startTime = in.readLong();
        this.finishTime = in.readLong();
        this.counters = new Counters();
        this.includeCounters = in.readBoolean();
        this.outputSize = in.readLong();
        if (this.includeCounters) {
            this.counters.readFields(in);
        }
        this.nextRecordRange.readFields(in);
    }

    static TaskStatus createTaskStatus(DataInput in, TaskAttemptID taskId, float progress, State runState, String diagnosticInfo, String stateString, String taskTracker, Phase phase, Counters counters) throws IOException {
        boolean isMap = in.readBoolean();
        return TaskStatus.createTaskStatus(isMap, taskId, progress, runState, diagnosticInfo, stateString, taskTracker, phase, counters);
    }

    static TaskStatus createTaskStatus(boolean isMap, TaskAttemptID taskId, float progress, State runState, String diagnosticInfo, String stateString, String taskTracker, Phase phase, Counters counters) {
        return isMap ? new MapTaskStatus(taskId, progress, runState, diagnosticInfo, stateString, taskTracker, phase, counters) : new ReduceTaskStatus(taskId, progress, runState, diagnosticInfo, stateString, taskTracker, phase, counters);
    }

    static TaskStatus createTaskStatus(boolean isMap) {
        return isMap ? new MapTaskStatus() : new ReduceTaskStatus();
    }

    static TaskStatus readTaskStatus(DataInput in) throws IOException {
        boolean isMap = in.readBoolean();
        TaskStatus taskStatus = TaskStatus.createTaskStatus(isMap);
        taskStatus.readFields(in);
        return taskStatus;
    }

    static void writeTaskStatus(DataOutput out, TaskStatus taskStatus) throws IOException {
        out.writeBoolean(taskStatus.getIsMap());
        taskStatus.write(out);
    }

    public static enum State {
        RUNNING,
        SUCCEEDED,
        FAILED,
        UNASSIGNED,
        KILLED,
        COMMIT_PENDING,
        FAILED_UNCLEAN,
        KILLED_UNCLEAN;

    }

    public static enum Phase {
        STARTING,
        MAP,
        SHUFFLE,
        SORT,
        REDUCE,
        CLEANUP;

    }
}

