/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.hibernate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.hibernate.HibernateDataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDataAdapterService
extends AbstractDataAdapterService {
    private static final Log log = LogFactory.getLog(HibernateDataAdapterService.class);
    private Object session;

    public HibernateDataAdapterService(HibernateDataAdapter jsonDataAdapter) {
        super(jsonDataAdapter);
    }

    public HibernateDataAdapter getHibernateDataAdapter() {
        return (HibernateDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        block16: {
            HibernateDataAdapter hbmDA = this.getHibernateDataAdapter();
            if (hbmDA != null) {
                try {
                    Object configure;
                    Class<?> clazz = JRClassLoader.loadClassForRealName("org.hibernate.cfg.Configuration");
                    if (clazz == null || (configure = clazz.newInstance()) == null) break block16;
                    String xmlFileName = hbmDA.getXMLFileName();
                    if (xmlFileName != null && !xmlFileName.isEmpty()) {
                        File file = new File(xmlFileName);
                        clazz.getMethod("configure", file.getClass()).invoke(configure, file);
                    } else {
                        clazz.getMethod("configure", new Class[0]).invoke(configure, new Object[0]);
                    }
                    String pFileName = hbmDA.getPropertiesFileName();
                    if (pFileName != null && !pFileName.isEmpty()) {
                        Properties propHibernate = new Properties();
                        propHibernate.load(new FileInputStream(pFileName));
                        clazz.getMethod("setProperties", propHibernate.getClass()).invoke(configure, propHibernate);
                    }
                    if (hbmDA.isUseAnnotation()) {
                        try {
                            Class<?> anclazz = JRClassLoader.loadClassForRealName("org.hibernate.cfg.AnnotationConfiguration");
                            Object conf = anclazz.newInstance();
                            conf.getClass().getMethod("configure", new Class[0]).invoke(conf, new Object[0]);
                            clazz.getMethod("setProperty", String.class, String.class).invoke(configure, "hibernate.connection.provider_class", "com.jaspersoft.ireport.designer.connection.HibernateConnectionProvider");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Object bsf = clazz.getMethod("buildSessionFactory", new Class[0]).invoke(configure, new Object[0]);
                    this.session = bsf.getClass().getMethod("openSession", new Class[0]).invoke(bsf, new Object[0]);
                    this.session.getClass().getMethod("beginTransaction", new Class[0]).invoke(this.session, new Object[0]);
                    parameters.put("HIBERNATE_SESSION", this.session);
                }
                catch (IOException e) {
                    throw new JRException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new JRException(e);
                }
                catch (InstantiationException e) {
                    throw new JRException(e);
                }
                catch (IllegalAccessException e) {
                    throw new JRException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new JRException(e);
                }
                catch (SecurityException e) {
                    throw new JRException(e);
                }
                catch (InvocationTargetException e) {
                    throw new JRException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new JRException(e);
                }
            }
        }
    }

    @Override
    public void dispose() {
        block3: {
            if (this.session != null) {
                try {
                    this.session.getClass().getMethod("close", new Class[0]).invoke(this.session, new Object[0]);
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Error while closing the connection.", (Throwable)ex);
                }
            }
        }
    }
}

