/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.hadoop.hive;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.log4j.Logger;

public class HiveDataSource
implements JRDataSource {
    private ResultSet resultSet;
    private Map<String, Integer> indexesMap;
    public static final String DRIVER_NAME = "org.apache.hadoop.hive.jdbc.HiveDriver";
    public static final String CONNECTION = "com.jaspersoft.hadoop.hive.connection";
    public static final String QUERY_LANGUAGE = "HiveQL";
    private static final Logger logger = Logger.getLogger(HiveDataSource.class);

    public HiveDataSource(ResultSet resultSet) throws ClassNotFoundException {
        this.resultSet = resultSet;
    }

    public Object getFieldValue(JRField field) throws JRException {
        if (this.resultSet == null) {
            return null;
        }
        try {
            Integer index = this.indexesMap.get(field.getName());
            if (index == null) {
                throw new JRException("Unknown field \"" + field.getName() + "\"");
            }
            return this.resultSet.getObject(index);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
    }

    public boolean next() throws JRException {
        if (this.resultSet == null) {
            return false;
        }
        boolean next = false;
        try {
            next = this.resultSet.next();
            if (!next) {
                this.resultSet.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (next && this.indexesMap == null) {
            this.getIndexesMap();
        }
        return next;
    }

    private void getIndexesMap() {
        this.indexesMap = new HashMap<String, Integer>();
        try {
            ResultSetMetaData metaData = this.resultSet.getMetaData();
            int limit = metaData.getColumnCount();
            for (int index = 1; index <= limit; ++index) {
                this.indexesMap.put(metaData.getColumnName(index), index);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Indexes Map: " + this.indexesMap));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

