/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.jasperserver;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.mongodb.connection.MongoDbConnection;
import com.jaspersoft.mongodb.connection.MongoDbConnectionManager;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;

public class MongoDbDataSourceService
implements ReportDataSourceService {
    private MongoDbConnection connection;
    private String mongoURI;
    private String username;
    private String password;
    private MongoDbConnectionManager connectionManager;

    public void closeConnection() {
        if (this.connectionManager != null && this.connection != null) {
            this.connectionManager.returnConnection(this.connection);
            this.connection = null;
        }
    }

    public void setReportParameterValues(Map parameters) {
        this.connectionManager.setMongoURI(this.mongoURI);
        this.connectionManager.setUsername(this.username);
        this.connectionManager.setPassword(this.password);
        try {
            this.connection = this.connectionManager.borrowConnection();
            parameters.put("com.jaspersoft.mongodb.connection", this.connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createConnection() throws JRException {
        if (this.connection != null) {
            this.closeConnection();
        }
        this.connection = new MongoDbConnection(this.mongoURI, this.username, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnection() {
        try {
            this.createConnection();
            if (this.connection == null) {
                boolean bl = false;
                return bl;
            }
            this.connection.test();
            boolean bl = true;
            return bl;
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        finally {
            this.closeConnection();
        }
        return false;
    }

    public void setMongoURI(String mongoURI) {
        this.mongoURI = mongoURI;
    }

    public String getMongoURI() {
        return this.mongoURI;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setConnectionManager(MongoDbConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public MongoDbConnectionManager getConnectionManager() {
        return this.connectionManager;
    }
}

