/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.crosstab;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.crosstab.CellInfo;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import com.jaspersoft.ireport.designer.crosstab.JCellButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class CrosstabDebugConsoleTopComponent
extends TopComponent {
    private static CrosstabDebugConsoleTopComponent instance;
    private static final String PREFERRED_ID = "CrosstabDebugConsoleTopComponent";
    private JButton jButton1;
    private JPanel jPanel1;

    private CrosstabDebugConsoleTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(CrosstabDebugConsoleTopComponent.class, (String)"CTL_CrosstabDebugConsoleTopComponent"));
        this.setToolTipText(NbBundle.getMessage(CrosstabDebugConsoleTopComponent.class, (String)"HINT_CrosstabDebugConsoleTopComponent"));
    }

    private JButton createButton(CellInfo ci) {
        JCellButton b = new JCellButton(ci);
        return b;
    }

    private GridBagConstraints createConstraints(CellInfo ci, int crosstabWidth, int crosstabHeight) {
        return new GridBagConstraints(ci.getX(), ci.getY(), ci.getColSpan(), ci.getRowSpan(), (double)ci.getCellContents().getWidth() * 1.0 / (double)crosstabWidth, (double)ci.getCellContents().getHeight() * 1.0 / (double)crosstabHeight, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jPanel1 = new JPanel();
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(CrosstabDebugConsoleTopComponent.class, (String)"CrosstabDebugConsoleTopComponent.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabDebugConsoleTopComponent.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setLayout(new GridLayout(1, 0));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButton1).add(88, 88, 88)).add((Component)this.jPanel1, -1, 155, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -1, 275, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton1).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jPanel1.removeAll();
        JrxmlVisualView view = IReportManager.getInstance().getActiveVisualView();
        if (view == null) {
            this.jPanel1.updateUI();
            return;
        }
        AbstractReportObjectScene scene = view.getReportDesignerPanel().getActiveScene();
        if (scene instanceof CrosstabObjectScene) {
            int i;
            CellInfo ci;
            CellInfo ci2;
            CellInfo ci3;
            JRCrosstabColumnGroup group;
            int i2;
            int i3;
            ArrayList<CellInfo> cellInfos = new ArrayList<CellInfo>();
            JRDesignCrosstab crosstab = ((CrosstabObjectScene)scene).getDesignCrosstab();
            JRCrosstabRowGroup[] row_groups = crosstab.getRowGroups();
            JRCrosstabColumnGroup[] col_groups = crosstab.getColumnGroups();
            Point size = new Point(0, 1);
            for (i3 = 0; i3 < row_groups.length; ++i3) {
                ++size.x;
            }
            for (i3 = 0; i3 < col_groups.length; ++i3) {
                JRCrosstabColumnGroup group2 = col_groups[i3];
                ++size.x;
                if (group2.getTotalPositionValue() == CrosstabTotalPositionEnum.NONE) continue;
                ++size.x;
            }
            this.jPanel1.setLayout(new GridBagLayout());
            int x = 0;
            int y = 0;
            if (crosstab.getHeaderCell() != null) {
                CellInfo ci4 = new CellInfo(x, y, row_groups.length, col_groups.length, crosstab.getHeaderCell());
                cellInfos.add(ci4);
            }
            x = row_groups.length;
            y = 0;
            int w = col_groups.length;
            int h = col_groups.length;
            for (i2 = 0; i2 < col_groups.length; ++i2) {
                group = col_groups[i2];
                if (group.getTotalPositionValue() != CrosstabTotalPositionEnum.START) {
                    ci3 = new CellInfo(x, y, 1, h, group.getTotalHeader());
                    cellInfos.add(ci3);
                    ++x;
                }
                ci2 = new CellInfo(x, y, w, 1, group.getHeader());
                cellInfos.add(ci2);
                if (group.getTotalPositionValue() != CrosstabTotalPositionEnum.END) {
                    ci = new CellInfo(x + w, y, 1, h, group.getTotalHeader());
                    cellInfos.add(ci);
                }
                --w;
                --h;
                ++y;
            }
            x = 0;
            y = col_groups.length;
            w = row_groups.length;
            h = row_groups.length;
            for (i2 = 0; i2 < row_groups.length; ++i2) {
                group = row_groups[i2];
                if (group.getTotalPositionValue() != CrosstabTotalPositionEnum.START) {
                    ci3 = new CellInfo(x, y, w, 1, group.getTotalHeader());
                    cellInfos.add(ci3);
                    ++y;
                }
                ci2 = new CellInfo(x, y, 1, h, group.getHeader());
                cellInfos.add(ci2);
                if (group.getTotalPositionValue() != CrosstabTotalPositionEnum.END) {
                    ci = new CellInfo(x, y + h, w, 1, group.getTotalHeader());
                    cellInfos.add(ci);
                }
                --w;
                --h;
                ++x;
            }
            x = row_groups.length;
            y = col_groups.length;
            JRCrosstabCell[][] cells = crosstab.getCells();
            cells = ModelUtils.normalizeCell(cells, row_groups, col_groups);
            for (int i4 = 0; i4 < cells.length; ++i4) {
                for (int k = 0; k < cells[i4].length; ++k) {
                    int cx = x + cells[i4].length - k - 1;
                    int cy = y + cells.length - i4 - 1;
                    if (cells[i4][k] == null) continue;
                    String cellName = ModelUtils.nameOf((JRDesignCellContents)cells[i4][k].getContents());
                    CellInfo ci5 = new CellInfo(cx, cy, 1, 1, cells[i4][k].getContents());
                    cellInfos.add(ci5);
                }
            }
            int crosstabWidth = 1;
            int crosstabHeight = 1;
            for (i = 0; i < cellInfos.size(); ++i) {
                CellInfo ci6 = (CellInfo)cellInfos.get(i);
                int posX = 0;
                int posY = 0;
                block7: for (int index = 0; index < ci6.getX(); ++index) {
                    for (int k = 0; k < cellInfos.size(); ++k) {
                        CellInfo ci22 = (CellInfo)cellInfos.get(k);
                        if (ci22.getX() != index) continue;
                        posX += ci22.getCellContents().getWidth();
                        continue block7;
                    }
                }
                ci6.setLeft(posX);
                int thisW = ci6.getLeft() + ci6.getCellContents().getWidth();
                if (thisW > crosstabWidth) {
                    crosstabWidth = thisW;
                }
                block9: for (int index = 0; index < ci6.getY(); ++index) {
                    for (int k = 0; k < cellInfos.size(); ++k) {
                        CellInfo ci23 = (CellInfo)cellInfos.get(k);
                        if (ci23.getY() != index) continue;
                        posY += ci23.getCellContents().getHeight();
                        continue block9;
                    }
                }
                ci6.setTop(posY);
                int thisH = ci6.getTop() + ci6.getCellContents().getHeight();
                if (thisH <= crosstabHeight) continue;
                crosstabHeight = thisH;
            }
            for (i = 0; i < cellInfos.size(); ++i) {
                CellInfo ci7 = (CellInfo)cellInfos.get(i);
                this.jPanel1.add((Component)this.createButton(ci7), this.createConstraints(ci7, crosstabWidth, crosstabHeight));
            }
            this.jPanel1.updateUI();
        }
    }

    public static synchronized CrosstabDebugConsoleTopComponent getDefault() {
        if (instance == null) {
            instance = new CrosstabDebugConsoleTopComponent();
        }
        return instance;
    }

    public static synchronized CrosstabDebugConsoleTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(CrosstabDebugConsoleTopComponent.class.getName()).warning("Cannot find CrosstabDebugConsoleTopComponent component. It will not be located properly in the window system.");
            return CrosstabDebugConsoleTopComponent.getDefault();
        }
        if (win instanceof CrosstabDebugConsoleTopComponent) {
            return (CrosstabDebugConsoleTopComponent)win;
        }
        Logger.getLogger(CrosstabDebugConsoleTopComponent.class.getName()).warning("There seem to be multiple components with the 'CrosstabDebugConsoleTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return CrosstabDebugConsoleTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return CrosstabDebugConsoleTopComponent.getDefault();
        }
    }
}

