/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;

public class SimpleJasperReportsContext
implements JasperReportsContext {
    private JasperReportsContext parent;
    private Map<String, Object> values = new HashMap<String, Object>();
    private Map<String, String> properties;
    private Map<Class<?>, List<?>> extensionsMap;

    public SimpleJasperReportsContext() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public SimpleJasperReportsContext(JasperReportsContext parent) {
        this.parent = parent;
    }

    public void setParent(JasperReportsContext parent) {
        this.parent = parent;
    }

    @Override
    public Object getValue(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        if (this.parent != null) {
            return this.parent.getValue(key);
        }
        return null;
    }

    @Override
    public void setValue(String key, Object value) {
        this.values.put(key, value);
    }

    public void removeValue(String key) {
        this.values.remove(key);
    }

    @Override
    public <T> List<T> getExtensions(Class<T> extensionType) {
        if (this.extensionsMap == null || !this.extensionsMap.containsKey(extensionType)) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getExtensions(extensionType);
        }
        List<?> extensionsList = this.extensionsMap.get(extensionType);
        if (this.parent == null) {
            return extensionsList;
        }
        List<T> parentExtensions = this.parent.getExtensions(extensionType);
        if (extensionsList == null || extensionsList.isEmpty()) {
            if (parentExtensions == null || parentExtensions.isEmpty()) {
                return null;
            }
            return parentExtensions;
        }
        if (parentExtensions == null || parentExtensions.isEmpty()) {
            return extensionsList;
        }
        ArrayList<Object> returnedList = new ArrayList<Object>();
        returnedList.addAll(extensionsList);
        returnedList.addAll(parentExtensions);
        return returnedList;
    }

    public <T> void setExtensions(Class<T> extensionType, List<? extends T> extensions) {
        if (this.extensionsMap == null) {
            this.extensionsMap = new HashMap();
        }
        this.extensionsMap.put(extensionType, extensions);
    }

    public void setExtensions(Map<Class<?>, List<?>> extensions) {
        this.extensionsMap = extensions;
    }

    @Override
    public String getProperty(String key) {
        if (this.properties != null && this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getProperty(key);
    }

    @Override
    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    @Override
    public void removeProperty(String key) {
        if (this.properties != null) {
            this.properties.remove(key);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getProperties();
        }
        if (this.parent == null) {
            return this.properties;
        }
        Map<String, String> parentProperties = this.parent.getProperties();
        if (this.properties == null || this.properties.isEmpty()) {
            if (parentProperties == null || parentProperties.isEmpty()) {
                return null;
            }
            return parentProperties;
        }
        if (parentProperties == null || parentProperties.isEmpty()) {
            return this.properties;
        }
        HashMap<String, String> returnedMap = new HashMap<String, String>();
        returnedMap.putAll(parentProperties);
        returnedMap.putAll(this.properties);
        return returnedMap;
    }
}

