/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class PptxRunHelper
extends BaseHelper {
    private Map<String, String> fontMap;
    private String exporterKey;

    public PptxRunHelper(Writer writer, Map<String, String> fontMap, String exporterKey) {
        super(writer);
        this.fontMap = fontMap;
        this.exporterKey = exporterKey;
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) {
        this.export(style, attributes, text, locale, null);
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, String invalidCharReplacement) {
        if (text != null) {
            StringTokenizer tkzer = new StringTokenizer(text, "\n", true);
            while (tkzer.hasMoreTokens()) {
                String token = tkzer.nextToken();
                if ("\n".equals(token)) {
                    this.write("<a:br/>");
                    continue;
                }
                this.write("      <a:r>\n");
                this.exportProps("a:rPr", this.getAttributes(style), attributes, locale);
                this.write("<a:t>");
                this.write(JRStringUtil.xmlEncode(token, invalidCharReplacement));
                this.write("</a:t>\n");
                this.write("      </a:r>\n");
            }
        }
    }

    public void exportProps(JRStyle style, Locale locale) {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        JRFontUtil.getAttributesWithoutAwtFont(styledTextAttributes, text);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (style.getModeValue() == null || style.getModeValue() == ModeEnum.OPAQUE) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, style.getBackcolor());
        }
        this.exportProps("a:rPr", this.getAttributes(style.getStyle()), this.getAttributes(style), locale);
    }

    public void exportProps(JRPrintText text, Locale locale) {
        HashMap<AttributedCharacterIterator.Attribute, Object> textAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        JRFontUtil.getAttributesWithoutAwtFont(textAttributes, text);
        textAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (text.getModeValue() == null || text.getModeValue() == ModeEnum.OPAQUE) {
            textAttributes.put(TextAttribute.BACKGROUND, text.getBackcolor());
        }
        this.exportProps("a:defRPr", new HashMap<AttributedCharacterIterator.Attribute, Object>(), textAttributes, locale);
    }

    private void exportProps(String tag, Map<AttributedCharacterIterator.Attribute, Object> parentAttrs, Map<AttributedCharacterIterator.Attribute, Object> attrs, Locale locale) {
        float fontSize;
        this.write("       <" + tag + "\n");
        Object value = attrs.get(TextAttribute.SIZE);
        Object oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            fontSize = ((Float)value).floatValue();
            fontSize = fontSize == 0.0f ? 0.5f : fontSize;
            this.write(" sz=\"" + (int)(100.0f * fontSize) + "\"");
        } else {
            fontSize = ((Float)oldValue).floatValue();
            this.write(" sz=\"" + (int)(100.0f * fontSize) + "\"");
        }
        value = attrs.get(TextAttribute.WEIGHT);
        oldValue = parentAttrs.get(TextAttribute.WEIGHT);
        if (value != null && !value.equals(oldValue)) {
            this.write(" b=\"" + (value.equals(TextAttribute.WEIGHT_BOLD) ? 1 : 0) + "\"");
        }
        value = attrs.get(TextAttribute.POSTURE);
        oldValue = parentAttrs.get(TextAttribute.POSTURE);
        if (value != null && !value.equals(oldValue)) {
            this.write(" i=\"" + (value.equals(TextAttribute.POSTURE_OBLIQUE) ? 1 : 0) + "\"");
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.write(" u=\"" + (value == null ? "none" : "sng") + "\"");
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.write(" strike=\"" + (value == null ? "noStrike" : "sngStrike") + "\"");
        }
        value = attrs.get(TextAttribute.SUPERSCRIPT);
        this.write(">\n");
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            this.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa((Color)value) + "\"/></a:solidFill>\n");
        }
        value = attrs.get(TextAttribute.BACKGROUND);
        oldValue = parentAttrs.get(TextAttribute.BACKGROUND);
        value = attrs.get(TextAttribute.FAMILY);
        oldValue = parentAttrs.get(TextAttribute.FAMILY);
        if (value != null && !value.equals(oldValue)) {
            String fontFamilyAttr;
            String fontFamily = fontFamilyAttr = (String)value;
            if (this.fontMap != null && this.fontMap.containsKey(fontFamilyAttr)) {
                fontFamily = this.fontMap.get(fontFamilyAttr);
            } else {
                FontFamily family;
                String exportFont;
                FontInfo fontInfo = JRFontUtil.getFontInfo(fontFamilyAttr, locale);
                if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.exporterKey)) != null) {
                    fontFamily = exportFont;
                }
            }
            this.write("        <a:latin typeface=\"" + fontFamily + "\"/>\n");
            this.write("        <a:ea typeface=\"" + fontFamily + "\"/>\n");
            this.write("        <a:cs typeface=\"" + fontFamily + "\"/>\n");
        }
        this.write("</" + tag + ">\n");
    }

    private Map<AttributedCharacterIterator.Attribute, Object> getAttributes(JRStyle style) {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        JRFontUtil.getAttributesWithoutAwtFont(styledTextAttributes, text);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, text.getBackcolor());
        }
        return styledTextAttributes;
    }
}

