/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;

public class JRSqlLessOrGreaterClause
implements JRClauseFunction {
    protected static final int POSITION_CLAUSE_ID = 0;
    protected static final int POSITION_DB_COLUMN = 1;
    protected static final int POSITION_PARAMETER = 2;
    protected static final String OPERATOR_LESS = "<";
    protected static final String OPERATOR_LESS_OR_EQUAL = "<=";
    protected static final String OPERATOR_GREATER = ">";
    protected static final String OPERATOR_GREATER_OR_EQUAL = ">=";
    protected static final String CLAUSE_TRUISM = "0 = 0";
    protected static final JRSqlLessOrGreaterClause singleton = new JRSqlLessOrGreaterClause();

    public static JRSqlLessOrGreaterClause instance() {
        return singleton;
    }

    @Override
    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        String clauseId = clauseTokens.getToken(0);
        String col = clauseTokens.getToken(1);
        String param = clauseTokens.getToken(2);
        if (clauseId == null) {
            throw new JRRuntimeException("Missing clause name token");
        }
        if (col == null) {
            throw new JRRuntimeException("SQL LESS/GREATER clause missing DB column token");
        }
        if (param == null) {
            throw new JRRuntimeException("SQL LESS/GREATER clause missing parameter token");
        }
        Object paramValue = queryContext.getValueParameter(param).getValue();
        StringBuffer sbuffer = queryContext.queryBuffer();
        if (paramValue == null) {
            sbuffer.append(CLAUSE_TRUISM);
            return;
        }
        sbuffer.append(col);
        sbuffer.append(' ');
        this.handleLessOrGreaterOperator(sbuffer, clauseId);
        sbuffer.append(' ');
        sbuffer.append('?');
        queryContext.addQueryParameter(param);
    }

    protected void handleLessOrGreaterOperator(StringBuffer sBuffer, String clauseId) {
        if ("LESS".equals(clauseId)) {
            sBuffer.append(OPERATOR_LESS);
        } else if ("LESS]".equals(clauseId)) {
            sBuffer.append(OPERATOR_LESS_OR_EQUAL);
        } else if ("GREATER".equals(clauseId)) {
            sBuffer.append(OPERATOR_GREATER);
        } else if ("[GREATER".equals(clauseId)) {
            sBuffer.append(OPERATOR_GREATER_OR_EQUAL);
        }
    }
}

