/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.map;

import com.jaspersoft.ireport.components.map.MapMarkersPanel;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.undo.AddDatasetUndoableEdit;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.DatasetWizardIterator;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.map.MarkerDataset;
import net.sf.jasperreports.components.map.StandardMapComponent;
import net.sf.jasperreports.components.map.StandardMarkerDataset;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class EditMarkerDatasetAction
extends NodeAction {
    public String getName() {
        return I18n.getString((String)"EditMarkerDatasetAction.name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        ElementNode node = (ElementNode)activatedNodes[0];
        if (node.getElement() instanceof JRDesignComponentElement && ((JRDesignComponentElement)node.getElement()).getComponent() instanceof StandardMapComponent) {
            JRDesignDatasetRun datasetRun;
            JRDesignDataset newDataset = null;
            if (IReportManager.getInstance().getActiveReport().getDatasetsList().isEmpty()) {
                int answer = JOptionPane.showConfirmDialog(Misc.getMainFrame(), "There are not subdatasets to be used with the map.\nDo you want to create a subdataset now?");
                if (answer == 0) {
                    newDataset = this.createDataset();
                    if (newDataset == null) {
                        return;
                    }
                } else {
                    return;
                }
            }
            MapMarkersPanel panel = new MapMarkersPanel();
            panel.setShowRemoveDatasetRun(true);
            panel.setJasperDesign(node.getJasperDesign());
            StandardMapComponent component = (StandardMapComponent)((JRDesignComponentElement)node.getElement()).getComponent();
            StandardMarkerDataset markerDataset = (StandardMarkerDataset)component.getMarkerDataset();
            if (markerDataset == null) {
                markerDataset = new StandardMarkerDataset();
            }
            if ((datasetRun = (JRDesignDatasetRun)markerDataset.getDatasetRun()) == null) {
                datasetRun = new JRDesignDatasetRun();
                if (newDataset != null) {
                    datasetRun.setDatasetName(newDataset.getName());
                } else {
                    datasetRun.setDatasetName(((JRDataset)IReportManager.getInstance().getActiveReport().getDatasetsList().get(0)).getName());
                }
                datasetRun.setDataSourceExpression((JRExpression)Misc.createExpression(null, (String)"new net.sf.jasperreports.engine.JREmptyDataSource(1)"));
                markerDataset.setDatasetRun((JRDatasetRun)datasetRun);
            }
            panel.setMarkerDataset(markerDataset);
            int res = panel.showDialog(Misc.getMainFrame(), true);
            if (res == 0 || res == 1) {
                MarkerDataset oldValue = component.getMarkerDataset();
                StandardMarkerDataset newValue = panel.getMarkerDataset();
                component.setMarkerDataset((MarkerDataset)panel.getMarkerDataset());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit((Object)component, "MarkerDataset", MarkerDataset.class, (Object)oldValue, (Object)newValue);
                IReportManager.getInstance().addUndoableEdit((UndoableEdit)urob);
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        if (!(activatedNodes[0] instanceof ElementNode)) {
            return false;
        }
        ElementNode node = (ElementNode)activatedNodes[0];
        return node.getElement() instanceof JRDesignComponentElement && ((JRDesignComponentElement)node.getElement()).getComponent() instanceof StandardMapComponent;
    }

    protected JRDesignDataset createDataset() {
        try {
            boolean cancelled;
            JasperDesign jd = IReportManager.getInstance().getActiveReport();
            DatasetWizardIterator iterator = new DatasetWizardIterator();
            WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
            iterator.initialize(wizardDescriptor, jd);
            wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
            wizardDescriptor.setTitle("New Dataset");
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            dialog.setVisible(true);
            dialog.toFront();
            boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
            if (!cancelled) {
                JRDesignDataset newDataset = new JRDesignDataset(false);
                newDataset.setName((String)wizardDescriptor.getProperty("dataset_name"));
                ArrayList selectedFields = (ArrayList)wizardDescriptor.getProperty("selectedFields");
                ArrayList groupFields = (ArrayList)wizardDescriptor.getProperty("groupFields");
                String query = (String)wizardDescriptor.getProperty("query");
                String queryLanguage = (String)wizardDescriptor.getProperty("queryLanguage");
                if (selectedFields == null) {
                    selectedFields = new ArrayList();
                }
                if (groupFields == null) {
                    groupFields = new ArrayList();
                }
                for (JRDesignField f : selectedFields) {
                    newDataset.addField((JRField)f);
                }
                if (query != null) {
                    JRDesignQuery designQuery = new JRDesignQuery();
                    designQuery.setText(query);
                    if (queryLanguage != null) {
                        designQuery.setLanguage(queryLanguage);
                    }
                    newDataset.setQuery(designQuery);
                }
                for (int i = 0; i < groupFields.size(); ++i) {
                    JRDesignGroup g = new JRDesignGroup();
                    g.setName(((JRDesignField)groupFields.get(i)).getName());
                    g.setExpression((JRExpression)Misc.createExpression((String)((JRDesignField)groupFields.get(i)).getValueClassName(), (String)("$F{" + ((JRDesignField)groupFields.get(i)).getName() + "}")));
                    newDataset.addGroup(g);
                }
                jd.addDataset(newDataset);
                AddDatasetUndoableEdit edit = new AddDatasetUndoableEdit(newDataset, jd);
                IReportManager.getInstance().addUndoableEdit((UndoableEdit)edit);
                return newDataset;
            }
        }
        catch (JRException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

