/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.sort.properties;

import com.jaspersoft.ireport.components.sort.properties.SortFieldCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class SortFieldPickerPanel
extends JPanel {
    private static String PROPERTY_VALUE_SELECTED = "VALUE_SELECTED";
    private JRDesignDataset dataset = null;
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public SortFieldPickerPanel() {
        this.initComponents();
        this.jList1.setCellRenderer(new SortFieldCellRenderer());
        this.jList1.setModel(new DefaultListModel());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel1.setText(NbBundle.getMessage(SortFieldPickerPanel.class, (String)"SortFieldPickerPanel.jLabel1.text"));
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SortFieldPickerPanel.this.jList1MouseClicked(evt);
            }
        });
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SortFieldPickerPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jScrollPane1).add(1, (Component)this.jLabel1, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 249, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.firePropertyChange(PROPERTY_VALUE_SELECTED, null, this.jList1.getSelectedValue());
    }

    private void jList1MouseClicked(MouseEvent evt) {
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        ArrayList newList = new ArrayList();
        newList.addAll(dataset.getFieldsList());
        newList.addAll(dataset.getVariablesList());
        Object[] objs = newList.toArray();
        Arrays.sort(objs, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = null;
                String name2 = null;
                if (o1 instanceof JRDesignField && o2 instanceof JRDesignVariable) {
                    return 1;
                }
                if (o2 instanceof JRDesignField && o1 instanceof JRDesignVariable) {
                    return -1;
                }
                if (o1 instanceof JRDesignField) {
                    name1 = ((JRDesignField)o1).getName();
                } else if (o1 instanceof JRDesignVariable) {
                    name1 = ((JRDesignVariable)o1).getName();
                }
                if (o2 instanceof JRDesignField) {
                    name2 = ((JRDesignField)o1).getName();
                }
                if (o2 instanceof JRDesignVariable) {
                    name2 = ((JRDesignVariable)o1).getName();
                }
                if (name1 == null || name2 == null) {
                    return 0;
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
        this.dataset = dataset;
        DefaultListModel<String> dlm = new DefaultListModel<String>();
        for (Object obj : newList) {
            if (obj == null) continue;
            if (obj instanceof JRVariable) {
                dlm.addElement("V" + ((JRVariable)obj).getName());
                continue;
            }
            if (!(obj instanceof JRField)) continue;
            dlm.addElement("F" + ((JRField)obj).getName());
        }
        this.jList1.setModel(dlm);
    }

    public void setSelectedValue(String obj) {
        this.jList1.setSelectedValue(obj, true);
    }

    public String getSelectedValue() {
        return (String)this.jList1.getSelectedValue();
    }
}

