/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend.form;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.FormField;
import org.xhtmlrenderer.simple.extend.form.FormFieldState;
import org.xhtmlrenderer.util.GeneralUtil;

class SelectField
extends FormField {
    public SelectField(Element e, XhtmlForm form) {
        super(e, form);
    }

    public JComponent create() {
        List optionList = this.createList();
        if (this.shouldRenderAsList()) {
            JList<Object> select = new JList<Object>(optionList.toArray());
            if (this.hasAttribute("multiple") && this.getAttribute("multiple").equals("true")) {
                select.setSelectionMode(2);
            } else {
                select.setSelectionMode(0);
            }
            int size = 0;
            if (this.hasAttribute("size")) {
                size = GeneralUtil.parseIntRelaxed(this.getAttribute("size"));
            }
            if (size == 0) {
                select.setVisibleRowCount(Math.min(select.getModel().getSize(), 20));
            } else {
                select.setVisibleRowCount(size);
            }
            return new JScrollPane(select);
        }
        JComboBox<Object> select = new JComboBox<Object>(optionList.toArray());
        select.setEditable(false);
        return select;
    }

    protected FormFieldState loadOriginalState() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        NodeList options = this.getElement().getElementsByTagName("option");
        for (int i = 0; i < options.getLength(); ++i) {
            Element option = (Element)options.item(i);
            if (!option.hasAttribute("selected") || !option.getAttribute("selected").equals("selected")) continue;
            list.add(new Integer(i));
        }
        return FormFieldState.fromList(list);
    }

    protected void applyOriginalState() {
        if (this.shouldRenderAsList()) {
            JList select = (JList)((JScrollPane)this.getComponent()).getViewport().getView();
            select.setSelectedIndices(this.getOriginalState().getSelectedIndices());
        } else {
            JComboBox select = (JComboBox)this.getComponent();
            int[] indices = this.getOriginalState().getSelectedIndices();
            if (indices.length == 0) {
                select.setSelectedIndex(0);
            } else {
                select.setSelectedIndex(indices[indices.length - 1]);
            }
        }
    }

    protected String[] getFieldValues() {
        if (this.shouldRenderAsList()) {
            JList select = (JList)((JScrollPane)this.getComponent()).getViewport().getView();
            Object[] selectedValues = select.getSelectedValues();
            String[] submitValues = new String[selectedValues.length];
            for (int i = 0; i < selectedValues.length; ++i) {
                submitValues[i] = ((NameValuePair)selectedValues[i]).getValue();
            }
            return submitValues;
        }
        JComboBox select = (JComboBox)this.getComponent();
        NameValuePair selectedValue = (NameValuePair)select.getSelectedItem();
        if (selectedValue == null) {
            return new String[0];
        }
        return new String[]{selectedValue.getValue()};
    }

    private List createList() {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        NodeList options = this.getElement().getElementsByTagName("option");
        for (int i = 0; i < options.getLength(); ++i) {
            String optionText;
            Element option = (Element)options.item(i);
            String optionValue = optionText = XhtmlForm.collectText(option);
            if (option.hasAttribute("value")) {
                optionValue = option.getAttribute("value");
            }
            list.add(new NameValuePair(optionText, optionValue));
        }
        return list;
    }

    private boolean shouldRenderAsList() {
        int size;
        boolean result = false;
        if (this.hasAttribute("multiple") && this.getAttribute("multiple").equals("true")) {
            result = true;
        } else if (this.hasAttribute("size") && (size = GeneralUtil.parseIntRelaxed(this.getAttribute("size"))) > 0) {
            result = true;
        }
        return result;
    }

    private static class NameValuePair {
        private String _name;
        private String _value;

        public NameValuePair(String name, String value) {
            this._name = name;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this.getName();
        }
    }
}

