/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;

public final class JRHyperlinkHelper {
    public static byte getHyperlinkType(JRHyperlink hyperlink) {
        return JRHyperlinkHelper.getHyperlinkTypeValue(hyperlink.getLinkType()).getValue();
    }

    public static HyperlinkTypeEnum getHyperlinkTypeValue(JRHyperlink hyperlink) {
        return JRHyperlinkHelper.getHyperlinkTypeValue(hyperlink.getLinkType());
    }

    public static byte getHyperlinkType(String linkType) {
        return JRHyperlinkHelper.getHyperlinkTypeValue(linkType).getValue();
    }

    public static HyperlinkTypeEnum getHyperlinkTypeValue(String linkType) {
        HyperlinkTypeEnum builtinType;
        HyperlinkTypeEnum type = linkType == null ? HyperlinkTypeEnum.NONE : ((builtinType = HyperlinkTypeEnum.getByName(linkType)) == null ? HyperlinkTypeEnum.CUSTOM : builtinType);
        return type;
    }

    public static byte getHyperlinkTarget(JRHyperlink hyperlink) {
        return JRHyperlinkHelper.getHyperlinkTarget(hyperlink.getLinkTarget());
    }

    public static byte getHyperlinkTarget(String linkTarget) {
        return JRHyperlinkHelper.getHyperlinkTargetValue(linkTarget).getValue();
    }

    public static HyperlinkTargetEnum getHyperlinkTargetValue(String linkTarget) {
        HyperlinkTargetEnum builtinTarget;
        HyperlinkTargetEnum target = linkTarget == null ? HyperlinkTargetEnum.SELF : ((builtinTarget = HyperlinkTargetEnum.getByName(linkTarget)) == null ? HyperlinkTargetEnum.CUSTOM : builtinTarget);
        return target;
    }

    public static String getLinkType(byte hyperlinkType) {
        return JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(hyperlinkType));
    }

    public static String getLinkType(HyperlinkTypeEnum hyperlinkType) {
        String type;
        switch (hyperlinkType) {
            case NULL: 
            case NONE: {
                type = null;
                break;
            }
            case REFERENCE: 
            case LOCAL_ANCHOR: 
            case LOCAL_PAGE: 
            case REMOTE_ANCHOR: 
            case REMOTE_PAGE: {
                type = hyperlinkType.getName();
                break;
            }
            case CUSTOM: {
                throw new JRRuntimeException("Custom hyperlink types cannot be specified using the byte constant");
            }
            default: {
                throw new JRRuntimeException("Unknown hyperlink type " + hyperlinkType);
            }
        }
        return type;
    }

    public static String getLinkTarget(byte hyperlinkTarget) {
        return JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(hyperlinkTarget));
    }

    public static String getLinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        String target;
        switch (hyperlinkTarget) {
            case NONE: 
            case SELF: {
                target = null;
                break;
            }
            case BLANK: {
                target = HyperlinkTargetEnum.BLANK.getName();
                break;
            }
            case PARENT: {
                target = HyperlinkTargetEnum.PARENT.getName();
                break;
            }
            case TOP: {
                target = HyperlinkTargetEnum.TOP.getName();
                break;
            }
            case CUSTOM: {
                throw new JRRuntimeException("Custom hyperlink targets cannot be specified using the byte constant");
            }
            default: {
                throw new JRRuntimeException("Unknown hyperlink target " + hyperlinkTarget);
            }
        }
        return target;
    }

    public static boolean isEmpty(JRHyperlink hyperlink) {
        return hyperlink == null || hyperlink.getHyperlinkTypeValue() == HyperlinkTypeEnum.NONE && hyperlink.getHyperlinkTooltipExpression() == null;
    }

    private JRHyperlinkHelper() {
    }
}

