/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.DiagramAbstractEntity;
import nickyb.sqleonardo.querybuilder.DiagramField;
import nickyb.sqleonardo.querybuilder.DiagramLoader;
import nickyb.sqleonardo.querybuilder.MaskReferences;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class DiagramEntity
extends DiagramAbstractEntity {
    private QueryTokens.Table querytoken;
    private static ImageIcon icon;

    DiagramEntity(QueryBuilder builder, QueryTokens.Table qtoken) {
        super(builder);
        if (icon == null) {
            icon = new ImageIcon(this.getClass().getResource("/images/database_table.png"));
        }
        this.getHeaderMenu().setIcon(icon);
        this.getHeaderMenu().addSeparator();
        this.getHeaderMenu().add(new ActionOpenAllForeignTables());
        this.getHeaderMenu().add(new ActionOpenAllPrimaryTables());
        this.getHeaderMenu().addSeparator();
        this.getHeaderMenu().add(new ActionReferences());
        this.setQueryToken(qtoken);
    }

    void onCreate() {
        this.builder.browser.addFromClause(this.querytoken);
        this.doFlush();
    }

    void onDestroy() {
        this.fireDeselectAll();
        this.builder.diagram.removeAllRelation(this);
        this.builder.browser.removeFromClause(this.querytoken);
    }

    DiagramField addField(int ordinalPosition, String label, Object key) {
        DiagramField df = new DiagramField(this, label, key != null);
        df.position = ordinalPosition;
        QueryTokens.Column ctoken = new QueryTokens.Column(this.querytoken, label);
        df.setQueryToken(ctoken);
        this.addField(df);
        return df;
    }

    public QueryTokens.Table getQueryToken() {
        return this.querytoken;
    }

    public void setQueryToken(QueryTokens.Table querytoken) {
        this.querytoken = querytoken;
        this.getHeaderMenu().setText(querytoken.getReference());
        this.getHeaderMenu().setToolTipText(querytoken.isAliasSet() ? querytoken.toString() : null);
        this.pack();
    }

    private class ActionReferences
    extends AbstractAction {
        private ActionReferences() {
            super(I18n.getString("querybuilder.menu.references", "references..."));
        }

        public void actionPerformed(ActionEvent e) {
            new MaskReferences(DiagramEntity.this, DiagramEntity.this.builder).showDialog();
        }
    }

    private class ActionOpenAllPrimaryTables
    extends AbstractAction {
        private ActionOpenAllPrimaryTables() {
            super(I18n.getString("querybuilder.menu.openAllPrimaryTables", "open all primary tables"));
        }

        public void actionPerformed(ActionEvent e) {
            DiagramLoader.run(2, DiagramEntity.this.builder, DiagramEntity.this.getQueryToken(), true);
        }
    }

    private class ActionOpenAllForeignTables
    extends AbstractAction {
        private ActionOpenAllForeignTables() {
            super(I18n.getString("querybuilder.menu.openAllForeignTables", "open all foreign tables"));
        }

        public void actionPerformed(ActionEvent e) {
            DiagramLoader.run(1, DiagramEntity.this.builder, DiagramEntity.this.getQueryToken(), true);
        }
    }
}

