/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.Iterator;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.MatchType;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class DimensionBase
extends OlapElementBase
implements Dimension {
    protected final String name;
    protected final String uniqueName;
    protected final String description;
    protected final boolean highCardinality;
    protected Hierarchy[] hierarchies;
    protected DimensionType dimensionType;

    protected DimensionBase(String name, String caption, String description, DimensionType dimensionType, boolean highCardinality) {
        this.name = name;
        this.caption = caption;
        this.uniqueName = Util.makeFqName(name);
        this.description = description;
        this.dimensionType = dimensionType;
        this.highCardinality = highCardinality;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Hierarchy[] getHierarchies() {
        return this.hierarchies;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchies[0];
    }

    public Dimension getDimension() {
        return this;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxDimensionName.str(this.getUniqueName());
    }

    public boolean isMeasures() {
        return this.getUniqueName().equals("[Measures]");
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        OlapElement oe = this.lookupHierarchy(s);
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            OlapElement oeLevel;
            if ((oe == null || oe.getName().equalsIgnoreCase(this.getName())) && (oeLevel = this.getHierarchy().lookupChild(schemaReader, s, matchType)) != null) {
                oe = oeLevel;
            }
        } else if (oe == null) {
            Hierarchy hierarchy;
            Iterator<Hierarchy> i$ = schemaReader.getDimensionHierarchies(this).iterator();
            while (i$.hasNext() && (oe = (hierarchy = i$.next()).lookupChild(schemaReader, s, matchType)) == null) {
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("DimensionBase.lookupChild: ");
            buf.append("name=");
            buf.append(this.getName());
            buf.append(", childname=");
            buf.append(s);
            if (oe == null) {
                buf.append(" returning null");
            } else {
                buf.append(" returning elementname=" + oe.getName());
            }
            this.getLogger().debug((Object)buf.toString());
        }
        return oe;
    }

    public boolean isHighCardinality() {
        return this.highCardinality;
    }

    private Hierarchy lookupHierarchy(Id.Segment s) {
        for (Hierarchy hierarchy : this.hierarchies) {
            if (!Util.equalName(hierarchy.getName(), s.name)) continue;
            return hierarchy;
        }
        return null;
    }
}

