/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl;

import com.jaspersoft.ireport.designer.IReportManager;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 *
 * @author  gtoffoli
 */
public class DateTimeInputControlUI extends javax.swing.JPanel implements InputControlUI {
    
    /** Creates new form BasicInputControlUI */
    public DateTimeInputControlUI() {
        initComponents();
        jSpinnerH.setModel( new javax.swing.SpinnerNumberModel(0,0,23,1));
        jSpinnerM.setModel( new javax.swing.SpinnerNumberModel(0,0,59,1));
        jSpinnerS.setModel( new javax.swing.SpinnerNumberModel(0,0,59,1));

    }
    
    public Object getValue()
    {
        if (IReportManager.getPreferences().getBoolean("jasperserver.useRelativeDateExpressions", true))
        {
            if (dateRangePicker.getDateRangeExpression() != null)
            {
                return dateRangePicker.getDateRangeExpression();

            }
        }
        
        Date date = dateRangePicker.getDate();
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.set(GregorianCalendar.HOUR, ((Number)jSpinnerH.getValue()).intValue());
        gc.set(GregorianCalendar.MINUTE, ((Number)jSpinnerH.getValue()).intValue());
        gc.set(GregorianCalendar.SECOND, ((Number)jSpinnerH.getValue()).intValue());
        
        return gc.getTime();
    }
    
    public void setValue(Object v)
    {
        /*
        for (int i=0; i<getJComboBoxValue().getItemCount(); ++i)
        {
            Object val = getJComboBoxValue().getItemAt(i);
            if (val.equals( v))
            {
                getJComboBoxValue().setSelectedIndex(i);
                return;
            }
        }
        
        getJComboBoxValue().setSelectedItem(v);
        */
        if (v == null) return;
        if (v instanceof Date)
        {
            dateRangePicker.setDate((Date)v);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime((Date)v);
            jSpinnerH.setValue( gc.get(GregorianCalendar.HOUR));
            jSpinnerM.setValue( gc.get(GregorianCalendar.MINUTE));
            jSpinnerS.setValue( gc.get(GregorianCalendar.SECOND));
        }
        if (v instanceof String)
        {
            dateRangePicker.setDateRangeExpression((String)v);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelName = new javax.swing.JLabel();
        dateRangePicker = new com.jaspersoft.ireport.designer.compiler.prompt.DateRangeDatePicker();
        jLabelH = new javax.swing.JLabel();
        jSpinnerH = new javax.swing.JSpinner();
        jLabelMin = new javax.swing.JLabel();
        jSpinnerM = new javax.swing.JSpinner();
        jLabelSec = new javax.swing.JLabel();
        jSpinnerS = new javax.swing.JSpinner();

        setPreferredSize(new java.awt.Dimension(250, 40));
        setLayout(new java.awt.GridBagLayout());

        jLabelName.setText("jLabel1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabelName, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 14, 0, 4);
        add(dateRangePicker, gridBagConstraints);

        jLabelH.setText("Time");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 2);
        add(jLabelH, gridBagConstraints);

        jSpinnerH.setMinimumSize(new java.awt.Dimension(35, 18));
        jSpinnerH.setPreferredSize(new java.awt.Dimension(35, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        add(jSpinnerH, gridBagConstraints);

        jLabelMin.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        add(jLabelMin, gridBagConstraints);

        jSpinnerM.setMinimumSize(new java.awt.Dimension(35, 18));
        jSpinnerM.setPreferredSize(new java.awt.Dimension(35, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        add(jSpinnerM, gridBagConstraints);

        jLabelSec.setText(":");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        add(jLabelSec, gridBagConstraints);

        jSpinnerS.setMinimumSize(new java.awt.Dimension(35, 18));
        jSpinnerS.setPreferredSize(new java.awt.Dimension(35, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        add(jSpinnerS, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    
    public void setLabel(String lbl)
    {
        this.jLabelName.setText(lbl);
    }
    
    public void setHistory(java.util.List values){

    }
    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabelH;
    private javax.swing.JLabel jLabelMin;
    private javax.swing.JLabel jLabelName;
    private javax.swing.JLabel jLabelSec;
    private javax.swing.JSpinner jSpinnerH;
    private javax.swing.JSpinner jSpinnerM;
    private javax.swing.JSpinner jSpinnerS;
    private com.jaspersoft.ireport.designer.compiler.prompt.DateRangeDatePicker dateRangePicker;
    // End of variables declaration//GEN-END:variables
    
    public void setReadOnly( boolean b )
    {
        jLabelName.setEnabled(!b);
        dateRangePicker.setEnabled(!b);

    }

    public void addActionListener(ActionListener listener) {
        dateRangePicker.addActionListener(listener);
    }
}
