/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.installations.BundledInstallation;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallationManager {
    private static Logger LOGGER = Logger.getLogger(InstallationManager.class.getName());
    private static ArrayList<Installation> INSTALLATIONS = null;
    private static final String INSTALLATION_PROVIDER_PATH = "Databases/MySQL/Installations";

    public static synchronized List<Installation> getInstallations(Collection collection) {
        if (INSTALLATIONS == null) {
            BundledInstallation bundledInstallation = BundledInstallation.getDefault();
            if (bundledInstallation.isInstalled()) {
                ArrayList<Installation> arrayList = new ArrayList<Installation>();
                arrayList.add(bundledInstallation);
                return arrayList;
            }
            ArrayList<Installation> arrayList = new ArrayList<Installation>();
            ArrayList<Installation> arrayList2 = new ArrayList<Installation>();
            for (Installation installation : collection) {
                if (installation.isStackInstall()) {
                    arrayList.add(installation);
                    continue;
                }
                arrayList2.add(installation);
            }
            INSTALLATIONS = new ArrayList();
            INSTALLATIONS.addAll(arrayList);
            INSTALLATIONS.addAll(arrayList2);
        }
        return INSTALLATIONS;
    }

    public static Installation detectInstallation() {
        CopyOnWriteArrayList<Installation> copyOnWriteArrayList = new CopyOnWriteArrayList<Installation>();
        Collection collection = Lookups.forPath((String)INSTALLATION_PROVIDER_PATH).lookupAll(Installation.class);
        copyOnWriteArrayList.addAll(InstallationManager.getInstallations(collection));
        for (Installation installation : copyOnWriteArrayList) {
            LOGGER.log(Level.FINE, "Looking for MySQL installation " + installation.getStartCommand()[0] + installation.getStartCommand()[1]);
            if (!installation.isInstalled()) continue;
            LOGGER.log(Level.FINE, "Installation is installed");
            return installation;
        }
        return null;
    }
}

