/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map.fill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.map.Marker;
import net.sf.jasperreports.components.map.MarkerDataset;
import net.sf.jasperreports.components.map.fill.FillMarker;
import net.sf.jasperreports.components.map.fill.MarkerFillDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.FillContext;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;

public class FillMarkerDataset {
    protected List<Marker> markerList;
    protected MarkerFillDatasetRun datasetRun;
    protected JRFillExpressionEvaluator evaluator;

    public FillMarkerDataset(FillContext fillContext, MarkerDataset markerDataset, JRFillObjectFactory factory) throws JRException {
        factory.put(markerDataset, this);
        if (markerDataset.getDatasetRun() == null) {
            this.evaluator = fillContext;
        } else {
            this.datasetRun = new MarkerFillDatasetRun(markerDataset.getDatasetRun(), factory);
            this.evaluator = this.createDatasetExpressionEvaluator();
        }
        List<Marker> srcMarkerList = markerDataset.getMarkers();
        if (srcMarkerList != null && !srcMarkerList.isEmpty()) {
            this.markerList = new ArrayList<Marker>();
            for (Marker marker : srcMarkerList) {
                if (marker == null) continue;
                this.markerList.add(new FillMarker(marker, factory));
            }
        }
    }

    protected JRFillExpressionEvaluator createDatasetExpressionEvaluator() {
        return new JRFillExpressionEvaluator(){

            @Override
            public Object evaluate(JRExpression expression, byte evaluationType) throws JRException {
                return FillMarkerDataset.this.datasetRun.evaluateDatasetExpression(expression, evaluationType);
            }

            @Override
            public JRFillDataset getFillDataset() {
                return FillMarkerDataset.this.datasetRun.getDataset();
            }
        };
    }

    public List<Map<String, Object>> evaluateMarkers(byte evaluation) throws JRException {
        ArrayList<Map<String, Object>> markers = null;
        if (this.markerList != null) {
            markers = new ArrayList<Map<String, Object>>();
            if (this.datasetRun == null) {
                for (Marker marker : this.markerList) {
                    markers.add(((FillMarker)marker).evaluateProperties(this.evaluator, evaluation));
                }
            } else {
                this.datasetRun.evaluate(evaluation);
                this.datasetRun.start();
                while (this.datasetRun.next()) {
                    for (Marker marker : this.markerList) {
                        markers.add(((FillMarker)marker).evaluateProperties(this.evaluator, evaluation));
                    }
                }
                this.datasetRun.end();
            }
        }
        return markers;
    }
}

