/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.border.Border;

class VMDNodeBorder
implements Border {
    private Color colorBorder;
    private Insets insets;
    private Stroke stroke;
    private Color color1;
    private Color color2;
    private Color color3;
    private Color color4;
    private Color color5;

    VMDNodeBorder(Color color, int n, Color color2, Color color3, Color color4, Color color5, Color color6) {
        this.colorBorder = color;
        this.insets = new Insets(n, n, n, n);
        this.stroke = new BasicStroke(n);
        this.color1 = color2;
        this.color2 = color3;
        this.color3 = color4;
        this.color4 = color5;
        this.color5 = color6;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 4.0f, 4.0f));
        this.drawGradient(graphics2D, rectangle, this.color1, this.color2, 0.0f, 0.3f);
        this.drawGradient(graphics2D, rectangle, this.color2, this.color3, 0.3f, 0.764f);
        this.drawGradient(graphics2D, rectangle, this.color3, this.color4, 0.764f, 0.927f);
        this.drawGradient(graphics2D, rectangle, this.color4, this.color5, 0.927f, 1.0f);
        graphics2D.setColor(this.colorBorder);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(this.stroke);
        graphics2D.draw(new RoundRectangle2D.Float((float)rectangle.x + 0.5f, (float)rectangle.y + 0.5f, rectangle.width - 1, rectangle.height - 1, 4.0f, 4.0f));
        graphics2D.setStroke(stroke);
        graphics2D.setClip(shape);
    }

    private void drawGradient(Graphics2D graphics2D, Rectangle rectangle, Color color, Color color2, float f, float f2) {
        f = (float)rectangle.y + f * (float)rectangle.height;
        f2 = (float)rectangle.y + f2 * (float)rectangle.height;
        graphics2D.setPaint(new GradientPaint(rectangle.x, f, color, rectangle.x, f2, color2));
        graphics2D.fill(new Rectangle2D.Float(rectangle.x, f, rectangle.x + rectangle.width, f2));
    }

    public boolean isOpaque() {
        return true;
    }
}

