/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.tables;

import java.text.NumberFormat;
import javax.swing.table.AbstractTableModel;
import rex.metadata.CubeSlicer;
import rex.metadata.ExecuteResult;

public class CellTableModel
extends AbstractTableModel {
    CubeSlicer cubeSlicer;
    ExecuteResult result;
    private boolean showRowTotalsOn;
    private boolean showColumnTotalsOn;

    public CellTableModel(ExecuteResult _result, CubeSlicer _cubeSlicer, boolean _showColumnTotalsOn, boolean _showRowTotalsOn) {
        this.result = _result;
        this.cubeSlicer = _cubeSlicer;
        this.showRowTotalsOn = _showRowTotalsOn;
        this.showColumnTotalsOn = _showColumnTotalsOn;
    }

    @Override
    public int getColumnCount() {
        return this.result.getTupleCount(this.cubeSlicer.getColAxisOrdinal()) + (this.showRowTotalsOn ? 2 : 0);
    }

    @Override
    public int getRowCount() {
        return this.result.getTupleCount(this.cubeSlicer.getRowAxisOrdinal()) + (this.showColumnTotalsOn ? 2 : 0);
    }

    @Override
    public String getColumnName(int col) {
        return null;
    }

    public boolean isSumCell(int row, int col) {
        return this.showRowTotalsOn && col == this.getColumnCount() - 2 || this.showColumnTotalsOn && row == this.getRowCount() - 2;
    }

    public boolean isAverageCell(int row, int col) {
        return this.showRowTotalsOn && col == this.getColumnCount() - 1 || this.showColumnTotalsOn && row == this.getRowCount() - 1;
    }

    private String formatSum(Double d) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        return nf.format(d);
    }

    private String formatAverage(Double d) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return nf.format(d);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.showRowTotalsOn) {
            if (this.showColumnTotalsOn) {
                if (col == this.getColumnCount() - 2 && row == this.getRowCount() - 2) {
                    return this.formatSum(this.result.getTotalSum(this.cubeSlicer));
                }
                if (col == this.getColumnCount() - 1 && row == this.getRowCount() - 1) {
                    return this.formatAverage(this.result.getTotalAverage(this.cubeSlicer));
                }
                if (col >= this.getColumnCount() - 2 && row >= this.getRowCount() - 2) {
                    return null;
                }
            }
            if (col == this.getColumnCount() - 2) {
                return this.formatSum(this.result.getSumForRow(row, this.cubeSlicer));
            }
            if (col == this.getColumnCount() - 1) {
                return this.formatAverage(this.result.getAverageForRow(row, this.cubeSlicer));
            }
        }
        if (this.showColumnTotalsOn) {
            if (row == this.getRowCount() - 2) {
                return this.formatSum(this.result.getSumForColumn(col, this.cubeSlicer));
            }
            if (row == this.getRowCount() - 1) {
                return this.formatAverage(this.result.getAverageForColumn(col, this.cubeSlicer));
            }
        }
        return this.result.getRowCol(row, col, this.cubeSlicer);
    }

    public boolean isShowRowTotalsOn() {
        return this.showRowTotalsOn;
    }

    public void setShowRowTotalsOn(boolean _showRowTotalsOn) {
        this.showRowTotalsOn = _showRowTotalsOn;
        this.fireTableStructureChanged();
    }

    public boolean isShowColumnTotalsOn() {
        return this.showColumnTotalsOn;
    }

    public void setShowColumnTotalsOn(boolean _showColumnTotalsOn) {
        this.showColumnTotalsOn = _showColumnTotalsOn;
        this.fireTableStructureChanged();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

