/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.modules.palette.ui.TextImporterUI;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class TextImporter
implements Runnable {
    private String text;
    private Lookup category;
    private int dropIndex;
    private FileObject categoryFolder;

    public TextImporter(String string, Lookup lookup, int n) {
        this.text = string;
        this.category = lookup;
        this.dropIndex = n;
    }

    public void run() {
        this.categoryFolder = this.findFolder(this.category);
        if (null == this.categoryFolder) {
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(TextImporter.class, (String)"Err_NoTextDnDSupport"), null, -1, 1, null, null);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
            return;
        }
        JButton jButton = new JButton(NbBundle.getMessage(TextImporter.class, (String)"Btn_AddToPalette"));
        jButton.getAccessibleContext().setAccessibleName(jButton.getText());
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TextImporter.class, (String)"ACD_Btn_AddToPalette"));
        JButton jButton2 = new JButton(NbBundle.getMessage(TextImporter.class, (String)"Btn_Cancel"));
        jButton2.getAccessibleContext().setAccessibleName(jButton2.getText());
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TextImporter.class, (String)"ACD_Btn_Cancel"));
        final TextImporterUI textImporterUI = new TextImporterUI(this.text, jButton);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)textImporterUI, NbBundle.getMessage(TextImporter.class, (String)"Btn_AddToPalette"), true, new Object[]{jButton, jButton2}, (Object)new HelpCtx(TextImporter.class), 0, null, null);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        jButton2.setDefaultCapable(false);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.dispose();
                TextImporter.this.doAddToPalette(textImporterUI);
            }
        });
        dialog.setVisible(true);
    }

    private void doAddToPalette(final TextImporterUI textImporterUI) {
        final String string = FileUtil.findFreeFileName((FileObject)this.categoryFolder, (String)"ccc", (String)"xml");
        try {
            this.categoryFolder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    FileObject fileObject = TextImporter.this.categoryFolder.createData(string, "xml");
                    PrintWriter printWriter = new PrintWriter(fileObject.getOutputStream());
                    TextImporter.this.storeItem(printWriter, textImporterUI);
                    printWriter.close();
                }
            });
        }
        catch (IOException iOException) {
            Logger.getLogger(TextImporter.class.getName()).log(Level.SEVERE, NbBundle.getMessage(TextImporter.class, (String)"Err_StoreItemToDisk"), iOException);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    TextImporter.this.reorder(string, TextImporter.this.categoryFolder, TextImporter.this.dropIndex);
                }
                catch (IOException iOException) {
                    Logger.getLogger(TextImporter.class.getName()).log(Level.INFO, null, iOException);
                }
            }
        });
    }

    private FileObject findFolder(Lookup lookup) {
        DataFolder dataFolder;
        Node node = (Node)lookup.lookup(Node.class);
        if (null != node && null != (dataFolder = (DataFolder)node.getCookie(DataFolder.class))) {
            return dataFolder.getPrimaryFile();
        }
        return null;
    }

    private void storeItem(PrintWriter printWriter, TextImporterUI textImporterUI) throws IOException {
        String string;
        String string2 = textImporterUI.getItemName();
        String string3 = textImporterUI.getItemTooltip();
        if (null == string3 || string3.trim().length() == 0) {
            string3 = string2;
        }
        String string4 = textImporterUI.getItemContent();
        String string5 = textImporterUI.getItemSmallIconPath();
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == string5) {
            string5 = "org/netbeans/modules/palette/resources/unknown16.gif";
        }
        if (null == (string = textImporterUI.getItemLargeIconPath())) {
            string = "org/netbeans/modules/palette/resources/unknown32.gif";
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<!DOCTYPE editor_palette_item PUBLIC \"-//NetBeans//Editor Palette Item 1.1//EN\" \"http://www.netbeans.org/dtds/editor-palette-item-1_1.dtd\">");
        printWriter.println();
        printWriter.println("<editor_palette_item version=\"1.0\">");
        printWriter.println("    <body>");
        printWriter.println("        <![CDATA[");
        printWriter.println(this.toUTF8(string4));
        printWriter.println("        ]]>");
        printWriter.println("    </body>");
        printWriter.print("    <icon16 urlvalue=\"");
        printWriter.print(string5);
        printWriter.println("\" />");
        printWriter.print("    <icon32 urlvalue=\"");
        printWriter.print(string);
        printWriter.println("\" />");
        printWriter.println("    <inline-description>");
        printWriter.print("        <display-name>");
        printWriter.print(this.toUTF8(string2));
        printWriter.println("</display-name>");
        printWriter.print("        <tooltip>");
        printWriter.print(this.toUTF8(string3));
        printWriter.println("</tooltip>");
        printWriter.println("    </inline-description>");
        printWriter.println("</editor_palette_item>");
    }

    private String toUTF8(String string) {
        try {
            return new String(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(TextImporter.class.getName()).log(Level.WARNING, null, unsupportedEncodingException);
            return string;
        }
    }

    private void reorder(String string, FileObject fileObject, int n) throws IOException {
        if (n < 0) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject(string, "xml");
        if (null == fileObject2) {
            return;
        }
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        DataObject[] dataObjectArray = dataFolder.getChildren();
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        if (null == dataObject) {
            return;
        }
        int n2 = -1;
        for (int i = 0; i < dataObjectArray.length; ++i) {
            if (!dataObjectArray[i].equals(dataObject)) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            return;
        }
        DataObject[] dataObjectArray2 = new DataObject[dataObjectArray.length];
        if (n >= dataObjectArray2.length) {
            n = dataObjectArray2.length - 1;
        }
        dataObjectArray2[n] = dataObject;
        int n3 = 0;
        for (int i = 0; i < dataObjectArray2.length; ++i) {
            DataObject dataObject2;
            if (dataObjectArray2[i] != null) continue;
            if (dataObject.equals(dataObject2 = dataObjectArray[n3++])) {
                --i;
                continue;
            }
            dataObjectArray2[i] = dataObject2;
        }
        dataFolder.setOrder(dataObjectArray2);
    }
}

