/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.dnd.DropTarget;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTree;
import rex.graphics.CubeExplorer2;
import rex.graphics.EmptyResultTable;
import rex.metadata.Query;
import rex.utils.S;

public class Page
extends JPanel {
    private DropTarget dt;
    private JTree dimTree;
    private Query q;
    private CubeExplorer2 ce;
    private EmptyResultTable ert;
    private boolean current;
    private boolean cubeExplorerIsDisplayed;

    public Page(JTree _dimTree, Query _q) {
        this.q = _q;
        this.dimTree = _dimTree;
        this.ert = new EmptyResultTable(this.q, this.dimTree);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.ert);
        this.cubeExplorerIsDisplayed = false;
        this.setOpaque(false);
        this.current = false;
        this.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
    }

    public Page(JTree _dimTree, Query _q, CubeExplorer2 ceToDisplay) {
        this.q = _q;
        this.dimTree = _dimTree;
        this.ce = ceToDisplay;
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.ce);
        this.add(Box.createVerticalGlue());
        this.cubeExplorerIsDisplayed = true;
        this.setOpaque(false);
        this.current = false;
        this.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
    }

    public static short getAdditionalHeight() {
        return 13;
    }

    public void refreshDisplay() {
        S.out("current=");
        if (this.current) {
            if (this.q.canExecute()) {
                if (!this.cubeExplorerIsDisplayed) {
                    S.out("assert: cubeExplorerIsDisplayed=false while q.canExecute()=true !?");
                }
            } else {
                if (this.cubeExplorerIsDisplayed) {
                    this.cubeExplorerIsDisplayed = false;
                    this.removeAll();
                    if (this.ert == null) {
                        this.ert = new EmptyResultTable(this.q, this.dimTree);
                    }
                    this.add(this.ert);
                }
                this.ert.refreshDisplay();
                this.repaint();
                this.revalidate();
            }
        }
    }

    public void paintComponent(Graphics g) {
        S.paintBackground(g, this);
        super.paintComponent(g);
    }

    public void setCurrent(boolean isCurrent) {
        this.current = isCurrent;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCubeExplorer(CubeExplorer2 ceToDisplay) {
        this.ce = ceToDisplay;
        this.cubeExplorerIsDisplayed = true;
        this.removeAll();
        this.add(this.ce);
        this.add(Box.createVerticalGlue());
    }

    public CubeExplorer2 getCubeExplorer() {
        return this.ce;
    }
}

