/*
 * Decompiled with CFR 0.152.
 */
package rex.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import rex.graphics.mdxeditor.jsp.ReadEnv;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;

public class I18n {
    public static final String localPackageName = "rex/locale/";
    public static final String baseName = "Rex";
    private static ResourceBundle oLanguage = null;
    public static Vector languageChangedListeners = null;
    private static Locale currentLocale;

    public static void addOnLanguageChangedListener(LanguageChangedListener listener) {
        languageChangedListeners.add(listener);
    }

    public static void removeOnLanguageChangedListener(LanguageChangedListener listener) {
        languageChangedListeners.remove(listener);
    }

    public static void setCurrentLocale(String language) {
        I18n.setCurrentLocale(language, null);
    }

    public static void setCurrentLocale(String language, String country) {
        if (language != null && !language.equals("")) {
            if (country != null && !country.equals("")) {
                I18n.setCurrentLocale(new Locale(language, country));
            } else {
                I18n.setCurrentLocale(new Locale(language));
            }
        } else {
            I18n.setCurrentLocale(Locale.getDefault());
        }
    }

    public static void setCurrentLocale(Locale locale) {
        try {
            currentLocale = locale;
            oLanguage = null;
            Enumeration enum_listeners = languageChangedListeners.elements();
            while (enum_listeners.hasMoreElements()) {
                ((LanguageChangedListener)enum_listeners.nextElement()).languageChanged(new LanguageChangedEvent(locale));
            }
        }
        catch (Exception ex) {
            I18n.setCurrentLocaleEng(new Locale("en", "US"));
        }
    }

    public static void setCurrentLocaleEng(Locale locale) {
        currentLocale = locale;
        oLanguage = null;
        Enumeration enum_listeners = languageChangedListeners.elements();
        while (enum_listeners.hasMoreElements()) {
            try {
                ((LanguageChangedListener)enum_listeners.nextElement()).languageChanged(new LanguageChangedEvent(locale));
            }
            catch (Exception exception) {}
        }
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static String getString(String cID) {
        return I18n.getString(cID, currentLocale);
    }

    public static String getString(String cID, String defaultValue) {
        return I18n.getString(cID, currentLocale, defaultValue);
    }

    public static String getFormattedString(String cID, String defaultValue, Object[] args) {
        String pattern = I18n.getString(cID, I18n.getCurrentLocale(), defaultValue);
        MessageFormat mf = new MessageFormat(pattern, I18n.getCurrentLocale());
        return mf.format(args);
    }

    private static String getString(String cID, Locale currentLocale) {
        if (currentLocale == null) {
            currentLocale = Locale.getDefault();
        }
        if (oLanguage == null) {
            try {
                oLanguage = ResourceBundle.getBundle("rex/locale/Rex", currentLocale);
            }
            catch (MissingResourceException mre) {
                oLanguage = ResourceBundle.getBundle("rex/locale/Rex", new Locale("en", "US"));
            }
        }
        try {
            return oLanguage.getString(cID);
        }
        catch (Exception ex) {
            return cID;
        }
    }

    public static String getString(String cID, Locale currentLocale, String defaultValue) {
        try {
            if (oLanguage == null) {
                oLanguage = ResourceBundle.getBundle("rex/locale/Rex", currentLocale);
            }
            return oLanguage.getString(cID);
        }
        catch (MissingResourceException ex) {
            System.out.println("Can't find the translation for key = " + cID + ": using default (" + defaultValue + ")");
        }
        catch (Exception ex) {
            System.out.println("Exception loading cID = " + cID + ": " + ex.getMessage());
        }
        return defaultValue;
    }

    public static String getCurrentLocaleID() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(String aContents) throws FileNotFoundException, IOException {
        File aFile = null;
        try {
            aFile = new File(ReadEnv.getEnvVars().getProperty("USERPROFILE") + "\\rex.properties");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + aFile);
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
            output.write(aContents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    static {
        languageChangedListeners = new Vector();
        currentLocale = Locale.getDefault();
    }
}

