/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.ImageMapRenderable;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.export.DefaultHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.export.tabulator.Cell;
import net.sf.jasperreports.engine.export.tabulator.CellVisitor;
import net.sf.jasperreports.engine.export.tabulator.Column;
import net.sf.jasperreports.engine.export.tabulator.ElementCell;
import net.sf.jasperreports.engine.export.tabulator.FrameCell;
import net.sf.jasperreports.engine.export.tabulator.LayeredCell;
import net.sf.jasperreports.engine.export.tabulator.Row;
import net.sf.jasperreports.engine.export.tabulator.SplitCell;
import net.sf.jasperreports.engine.export.tabulator.Table;
import net.sf.jasperreports.engine.export.tabulator.TableCell;
import net.sf.jasperreports.engine.export.tabulator.TablePosition;
import net.sf.jasperreports.engine.export.tabulator.Tabulator;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlExporter
extends JRAbstractExporter {
    private static final Log log = LogFactory.getLog(HtmlExporter.class);
    public static final String HTML_EXPORTER_KEY = "net.sf.jasperreports.html";
    protected static final String HTML_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.html.";
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.html.ignore.hyperlink";
    public static final String PROPERTY_BORDER_COLLAPSE = "net.sf.jasperreports.export.html.border.collapse";
    protected static final float DEFAULT_ZOOM = 1.0f;
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected JRHyperlinkTargetProducerFactory targetProducerFactory;
    protected JRExportProgressMonitor progressMonitor;
    protected String htmlHeader;
    protected String betweenPagesHtml;
    protected String htmlFooter;
    protected File imagesDir;
    protected boolean isOutputImagesToDir;
    protected String imagesURI;
    protected String encoding;
    protected String borderCollapse;
    protected boolean isWhitePageBackground;
    protected boolean isWrapBreakWord;
    protected boolean isIgnorePageMargins;
    protected boolean accessibleHtml;
    protected String sizeUnit;
    protected float zoom = 1.0f;
    protected boolean flushOutput;
    protected Map<String, String> rendererToImagePathMap;
    protected Map<Pair<String, Rectangle>, String> imageMaps;
    protected List<JRPrintElementIndex> imagesToProcess;
    protected Map<String, byte[]> imageNameToImageDataMap;
    protected Writer writer;
    protected int reportIndex;
    protected int pageIndex;
    protected JRHtmlExporterContext exporterContext = new ExporterContext();
    protected LinkedList<Color> backcolorStack = new LinkedList();

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString();
    }

    public static JRPrintImage getImage(List<JasperPrint> jasperPrintList, JRPrintElementIndex imageIndex) {
        JasperPrint report = jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        JRPrintElement element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        return (JRPrintImage)element;
    }

    public HtmlExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public HtmlExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.targetProducerFactory = new DefaultHyperlinkTargetProducerFactory(jasperReportsContext);
    }

    @Override
    protected String getExporterKey() {
        return HTML_EXPORTER_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        block61: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                String uri;
                boolean isRemoveEmptySpace;
                String dir;
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(HTML_EXPORTER_PROPERTIES_PREFIX);
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.htmlHeader = (String)this.parameters.get(JRHtmlExporterParameter.HTML_HEADER);
                this.betweenPagesHtml = (String)this.parameters.get(JRHtmlExporterParameter.BETWEEN_PAGES_HTML);
                this.htmlFooter = (String)this.parameters.get(JRHtmlExporterParameter.HTML_FOOTER);
                this.imagesDir = (File)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR);
                if (this.imagesDir == null && (dir = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_DIR_NAME)) != null) {
                    this.imagesDir = new File(dir);
                }
                if (isRemoveEmptySpace = this.getBooleanParameter(JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, "net.sf.jasperreports.export.html.remove.emtpy.space.between.rows", false)) {
                    log.info((Object)"Removing empty spalce between rows not supported");
                }
                this.isWhitePageBackground = this.getBooleanParameter(JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, "net.sf.jasperreports.export.xls.white.page.background", true);
                this.borderCollapse = this.getPropertiesUtil().getProperty(this.jasperPrint.getPropertiesMap(), PROPERTY_BORDER_COLLAPSE);
                Boolean isOutputImagesToDirParameter = (Boolean)this.parameters.get(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR);
                if (isOutputImagesToDirParameter != null) {
                    this.isOutputImagesToDir = isOutputImagesToDirParameter;
                }
                if ((uri = (String)this.parameters.get(JRHtmlExporterParameter.IMAGES_URI)) != null) {
                    this.imagesURI = uri;
                }
                this.encoding = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
                this.rendererToImagePathMap = new HashMap<String, String>();
                this.imageMaps = new HashMap<Pair<String, Rectangle>, String>();
                this.imagesToProcess = new ArrayList<JRPrintElementIndex>();
                this.imageNameToImageDataMap = (Map)this.parameters.get(JRHtmlExporterParameter.IMAGES_MAP);
                this.isWrapBreakWord = this.getBooleanParameter(JRHtmlExporterParameter.IS_WRAP_BREAK_WORD, "net.sf.jasperreports.export.html.wrap.break.word", false);
                this.sizeUnit = this.getStringParameterOrDefault(JRHtmlExporterParameter.SIZE_UNIT, "net.sf.jasperreports.export.html.size.unit");
                Float zoomRatio = (Float)this.parameters.get(JRHtmlExporterParameter.ZOOM_RATIO);
                if (zoomRatio != null) {
                    this.zoom = zoomRatio.floatValue();
                    if (this.zoom <= 0.0f) {
                        throw new JRException("Invalid zoom ratio : " + this.zoom);
                    }
                } else {
                    this.zoom = 1.0f;
                }
                this.isIgnorePageMargins = this.getBooleanParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, "net.sf.jasperreports.export.ignore.page.margins", false);
                this.accessibleHtml = this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.export.html.accessible", false);
                this.setFontMap();
                this.setHyperlinkProducerFactory();
                this.flushOutput = this.getBooleanParameter(JRHtmlExporterParameter.FLUSH_OUTPUT, "net.sf.jasperreports.export.html.flush.output", true);
                StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (sb != null) {
                    try {
                        this.writer = new StringWriter();
                        this.exportReportToWriter();
                        sb.append(this.writer.toString());
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to StringBuffer writer : " + this.jasperPrint.getName(), e);
                    }
                    finally {
                        if (this.writer != null) {
                            try {
                                this.writer.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                this.writer = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (this.writer != null) {
                    try {
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.writer = new OutputStreamWriter(os, this.encoding);
                        this.exportReportToWriter();
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to OutputStream writer : " + this.jasperPrint.getName(), e);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.writer = new OutputStreamWriter(os, this.encoding);
                }
                catch (IOException e) {
                    throw new JRException("Error creating to file writer : " + this.jasperPrint.getName(), e);
                }
                if (this.imagesDir == null) {
                    this.imagesDir = new File(destFile.getParent(), destFile.getName() + "_files");
                }
                if (isOutputImagesToDirParameter == null) {
                    this.isOutputImagesToDir = true;
                }
                if (this.imagesURI == null) {
                    this.imagesURI = this.imagesDir.getName() + "/";
                }
                try {
                    this.exportReportToWriter();
                }
                catch (IOException e) {
                    throw new JRException("Error writing to file writer : " + this.jasperPrint.getName(), e);
                }
                finally {
                    if (this.writer != null) {
                        try {
                            this.writer.close();
                        }
                        catch (IOException e) {}
                    }
                }
                if (!this.isOutputImagesToDir) break block61;
                if (this.imagesDir == null) {
                    throw new JRException("The images directory was not specified for the exporter.");
                }
                if (this.imagesToProcess == null || this.imagesToProcess.size() <= 0) break block61;
                if (!this.imagesDir.exists()) {
                    this.imagesDir.mkdir();
                }
                for (JRPrintElementIndex imageIndex : this.imagesToProcess) {
                    JRPrintImage image = HtmlExporter.getImage(this.jasperPrintList, imageIndex);
                    Renderable renderer = image.getRenderable();
                    if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
                        renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                    }
                    byte[] imageData = renderer.getImageData(this.jasperReportsContext);
                    File imageFile = new File(this.imagesDir, HtmlExporter.getImageName(imageIndex));
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(imageFile);
                        fos.write(imageData, 0, imageData.length);
                    }
                    catch (IOException e) {
                        throw new JRException("Error writing to image file : " + imageFile, e);
                    }
                    finally {
                        if (fos == null) continue;
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void exportReportToWriter() throws JRException, IOException {
        if (this.htmlHeader == null) {
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <title></title>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\"/>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(this.htmlHeader);
        }
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = pages.get(this.pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1) + "\"></a>\n");
                    this.exportPage(page);
                    if (this.reportIndex < this.jasperPrintList.size() - 1 || this.pageIndex < this.endPageIndex) {
                        if (this.betweenPagesHtml == null) {
                            this.writer.write("<br/>\n<br/>\n");
                        } else {
                            this.writer.write(this.betweenPagesHtml);
                        }
                    }
                    this.writer.write("\n");
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (this.htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(this.htmlFooter);
        }
        if (this.flushOutput) {
            this.writer.flush();
        }
    }

    protected void exportPage(JRPrintPage page) throws IOException {
        Tabulator tabulator = new Tabulator(this.filter, page.getElements());
        tabulator.tabulate();
        if (!this.isIgnorePageMargins) {
            tabulator.addMargins(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        }
        Table table = tabulator.getTable();
        if (this.isWhitePageBackground) {
            this.setBackcolor(Color.white);
        }
        CellElementVisitor elementVisitor = new CellElementVisitor();
        TableVisitor tableVisitor = new TableVisitor(tabulator, elementVisitor);
        this.exportTable(tableVisitor, table, this.isWhitePageBackground, true);
        if (this.isWhitePageBackground) {
            this.restoreBackcolor();
        }
    }

    protected void exportTable(TableVisitor tableVisitor, Table table, boolean whiteBackground, boolean isMainReportTable) throws IOException {
        SortedSet<Column> columns = table.getColumns().getUserEntries();
        SortedSet<Row> rows = table.getRows().getUserEntries();
        if (columns.isEmpty() || rows.isEmpty()) {
            return;
        }
        if (isMainReportTable) {
            int totalWidth = columns.last().getEndCoord() - columns.first().getStartCoord();
            this.writer.write("<table class=\"jrPage\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"empty-cells: show; width: ");
            this.writer.write(this.toSizeUnit(totalWidth));
            this.writer.write(";");
        } else {
            this.writer.write("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"empty-cells: show; width: 100%;");
        }
        if (this.borderCollapse != null) {
            this.writer.write(" border-collapse: ");
            this.writer.write(this.borderCollapse);
            this.writer.write(";");
        }
        if (whiteBackground) {
            this.writer.write(" background-color: white;");
        }
        this.writer.write("\">\n");
        this.writer.write("<tr valign=\"top\" style=\"height:0\">\n");
        for (Column col : columns) {
            this.writer.write("<td style=\"width:");
            this.writer.write(this.toSizeUnit(col.getExtent()));
            this.writer.write("\"></td>\n");
        }
        this.writer.write("</tr>\n");
        for (Row row : rows) {
            this.writer.write("<tr valign=\"top\" style=\"height:");
            this.writer.write(this.toSizeUnit(row.getExtent()));
            this.writer.write("\">\n");
            int emptySpan = 0;
            for (Column col : columns) {
                Cell cell = row.getCell(col);
                if (cell == null) {
                    ++emptySpan;
                    continue;
                }
                if (emptySpan > 0) {
                    this.writeEmptyCell(emptySpan, 1);
                }
                emptySpan = 0;
                TablePosition position = new TablePosition(table, col, row);
                cell.accept(tableVisitor, position);
            }
            if (emptySpan > 0) {
                this.writeEmptyCell(emptySpan, 1);
            }
            this.writer.write("</tr>\n");
        }
        this.writer.write("</table>\n");
    }

    protected void writeText(JRPrintText text, TableCell cell) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = styledText == null ? 0 : styledText.length();
        this.startCell(text, cell);
        if (text.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuilder styleBuffer = new StringBuilder();
        String verticalAlignment = "top";
        switch (text.getVerticalAlignmentValue()) {
            case BOTTOM: {
                verticalAlignment = "bottom";
                break;
            }
            case MIDDLE: {
                verticalAlignment = "middle";
                break;
            }
            default: {
                verticalAlignment = "top";
            }
        }
        if (!verticalAlignment.equals("top")) {
            styleBuffer.append(" vertical-align: ");
            styleBuffer.append(verticalAlignment);
            styleBuffer.append(";");
        }
        this.appendBackcolorStyle(cell, styleBuffer);
        this.appendBorderStyle(cell.getBox(), styleBuffer);
        this.appendPaddingStyle(text.getLineBox(), styleBuffer);
        String horizontalAlignment = "left";
        if (textLength > 0) {
            switch (text.getHorizontalAlignmentValue()) {
                case RIGHT: {
                    horizontalAlignment = "right";
                    break;
                }
                case CENTER: {
                    horizontalAlignment = "center";
                    break;
                }
                case JUSTIFIED: {
                    horizontalAlignment = "justify";
                    break;
                }
                default: {
                    horizontalAlignment = "left";
                }
            }
            if (text.getRunDirectionValue() == RunDirectionEnum.LTR && !horizontalAlignment.equals("left") || text.getRunDirectionValue() == RunDirectionEnum.RTL && !horizontalAlignment.equals("right")) {
                styleBuffer.append("text-align: ");
                styleBuffer.append(horizontalAlignment);
                styleBuffer.append(";");
            }
        }
        if (this.isWrapBreakWord) {
            styleBuffer.append("width: " + this.toSizeUnit(text.getWidth()) + "; ");
            styleBuffer.append("word-wrap: break-word; ");
        }
        if (text.getLineBreakOffsets() != null) {
            styleBuffer.append("white-space: nowrap; ");
        }
        styleBuffer.append("text-indent: " + text.getParagraph().getFirstLineIndent() + "px; ");
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\"/>");
        }
        boolean hyperlinkStarted = this.startHyperlink(text);
        if (textLength > 0) {
            String textTooltip = hyperlinkStarted ? null : text.getHyperlinkTooltip();
            this.exportStyledText(text, styledText, textTooltip, hyperlinkStarted);
        }
        if (hyperlinkStarted) {
            this.endHyperlink();
        }
        this.endCell();
    }

    protected void writeImage(JRPrintImage image, TableCell cell) throws IOException, JRException {
        Renderable renderer;
        this.startCell(image, cell);
        StringBuilder styleBuffer = new StringBuilder();
        String horizontalAlignment = "left";
        switch (image.getHorizontalAlignmentValue()) {
            case RIGHT: {
                horizontalAlignment = "right";
                break;
            }
            case CENTER: {
                horizontalAlignment = "center";
                break;
            }
            default: {
                horizontalAlignment = "left";
            }
        }
        if (!horizontalAlignment.equals("left")) {
            styleBuffer.append("text-align: ");
            styleBuffer.append(horizontalAlignment);
            styleBuffer.append(";");
        }
        String verticalAlignment = "top";
        switch (image.getVerticalAlignmentValue()) {
            case BOTTOM: {
                verticalAlignment = "bottom";
                break;
            }
            case MIDDLE: {
                verticalAlignment = "middle";
                break;
            }
            default: {
                verticalAlignment = "top";
            }
        }
        if (!verticalAlignment.equals("top")) {
            styleBuffer.append(" vertical-align: ");
            styleBuffer.append(verticalAlignment);
            styleBuffer.append(";");
        }
        this.appendBackcolorStyle(cell, styleBuffer);
        boolean addedToStyle = this.appendBorderStyle(cell.getBox(), styleBuffer);
        if (!addedToStyle) {
            this.appendPen(styleBuffer, image.getLinePen(), null);
        }
        this.appendPaddingStyle(image.getLineBox(), styleBuffer);
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\"/>");
        }
        Renderable originalRenderer = renderer = image.getRenderable();
        boolean imageMapRenderer = renderer != null && renderer instanceof ImageMapRenderable && ((ImageMapRenderable)renderer).hasImageAreaHyperlinks();
        boolean hasHyperlinks = false;
        if (renderer != null) {
            int imageHeight;
            boolean hyperlinkStarted;
            if (imageMapRenderer) {
                hyperlinkStarted = false;
                hasHyperlinks = true;
            } else {
                hasHyperlinks = hyperlinkStarted = this.startHyperlink(image);
            }
            this.writer.write("<img");
            String imagePath = null;
            String imageMapName = null;
            List<JRPrintImageAreaHyperlink> imageMapAreas = null;
            ScaleImageEnum scaleImage = image.getScaleImageValue();
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                imagePath = this.rendererToImagePathMap.get(renderer.getId());
            } else {
                if (image.isLazy()) {
                    imagePath = ((JRImageRenderer)renderer).getImageLocation();
                } else {
                    JRPrintElementIndex imageIndex = this.getElementIndex(cell);
                    this.imagesToProcess.add(imageIndex);
                    String imageName = HtmlExporter.getImageName(imageIndex);
                    imagePath = this.imagesURI + imageName;
                    if (this.imageNameToImageDataMap != null) {
                        if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
                            renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                        }
                        this.imageNameToImageDataMap.put(imageName, renderer.getImageData(this.jasperReportsContext));
                    }
                }
                this.rendererToImagePathMap.put(renderer.getId(), imagePath);
            }
            if (imageMapRenderer) {
                Rectangle renderingArea = new Rectangle(image.getWidth(), image.getHeight());
                if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                    imageMapName = this.imageMaps.get(new Pair<String, Rectangle>(renderer.getId(), renderingArea));
                }
                if (imageMapName == null) {
                    imageMapName = "map_" + this.getElementIndex(cell).toString();
                    imageMapAreas = ((ImageMapRenderable)originalRenderer).getImageAreaHyperlinks(renderingArea);
                    if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                        this.imageMaps.put(new Pair<String, Rectangle>(renderer.getId(), renderingArea), imageMapName);
                    }
                }
            }
            this.writer.write(" src=\"");
            if (imagePath != null) {
                this.writer.write(imagePath);
            }
            this.writer.write("\"");
            int imageWidth = image.getWidth() - image.getLineBox().getLeftPadding() - image.getLineBox().getRightPadding();
            if (imageWidth < 0) {
                imageWidth = 0;
            }
            if ((imageHeight = image.getHeight() - image.getLineBox().getTopPadding() - image.getLineBox().getBottomPadding()) < 0) {
                imageHeight = 0;
            }
            switch (scaleImage) {
                case FILL_FRAME: {
                    this.writer.write(" style=\"width: ");
                    this.writer.write(this.toSizeUnit(imageWidth));
                    this.writer.write("; height: ");
                    this.writer.write(this.toSizeUnit(imageHeight));
                    this.writer.write("\"");
                    break;
                }
                default: {
                    double normalWidth = imageWidth;
                    double normalHeight = imageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        Renderable tmpRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension(this.jasperReportsContext);
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    if (imageHeight <= 0) break;
                    double ratio = normalWidth / normalHeight;
                    if (ratio > (double)imageWidth / (double)imageHeight) {
                        this.writer.write(" style=\"width: ");
                        this.writer.write(this.toSizeUnit(imageWidth));
                        this.writer.write("\"");
                        break;
                    }
                    this.writer.write(" style=\"height: ");
                    this.writer.write(this.toSizeUnit(imageHeight));
                    this.writer.write("\"");
                }
            }
            if (imageMapName != null) {
                this.writer.write(" usemap=\"#" + imageMapName + "\"");
            }
            this.writer.write(" alt=\"\"");
            if (hasHyperlinks) {
                this.writer.write(" border=\"0\"");
            }
            if (image.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(image.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write("/>");
            if (hyperlinkStarted) {
                this.endHyperlink();
            }
            if (imageMapAreas != null) {
                this.writer.write("\n");
                this.writeImageMap(imageMapName, image, imageMapAreas);
            }
        }
        this.endCell();
    }

    protected JRPrintElementIndex getElementIndex(TableCell cell) {
        String elementAddress = cell.getElementAddress();
        JRPrintElementIndex elementIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, elementAddress);
        return elementIndex;
    }

    protected void writeImageMap(String imageMapName, JRPrintImage image, List<JRPrintImageAreaHyperlink> imageMapAreas) throws IOException {
        this.writer.write("<map name=\"" + imageMapName + "\">\n");
        ListIterator<JRPrintImageAreaHyperlink> it = imageMapAreas.listIterator(imageMapAreas.size());
        while (it.hasPrevious()) {
            JRPrintImageAreaHyperlink areaHyperlink = it.previous();
            JRPrintImageArea area = areaHyperlink.getArea();
            this.writer.write("  <area shape=\"" + JRPrintImageArea.getHtmlShape(area.getShape()) + "\"");
            this.writeImageAreaCoordinates(area.getCoordinates());
            this.writeImageAreaHyperlink(areaHyperlink.getHyperlink());
            this.writer.write("/>\n");
        }
        if (image.getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE) {
            this.writer.write("  <area shape=\"default\"");
            this.writeImageAreaCoordinates(new int[]{0, 0, image.getWidth(), image.getHeight()});
            this.writeImageAreaHyperlink(image);
            this.writer.write("/>\n");
        }
        this.writer.write("</map>\n");
    }

    protected void writeImageAreaCoordinates(int[] coords) throws IOException {
        if (coords != null && coords.length > 0) {
            StringBuilder coordsEnum = new StringBuilder(coords.length * 4);
            coordsEnum.append(this.toZoom(coords[0]));
            for (int i = 1; i < coords.length; ++i) {
                coordsEnum.append(',');
                coordsEnum.append(this.toZoom(coords[i]));
            }
            this.writer.write(" coords=\"" + coordsEnum + "\"");
        }
    }

    protected void writeImageAreaHyperlink(JRPrintHyperlink hyperlink) throws IOException {
        String href = this.getHyperlinkURL(hyperlink);
        if (href == null) {
            this.writer.write(" nohref=\"nohref\"");
        } else {
            this.writer.write(" href=\"" + href + "\"");
            String target = this.getHyperlinkTarget(hyperlink);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
        }
        if (hyperlink.getHyperlinkTooltip() != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(hyperlink.getHyperlinkTooltip()));
            this.writer.write("\"");
        }
    }

    protected void writeRectangle(JRPrintGraphicElement element, TableCell cell) throws IOException {
        this.startCell(element, cell);
        StringBuilder styleBuffer = new StringBuilder();
        this.appendBackcolorStyle(cell, styleBuffer);
        this.appendPen(styleBuffer, element.getLinePen(), null);
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        this.endCell();
    }

    protected void writeLine(JRPrintLine line, TableCell cell) throws IOException {
        this.startCell(line, cell);
        StringBuilder styleBuffer = new StringBuilder();
        this.appendBackcolorStyle(cell, styleBuffer);
        String side = null;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? "top" : "bottom") : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? "left" : "right");
        this.appendPen(styleBuffer, line.getLinePen(), side);
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        this.endCell();
    }

    protected void writeGenericElement(JRGenericPrintElement element, TableCell cell) throws IOException {
        GenericElementHtmlHandler handler = (GenericElementHtmlHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), HTML_EXPORTER_KEY);
        if (handler == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No HTML generic element handler for " + element.getGenericType()));
            }
            this.writeEmptyCell(cell.getColumnSpan(), cell.getRowSpan());
        } else {
            this.startCell(element, cell);
            StringBuilder styleBuffer = new StringBuilder();
            this.appendBackcolorStyle(cell, styleBuffer);
            this.appendBorderStyle(cell.getBox(), styleBuffer);
            if (styleBuffer.length() > 0) {
                this.writer.write(" style=\"");
                this.writer.write(styleBuffer.toString());
                this.writer.write("\"");
            }
            this.finishStartCell();
            String htmlFragment = handler.getHtmlFragment(this.exporterContext, element);
            if (htmlFragment != null) {
                this.writer.write(htmlFragment);
            }
            this.endCell();
        }
    }

    protected void writeLayers(List<Table> layers, TableVisitor tableVisitor, TableCell cell) throws IOException {
        this.startCell(cell);
        StringBuilder styleBuffer = new StringBuilder();
        this.appendBackcolorStyle(cell, styleBuffer);
        this.appendBorderStyle(cell.getBox(), styleBuffer);
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        this.setBackcolor(null);
        this.writer.write("<div style=\"width: 100%; height: 100%; position: relative;\">\n");
        Iterator<Table> it = layers.iterator();
        while (it.hasNext()) {
            Table table = it.next();
            StringBuilder layerStyleBuffer = new StringBuilder();
            if (it.hasNext()) {
                layerStyleBuffer.append("position: absolute; overflow: hidden; width: 100%; height: 100%;");
            } else {
                layerStyleBuffer.append("position: relative;");
            }
            this.writer.write("<div style=\"");
            this.writer.write(layerStyleBuffer.toString());
            this.writer.write("\">\n");
            this.exportTable(tableVisitor, table, false, false);
            this.writer.write("</div>\n");
        }
        this.writer.write("</div>\n");
        this.restoreBackcolor();
        this.endCell();
    }

    protected void startCell(JRPrintElement element, TableCell cell) throws IOException {
        this.startCell(cell.getColumnSpan(), cell.getRowSpan());
        String dataAttr = this.getDataAttributes(element, cell);
        if (dataAttr != null) {
            this.writer.write(dataAttr);
        }
    }

    public String getDataAttributes(JRPrintElement element, TableCell cell) {
        String columnIndex;
        String tableUuid;
        String cellId;
        String colUuid;
        String clazz;
        StringBuffer sbuffer = new StringBuffer();
        String id = this.getCellProperty(element, cell, "net.sf.jasperreports.export.html.id");
        if (id != null) {
            sbuffer.append(" id=\"" + id + "\"");
        }
        if ((clazz = this.getCellProperty(element, cell, "net.sf.jasperreports.export.html.class")) != null) {
            sbuffer.append(" class=\"" + clazz + "\"");
        }
        if ((colUuid = this.getCellProperty(element, cell, "net.sf.jasperreports.export.headertoolbar.columnUUID")) != null) {
            sbuffer.append(" data-coluuid=\"" + colUuid + "\"");
        }
        if ((cellId = this.getCellProperty(element, cell, "net.sf.jasperreports.export.headertoolbar.cellID")) != null) {
            sbuffer.append(" data-cellid=\"" + cellId + "\"");
        }
        if ((tableUuid = this.getCellProperty(element, cell, "net.sf.jasperreports.export.headertoolbar.tableUUID")) != null) {
            sbuffer.append(" data-tableuuid=\"" + tableUuid + "\"");
        }
        if ((columnIndex = this.getCellProperty(element, cell, "net.sf.jasperreports.export.headertoolbar.columnIndex")) != null) {
            sbuffer.append(" data-colidx=\"" + columnIndex + "\"");
        }
        return sbuffer.length() > 0 ? sbuffer.toString() : null;
    }

    protected String getCellProperty(JRPrintElement element, TableCell cell, String key) {
        String property = null;
        if (element != null) {
            property = this.getPropertiesUtil().getProperty(element, key);
        }
        if (property == null) {
            Tabulator tabulator = cell.getTabulator();
            for (FrameCell parentCell = cell.getCell().getParent(); parentCell != null && property == null; parentCell = parentCell.getParent()) {
                JRPrintElement parentElement = tabulator.getCellElement(parentCell);
                property = this.getPropertiesUtil().getProperty(parentElement, key);
            }
        }
        return property;
    }

    protected void startCell(TableCell cell) throws IOException {
        this.startCell(cell.getElement(), cell);
    }

    protected void startCell(int colSpan, int rowSpan) throws IOException {
        this.writer.write("<td");
        if (colSpan > 1) {
            this.writer.write(" colspan=\"");
            this.writer.write(Integer.toString(colSpan));
            this.writer.write("\"");
        }
        if (rowSpan > 1) {
            this.writer.write(" rowspan=\"");
            this.writer.write(Integer.toString(rowSpan));
            this.writer.write("\"");
        }
    }

    protected void finishStartCell() throws IOException {
        this.writer.write(">\n");
    }

    protected void endCell() throws IOException {
        this.writer.write("</td>\n");
    }

    protected void writeEmptyCell(int colSpan, int rowSpan) throws IOException {
        this.startCell(colSpan, rowSpan);
        this.finishStartCell();
        this.endCell();
    }

    protected void writeFrameCell(TableCell cell) throws IOException {
        this.startCell(cell);
        StringBuilder styleBuffer = new StringBuilder();
        this.appendBackcolorStyle(cell, styleBuffer);
        this.appendBorderStyle(cell.getBox(), styleBuffer);
        this.writeStyle(styleBuffer);
        this.finishStartCell();
        this.endCell();
    }

    protected void writeStyle(StringBuilder styleBuffer) throws IOException {
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addFirst(color);
    }

    protected void restoreBackcolor() {
        this.backcolorStack.removeFirst();
    }

    protected boolean matchesBackcolor(Color backcolor) {
        if (this.backcolorStack.isEmpty()) {
            return false;
        }
        Color currentBackcolor = this.backcolorStack.getFirst();
        return currentBackcolor != null && backcolor.getRGB() == currentBackcolor.getRGB();
    }

    protected Color appendBackcolorStyle(TableCell cell, StringBuilder styleBuffer) {
        Color cellBackcolor = cell.getBackcolor();
        if (cellBackcolor != null && !this.matchesBackcolor(cellBackcolor)) {
            styleBuffer.append("background-color: #");
            styleBuffer.append(JRColorUtil.getColorHexa(cellBackcolor));
            styleBuffer.append("; ");
            return cellBackcolor;
        }
        return null;
    }

    protected boolean appendBorderStyle(JRLineBox box, StringBuilder styleBuffer) {
        boolean addedToStyle = false;
        if (box != null) {
            LineStyleEnum tps = box.getTopPen().getLineStyleValue();
            LineStyleEnum lps = box.getLeftPen().getLineStyleValue();
            LineStyleEnum bps = box.getBottomPen().getLineStyleValue();
            LineStyleEnum rps = box.getRightPen().getLineStyleValue();
            float tpw = box.getTopPen().getLineWidth().floatValue();
            float lpw = box.getLeftPen().getLineWidth().floatValue();
            float bpw = box.getBottomPen().getLineWidth().floatValue();
            float rpw = box.getRightPen().getLineWidth().floatValue();
            if (0.0f < tpw && tpw < 1.0f) {
                tpw = 1.0f;
            }
            if (0.0f < lpw && lpw < 1.0f) {
                lpw = 1.0f;
            }
            if (0.0f < bpw && bpw < 1.0f) {
                bpw = 1.0f;
            }
            if (0.0f < rpw && rpw < 1.0f) {
                rpw = 1.0f;
            }
            Color tpc = box.getTopPen().getLineColor();
            if (tps == lps && tps == bps && tps == rps && tpw == lpw && tpw == bpw && tpw == rpw && tpc.equals(box.getLeftPen().getLineColor()) && tpc.equals(box.getBottomPen().getLineColor()) && tpc.equals(box.getRightPen().getLineColor())) {
                addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), null);
            } else {
                addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), "top");
                addedToStyle |= this.appendPen(styleBuffer, box.getLeftPen(), "left");
                addedToStyle |= this.appendPen(styleBuffer, box.getBottomPen(), "bottom");
                addedToStyle |= this.appendPen(styleBuffer, box.getRightPen(), "right");
            }
        }
        return addedToStyle;
    }

    protected boolean appendPen(StringBuilder sb, JRPen pen, String side) {
        boolean addedToStyle = false;
        float borderWidth = pen.getLineWidth().floatValue();
        if (0.0f < borderWidth && borderWidth < 1.0f) {
            borderWidth = 1.0f;
        }
        String borderStyle = null;
        switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                borderStyle = "double";
                break;
            }
            case DOTTED: {
                borderStyle = "dotted";
                break;
            }
            case DASHED: {
                borderStyle = "dashed";
                break;
            }
            default: {
                borderStyle = "solid";
            }
        }
        if (borderWidth > 0.0f) {
            sb.append("border");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit((int)borderWidth));
            sb.append(" ");
            sb.append(borderStyle);
            sb.append(" #");
            sb.append(JRColorUtil.getColorHexa(pen.getLineColor()));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    protected boolean appendPaddingStyle(JRLineBox box, StringBuilder styleBuffer) {
        boolean addedToStyle = false;
        if (box != null) {
            Integer tp = box.getTopPadding();
            Integer lp = box.getLeftPadding();
            Integer bp = box.getBottomPadding();
            Integer rp = box.getRightPadding();
            if (tp == lp && tp == bp && tp == rp) {
                addedToStyle |= this.appendPadding(styleBuffer, tp, null);
            } else {
                addedToStyle |= this.appendPadding(styleBuffer, box.getTopPadding(), "top");
                addedToStyle |= this.appendPadding(styleBuffer, box.getLeftPadding(), "left");
                addedToStyle |= this.appendPadding(styleBuffer, box.getBottomPadding(), "bottom");
                addedToStyle |= this.appendPadding(styleBuffer, box.getRightPadding(), "right");
            }
        }
        return addedToStyle;
    }

    protected boolean appendPadding(StringBuilder sb, Integer padding, String side) {
        boolean addedToStyle = false;
        if (padding > 0) {
            sb.append("padding");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit(padding));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    protected boolean startHyperlink(JRPrintHyperlink link) throws IOException {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
            if (link.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(link.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        boolean hyperlinkStarted = href != null;
        return hyperlinkStarted;
    }

    protected void endHyperlink() throws IOException {
        this.writer.write("</a>");
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block14: {
                href = null;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(this.jasperPrint, PROPERTY_IGNORE_HYPERLINK, false);
                }
                if (ignoreHyperlink.booleanValue()) break block13;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block14;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target;
        block10: {
            JRHyperlinkTargetProducer producer;
            block9: {
                target = null;
                producer = this.targetProducerFactory.getHyperlinkTargetProducer(link.getLinkTarget());
                if (producer != null) break block9;
                switch (link.getHyperlinkTargetValue()) {
                    case BLANK: {
                        target = "_blank";
                        break;
                    }
                    case PARENT: {
                        target = "_parent";
                        break;
                    }
                    case TOP: {
                        target = "_top";
                        break;
                    }
                    case CUSTOM: {
                        List<JRPrintHyperlinkParameter> parameters;
                        boolean paramFound = false;
                        List<JRPrintHyperlinkParameter> list = parameters = link.getHyperlinkParameters() == null ? null : link.getHyperlinkParameters().getParameters();
                        if (parameters != null) {
                            for (JRPrintHyperlinkParameter parameter : parameters) {
                                if (!link.getLinkTarget().equals(parameter.getName())) continue;
                                target = parameter.getValue() == null ? null : parameter.getValue().toString();
                                paramFound = true;
                                break;
                            }
                        }
                        if (!paramFound) {
                            target = link.getLinkTarget();
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block10;
            }
            target = producer.getHyperlinkTarget(link);
        }
        return target;
    }

    public String toSizeUnit(int size) {
        return String.valueOf(this.toZoom(size)) + this.sizeUnit;
    }

    protected int toZoom(int size) {
        return (int)(this.zoom * (float)size);
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        short[] lineBreakOffsets;
        JRStyledText styledText = super.getStyledText(textElement, setBackcolor);
        if (styledText != null && (lineBreakOffsets = textElement.getLineBreakOffsets()) != null && lineBreakOffsets.length > 0) {
            styledText = styledText.cloneText();
            styledText.insert("\n", lineBreakOffsets);
        }
        return styledText;
    }

    protected void exportStyledText(JRPrintText printText, JRStyledText styledText, String tooltip, boolean hyperlinkStarted) throws IOException {
        Locale locale = this.getTextLocale(printText);
        LineSpacingEnum lineSpacing = printText.getParagraph().getLineSpacing();
        Float lineSpacingSize = printText.getParagraph().getLineSpacingSize();
        float lineSpacingFactor = printText.getLineSpacingFactor();
        Color backcolor = printText.getBackcolor();
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        boolean first = true;
        boolean startedSpan = false;
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            if (first && runLimit < styledText.length() && tooltip != null) {
                startedSpan = true;
                this.writer.write("<span title=\"");
                this.writer.write(JRStringUtil.xmlEncode(tooltip));
                this.writer.write("\">");
                tooltip = null;
            }
            first = false;
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), tooltip, locale, lineSpacing, lineSpacingSize, lineSpacingFactor, backcolor, hyperlinkStarted);
            iterator.setIndex(runLimit);
        }
        if (startedSpan) {
            this.writer.write("</span>");
        }
    }

    protected void exportStyledTextRun(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, String tooltip, Locale locale, LineSpacingEnum lineSpacing, Float lineSpacingSize, float lineSpacingFactor, Color backcolor, boolean hyperlinkStarted) throws IOException {
        Color runBackcolor;
        String fontFamilyAttr;
        String fontFamily = fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
        if (this.fontMap != null && this.fontMap.containsKey(fontFamilyAttr)) {
            fontFamily = (String)this.fontMap.get(fontFamilyAttr);
        } else {
            FontFamily family;
            String exportFont;
            FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontFamilyAttr, locale);
            if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.getExporterKey())) != null) {
                fontFamily = exportFont;
            }
        }
        boolean localHyperlink = false;
        JRPrintHyperlink hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
        if (!hyperlinkStarted && hyperlink != null) {
            localHyperlink = this.startHyperlink(hyperlink);
        }
        this.writer.write("<span style=\"font-family: ");
        this.writer.write(fontFamily);
        this.writer.write("; ");
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!hyperlinkStarted || !Color.black.equals(forecolor)) {
            this.writer.write("color: #");
            this.writer.write(JRColorUtil.getColorHexa(forecolor));
            this.writer.write("; ");
        }
        if ((runBackcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null && !runBackcolor.equals(backcolor)) {
            this.writer.write("background-color: #");
            this.writer.write(JRColorUtil.getColorHexa(runBackcolor));
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(this.toSizeUnit(((Float)attributes.get(TextAttribute.SIZE)).intValue()));
        this.writer.write(";");
        switch (lineSpacing) {
            default: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 1; *line-height: normal;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case ONE_AND_HALF: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 1.5;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case DOUBLE: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 2.0;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case PROPORTIONAL: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + ";");
                break;
            }
            case AT_LEAST: 
            case FIXED: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + "px;");
            }
        }
        if (TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT))) {
            this.writer.write(" font-weight: bold;");
        }
        if (TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE))) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: super;");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: sub;");
        }
        this.writer.write("\"");
        if (tooltip != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(tooltip));
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(JRStringUtil.htmlEncode(text));
        this.writer.write("</span>");
        if (localHyperlink) {
            this.endHyperlink();
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRHtmlExporterContext {
        protected ExporterContext() {
        }

        @Override
        public String getExportPropertiesPrefix() {
            return HtmlExporter.HTML_EXPORTER_PROPERTIES_PREFIX;
        }

        @Override
        public String getHyperlinkURL(JRPrintHyperlink link) {
            return HtmlExporter.this.getHyperlinkURL(link);
        }
    }

    protected class CellElementVisitor
    implements PrintElementVisitor<TableCell> {
        protected CellElementVisitor() {
        }

        @Override
        public void visit(JRPrintText textElement, TableCell cell) {
            try {
                HtmlExporter.this.writeText(textElement, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public void visit(JRPrintImage image, TableCell cell) {
            try {
                HtmlExporter.this.writeImage(image, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public void visit(JRPrintRectangle rectangle, TableCell cell) {
            try {
                HtmlExporter.this.writeRectangle(rectangle, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public void visit(JRPrintLine line, TableCell cell) {
            try {
                HtmlExporter.this.writeLine(line, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public void visit(JRPrintEllipse ellipse, TableCell cell) {
            try {
                HtmlExporter.this.writeRectangle(ellipse, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public void visit(JRPrintFrame frame, TableCell cell) {
            throw new JRRuntimeException("Internal error");
        }

        @Override
        public void visit(JRGenericPrintElement printElement, TableCell cell) {
            try {
                HtmlExporter.this.writeGenericElement(printElement, cell);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    protected class TableVisitor
    implements CellVisitor<TablePosition, Void, IOException> {
        private final Tabulator tabulator;
        private final PrintElementVisitor<TableCell> elementVisitor;

        public TableVisitor(Tabulator tabulator, PrintElementVisitor<TableCell> elementVisitor) {
            this.tabulator = tabulator;
            this.elementVisitor = elementVisitor;
        }

        @Override
        public Void visit(ElementCell cell, TablePosition position) {
            TableCell tableCell = this.tabulator.getTableCell(position, cell);
            JRPrintElement element = tableCell.getElement();
            element.accept(this.elementVisitor, tableCell);
            return null;
        }

        @Override
        public Void visit(SplitCell cell, TablePosition position) {
            return null;
        }

        @Override
        public Void visit(FrameCell frameCell, TablePosition position) throws IOException {
            TableCell tableCell = this.tabulator.getTableCell(position, frameCell);
            HtmlExporter.this.writeFrameCell(tableCell);
            return null;
        }

        @Override
        public Void visit(LayeredCell layeredCell, TablePosition position) throws IOException {
            TableCell tableCell = this.tabulator.getTableCell(position, layeredCell);
            HtmlExporter.this.writeLayers(layeredCell.getLayers(), this, tableCell);
            return null;
        }
    }
}

