/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.dimensiontree.dnd;

import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import rex.graphics.TreeElement;
import rex.graphics.dimensiontree.dnd.TransferableTreeNode;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.mdxeditor.mdxbuilder.dnd.DragElement;
import rex.metadata.QueryElement;
import rex.utils.S;

public class TreeDragSource
extends JComponent
implements DragSourceListener,
DragGestureListener,
DragSourceMotionListener {
    DragSource source;
    DragGestureRecognizer recognizer;
    TransferableTreeNode transferable;
    TreeElement oldNode;
    JTree sourceTree;
    String uniqueName;
    private int ITEM_WIDTH = 9;
    private int ITEM_HEIGHT = 25;
    Point p;

    public TreeDragSource(JTree tree, int actions2) {
        this.sourceTree = tree;
        this.source = new DragSource();
        this.recognizer = this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions2, this);
        this.source.addDragSourceMotionListener(this);
    }

    public int getItemWidth() {
        return this.ITEM_WIDTH * this.uniqueName.length();
    }

    public int getItemHeight() {
        return this.ITEM_HEIGHT;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.sourceTree.getSelectionPath();
        if (path == null || path.getPathCount() <= 1 || !((DimensionTreeElement)((TreeElement)path.getLastPathComponent()).getUserObject()).isEnabled() || !(((TreeElement)path.getLastPathComponent()).getUserObject() instanceof QueryElement)) {
            return;
        }
        this.oldNode = (TreeElement)path.getLastPathComponent();
        this.transferable = new TransferableTreeNode(this.sourceTree.getRowForPath(path));
        this.uniqueName = ((DimensionTreeElement)this.oldNode.getUserObject()).getUniqueName();
        this.source.startDrag(dge, DragSource.DefaultCopyDrop, ((DimensionTreeElement)this.oldNode.getUserObject()).getIcon().getImage(), new Point(10, 10), this.transferable, this);
        DragElement glassPane = (DragElement)SwingUtilities.getRootPane(this.sourceTree).getGlassPane();
        glassPane.setVisible(true);
        Point point = (Point)dge.getDragOrigin().clone();
        SwingUtilities.convertPointToScreen(point, this);
        SwingUtilities.convertPointFromScreen(point, glassPane);
        glassPane.setPoint(point);
        glassPane.setImage(this.uniqueName, this.getItemHeight(), this.getItemWidth());
        glassPane.showString(true);
        glassPane.repaint();
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dsde) {
        try {
            DragElement glassPane = (DragElement)SwingUtilities.getRootPane(this.sourceTree).getGlassPane();
            this.p = (Point)dsde.getLocation().clone();
            SwingUtilities.convertPointFromScreen(this.p, glassPane);
            glassPane.setPoint(this.p);
            glassPane.showString(true);
            glassPane.repaint();
        }
        catch (ClassCastException cce) {
            S.out(cce.getMessage());
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (!dsde.getDropSuccess() || dsde.getDropAction() == 2) {
            // empty if block
        }
        DragElement glassPane = (DragElement)SwingUtilities.getRootPane(this.sourceTree).getGlassPane();
        glassPane.setVisible(true);
        Point point = (Point)dsde.getLocation().clone();
        SwingUtilities.convertPointToScreen(point, this);
        SwingUtilities.convertPointFromScreen(point, glassPane);
        glassPane.setPoint(point);
        glassPane.showString(false);
        glassPane.repaint();
    }
}

