/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import net.sf.jasperreports.components.sort.AbstractFieldComparator;
import net.sf.jasperreports.components.sort.FilterTypeNumericOperatorsEnum;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.FormatUtils;

public class FieldNumberComparator
extends AbstractFieldComparator<Number> {
    public FieldNumberComparator(String filterPattern, Locale locale) {
        this.formatter = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
        if (filterPattern != null && filterPattern.trim().length() > 0 && this.formatter instanceof DecimalFormat) {
            ((DecimalFormat)this.formatter).applyPattern(filterPattern);
        }
    }

    @Override
    public void initValues() throws Exception {
        if (this.valueStart != null && this.valueStart.length() > 0) {
            this.compareStart = FormatUtils.getFormattedNumber((NumberFormat)this.formatter, this.valueStart, this.compareToClass);
        }
        if (this.valueEnd != null && this.valueEnd.length() > 0) {
            this.compareEnd = FormatUtils.getFormattedNumber((NumberFormat)this.formatter, this.valueEnd, this.compareToClass);
        }
    }

    @Override
    public boolean compare(String filterTypeOperator) {
        boolean defaultResult;
        boolean result = defaultResult = true;
        boolean resultPart1 = true;
        boolean resultPart2 = true;
        try {
            this.initValues();
        }
        catch (Exception e) {
            throw new JRRuntimeException(e);
        }
        Number formattedCompareTo = (Number)this.compareTo;
        if (this.compareTo != null) {
            try {
                formattedCompareTo = FormatUtils.getFormattedNumber((NumberFormat)this.formatter, ((Number)this.compareTo).toString(), this.compareToClass);
            }
            catch (ParseException e) {
                throw new JRRuntimeException(e);
            }
        }
        FilterTypeNumericOperatorsEnum numericEnum = FilterTypeNumericOperatorsEnum.getByEnumConstantName(filterTypeOperator);
        BigDecimal dbA = formattedCompareTo != null ? new BigDecimal(formattedCompareTo.toString()) : null;
        BigDecimal dbStart = this.compareStart != null ? new BigDecimal(((Number)this.compareStart).toString()) : null;
        BigDecimal dbEnd = this.compareEnd != null ? new BigDecimal(((Number)this.compareEnd).toString()) : null;
        boolean validComparison = dbStart != null && dbA != null;
        boolean validComparison2 = dbEnd != null && dbA != null;
        switch (numericEnum) {
            case DOES_NOT_EQUAL: {
                result = validComparison ? dbA.compareTo(dbStart) != 0 : defaultResult;
                break;
            }
            case EQUALS: {
                result = validComparison ? dbA.compareTo(dbStart) == 0 : false;
                break;
            }
            case GREATER_THAN: {
                result = validComparison ? dbA.compareTo(dbStart) > 0 : false;
                break;
            }
            case GREATER_THAN_EQUAL_TO: {
                result = validComparison ? dbA.compareTo(dbStart) >= 0 : false;
                break;
            }
            case IS_BETWEEN: {
                boolean bl = validComparison ? dbA.compareTo(dbStart) >= 0 : (resultPart1 = false);
                resultPart2 = validComparison2 ? dbA.compareTo(dbEnd) <= 0 : false;
                result = resultPart1 && resultPart2;
                break;
            }
            case IS_NOT_BETWEEN: {
                boolean bl = validComparison ? dbA.compareTo(dbStart) >= 0 : (resultPart1 = false);
                resultPart2 = validComparison2 ? dbA.compareTo(dbEnd) <= 0 : false;
                result = !resultPart1 || !resultPart2;
                break;
            }
            case LESS_THAN: {
                result = validComparison ? dbA.compareTo(dbStart) < 0 : false;
                break;
            }
            case LESS_THAN_EQUAL_TO: {
                result = validComparison ? dbA.compareTo(dbStart) <= 0 : false;
            }
        }
        return result;
    }
}

