/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.DefaultBucketMatcher;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.SamplePruner;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.util.StringUtils;

public final class GenMapRedUtils {
    private static Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils");

    public static void initPlan(ReduceSinkOperator op, GenMRProcContext opProcCtx) throws SemanticException {
        Operator<Serializable> reducer = op.getChildOperators().get(0);
        LinkedHashMap<Operator<? extends Serializable>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = opProcCtx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(op.getParentOperators().get(0));
        Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
        MapredWork plan = (MapredWork)currTask.getWork();
        HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
        Operator<? extends Serializable> currTopOp = opProcCtx.getCurrTopOp();
        opTaskMap.put(reducer, currTask);
        plan.setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
        plan.setNumReduceTasks(desc.getNumReducers());
        List<Task<? extends Serializable>> rootTasks = opProcCtx.getRootTasks();
        if (!rootTasks.contains(currTask)) {
            rootTasks.add(currTask);
        }
        if (reducer.getClass() == JoinOperator.class) {
            plan.setNeedsTagging(true);
        }
        assert (currTopOp != null);
        List<Operator<? extends Serializable>> seenOps = opProcCtx.getSeenOps();
        String currAliasId = opProcCtx.getCurrAliasId();
        if (!seenOps.contains(currTopOp)) {
            seenOps.add(currTopOp);
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, plan, false, opProcCtx);
        }
        currTopOp = null;
        currAliasId = null;
        opProcCtx.setCurrTask(currTask);
        opProcCtx.setCurrTopOp(currTopOp);
        opProcCtx.setCurrAliasId(currAliasId);
    }

    public static void initMapJoinPlan(Operator<? extends Serializable> op, GenMRProcContext ctx, boolean readInputMapJoin, boolean readInputUnion, boolean setReducer, int pos) throws SemanticException {
        GenMapRedUtils.initMapJoinPlan(op, ctx, readInputMapJoin, readInputUnion, setReducer, pos, false);
    }

    public static void initMapJoinPlan(Operator<? extends Serializable> op, GenMRProcContext opProcCtx, boolean readInputMapJoin, boolean readInputUnion, boolean setReducer, int pos, boolean createLocalPlan) throws SemanticException {
        LinkedHashMap<Operator<? extends Serializable>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = opProcCtx.getMapCurrCtx();
        assert (pos == -1 && readInputMapJoin || pos != -1);
        int parentPos = pos == -1 ? 0 : pos;
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(op.getParentOperators().get(parentPos));
        Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
        MapredWork plan = (MapredWork)currTask.getWork();
        HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
        Operator<? extends Serializable> currTopOp = opProcCtx.getCurrTopOp();
        if (readInputMapJoin) {
            boolean local;
            AbstractMapJoinOperator<? extends MapJoinDesc> currMapJoinOp = opProcCtx.getCurrMapJoinOp();
            assert (currMapJoinOp != null);
            boolean bl = local = pos != -1 && pos != ((MapJoinDesc)currMapJoinOp.getConf()).getPosBigTable();
            if (setReducer) {
                Operator<Serializable> reducer = op.getChildOperators().get(0);
                plan.setReducer(reducer);
                opTaskMap.put(reducer, currTask);
                if (reducer.getClass() == JoinOperator.class) {
                    plan.setNeedsTagging(true);
                }
                ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
                plan.setNumReduceTasks(desc.getNumReducers());
            } else {
                opTaskMap.put(op, currTask);
            }
            if (!readInputUnion) {
                Operator<? extends Serializable> rootOp;
                TableDesc tt_desc;
                String taskTmpDir;
                GenMRProcContext.GenMRMapJoinCtx mjCtx = opProcCtx.getMapJoinCtx(currMapJoinOp);
                if (mjCtx.getOldMapJoin() == null || setReducer) {
                    taskTmpDir = mjCtx.getTaskTmpDir();
                    tt_desc = mjCtx.getTTDesc();
                    rootOp = mjCtx.getRootMapJoinOp();
                } else {
                    GenMRProcContext.GenMRMapJoinCtx oldMjCtx = opProcCtx.getMapJoinCtx(mjCtx.getOldMapJoin());
                    taskTmpDir = oldMjCtx.getTaskTmpDir();
                    tt_desc = oldMjCtx.getTTDesc();
                    rootOp = oldMjCtx.getRootMapJoinOp();
                }
                GenMapRedUtils.setTaskPlan(taskTmpDir, taskTmpDir, rootOp, plan, local, tt_desc);
                GenMapRedUtils.setupBucketMapJoinInfo(plan, currMapJoinOp, createLocalPlan);
            } else {
                GenMapRedUtils.initUnionPlan(opProcCtx, currTask, false);
            }
            opProcCtx.setCurrMapJoinOp(null);
        } else {
            MapJoinDesc desc = (MapJoinDesc)op.getConf();
            opTaskMap.put(op, currTask);
            List<Task<? extends Serializable>> rootTasks = opProcCtx.getRootTasks();
            rootTasks.add(currTask);
            assert (currTopOp != null);
            List<Operator<? extends Serializable>> seenOps = opProcCtx.getSeenOps();
            String currAliasId = opProcCtx.getCurrAliasId();
            seenOps.add(currTopOp);
            boolean local = pos != desc.getPosBigTable();
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, plan, local, opProcCtx);
            GenMapRedUtils.setupBucketMapJoinInfo(plan, (AbstractMapJoinOperator)op, createLocalPlan);
        }
        opProcCtx.setCurrTask(currTask);
        opProcCtx.setCurrTopOp(null);
        opProcCtx.setCurrAliasId(null);
    }

    private static void setupBucketMapJoinInfo(MapredWork plan, AbstractMapJoinOperator<? extends MapJoinDesc> currMapJoinOp, boolean createLocalPlan) {
        LinkedHashMap<String, LinkedHashMap<String, ArrayList<String>>> aliasBucketFileNameMapping;
        if (currMapJoinOp != null && (aliasBucketFileNameMapping = ((MapJoinDesc)currMapJoinOp.getConf()).getAliasBucketFileNameMapping()) != null) {
            MapredLocalWork smbLocalWork;
            MapredLocalWork localPlan = plan.getMapLocalWork();
            if (localPlan == null) {
                if (currMapJoinOp instanceof SMBMapJoinOperator) {
                    localPlan = ((SMBJoinDesc)((SMBMapJoinOperator)currMapJoinOp).getConf()).getLocalWork();
                }
                if (localPlan == null && createLocalPlan) {
                    localPlan = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends Serializable>>(), new LinkedHashMap<String, FetchWork>());
                }
            } else if (currMapJoinOp instanceof SMBMapJoinOperator && (smbLocalWork = ((SMBJoinDesc)((SMBMapJoinOperator)currMapJoinOp).getConf()).getLocalWork()) != null) {
                localPlan.getAliasToFetchWork().putAll(smbLocalWork.getAliasToFetchWork());
                localPlan.getAliasToWork().putAll(smbLocalWork.getAliasToWork());
            }
            if (localPlan == null) {
                return;
            }
            if (currMapJoinOp instanceof SMBMapJoinOperator) {
                plan.setMapLocalWork(null);
                ((SMBJoinDesc)((SMBMapJoinOperator)currMapJoinOp).getConf()).setLocalWork(localPlan);
            } else {
                plan.setMapLocalWork(localPlan);
            }
            MapredLocalWork.BucketMapJoinContext bucketMJCxt = new MapredLocalWork.BucketMapJoinContext();
            localPlan.setBucketMapjoinContext(bucketMJCxt);
            bucketMJCxt.setAliasBucketFileNameMapping(aliasBucketFileNameMapping);
            bucketMJCxt.setBucketFileNameMapping(((MapJoinDesc)currMapJoinOp.getConf()).getBucketFileNameMapping());
            localPlan.setInputFileChangeSensitive(true);
            bucketMJCxt.setMapJoinBigTableAlias(((MapJoinDesc)currMapJoinOp.getConf()).getBigTableAlias());
            bucketMJCxt.setBucketMatcherClass(DefaultBucketMatcher.class);
        }
    }

    public static void initUnionPlan(ReduceSinkOperator op, GenMRProcContext opProcCtx) throws SemanticException {
        Operator<Serializable> reducer = op.getChildOperators().get(0);
        LinkedHashMap<Operator<? extends Serializable>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = opProcCtx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(op.getParentOperators().get(0));
        Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
        MapredWork plan = (MapredWork)currTask.getWork();
        HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
        opTaskMap.put(reducer, currTask);
        plan.setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
        plan.setNumReduceTasks(desc.getNumReducers());
        if (reducer.getClass() == JoinOperator.class) {
            plan.setNeedsTagging(true);
        }
        GenMapRedUtils.initUnionPlan(opProcCtx, currTask, false);
    }

    public static void initUnionPlan(GenMRProcContext opProcCtx, Task<? extends Serializable> currTask, boolean local) {
        MapredWork plan = (MapredWork)currTask.getWork();
        UnionOperator currUnionOp = opProcCtx.getCurrUnionOp();
        assert (currUnionOp != null);
        GenMRProcContext.GenMRUnionCtx uCtx = opProcCtx.getUnionTask(currUnionOp);
        assert (uCtx != null);
        List<String> taskTmpDirLst = uCtx.getTaskTmpDir();
        List<TableDesc> tt_descLst = uCtx.getTTDesc();
        assert (!taskTmpDirLst.isEmpty() && !tt_descLst.isEmpty());
        assert (taskTmpDirLst.size() == tt_descLst.size());
        int size = taskTmpDirLst.size();
        assert (!local);
        for (int pos = 0; pos < size; ++pos) {
            String taskTmpDir = taskTmpDirLst.get(pos);
            TableDesc tt_desc = tt_descLst.get(pos);
            if (plan.getPathToAliases().get(taskTmpDir) != null) continue;
            plan.getPathToAliases().put(taskTmpDir, new ArrayList());
            plan.getPathToAliases().get(taskTmpDir).add(taskTmpDir);
            plan.getPathToPartitionInfo().put(taskTmpDir, new PartitionDesc(tt_desc, null));
            plan.getAliasToWork().put(taskTmpDir, currUnionOp);
        }
    }

    public static void joinPlan(Operator<? extends Serializable> op, Task<? extends Serializable> oldTask, Task<? extends Serializable> task, GenMRProcContext opProcCtx, int pos, boolean split, boolean readMapJoinData, boolean readUnionData) throws SemanticException {
        GenMapRedUtils.joinPlan(op, oldTask, task, opProcCtx, pos, split, readMapJoinData, readUnionData, false);
    }

    public static void joinPlan(Operator<? extends Serializable> op, Task<? extends Serializable> oldTask, Task<? extends Serializable> task, GenMRProcContext opProcCtx, int pos, boolean split, boolean readMapJoinData, boolean readUnionData, boolean createLocalWork) throws SemanticException {
        Task<? extends Serializable> currTask = task;
        MapredWork plan = (MapredWork)currTask.getWork();
        Operator<? extends Serializable> currTopOp = opProcCtx.getCurrTopOp();
        ArrayList<Task<Serializable>> parTasks = null;
        if (split) {
            assert (oldTask != null);
            GenMapRedUtils.splitTasks(op, oldTask, currTask, opProcCtx, true, false, 0);
        } else if (oldTask != null && oldTask.getParentTasks() != null && !oldTask.getParentTasks().isEmpty()) {
            Object[] parTaskArr;
            parTasks = new ArrayList<Task<Serializable>>();
            parTasks.addAll(oldTask.getParentTasks());
            for (Object element : parTaskArr = parTasks.toArray()) {
                ((Task)element).removeDependentTask(oldTask);
            }
        }
        if (currTopOp != null) {
            List<Operator<? extends Serializable>> seenOps = opProcCtx.getSeenOps();
            String currAliasId = opProcCtx.getCurrAliasId();
            if (!seenOps.contains(currTopOp)) {
                boolean bl;
                seenOps.add(currTopOp);
                boolean bl2 = false;
                if (pos != -1) {
                    bl = pos != ((MapJoinDesc)op.getConf()).getPosBigTable();
                }
                GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, plan, bl, opProcCtx);
                if (op instanceof AbstractMapJoinOperator) {
                    GenMapRedUtils.setupBucketMapJoinInfo(plan, (AbstractMapJoinOperator)op, createLocalWork);
                }
            }
            currTopOp = null;
            opProcCtx.setCurrTopOp(currTopOp);
        } else if (opProcCtx.getCurrMapJoinOp() != null) {
            AbstractMapJoinOperator<? extends MapJoinDesc> mjOp = opProcCtx.getCurrMapJoinOp();
            if (readUnionData) {
                GenMapRedUtils.initUnionPlan(opProcCtx, currTask, false);
            } else {
                boolean local;
                GenMRProcContext.GenMRMapJoinCtx mjCtx = opProcCtx.getMapJoinCtx(mjOp);
                AbstractMapJoinOperator<? extends MapJoinDesc> abstractMapJoinOperator = mjCtx.getOldMapJoin();
                String taskTmpDir = null;
                TableDesc tt_desc = null;
                Operator<? extends Serializable> rootOp = null;
                boolean bl = local = pos != -1 && pos != ((MapJoinDesc)mjOp.getConf()).getPosBigTable();
                if (abstractMapJoinOperator == null) {
                    if (opProcCtx.getParseCtx().getListMapJoinOpsNoReducer().contains(mjOp) || local || oldTask != null && parTasks != null) {
                        taskTmpDir = mjCtx.getTaskTmpDir();
                        tt_desc = mjCtx.getTTDesc();
                        rootOp = mjCtx.getRootMapJoinOp();
                    }
                } else {
                    GenMRProcContext.GenMRMapJoinCtx oldMjCtx = opProcCtx.getMapJoinCtx(abstractMapJoinOperator);
                    assert (oldMjCtx != null);
                    taskTmpDir = oldMjCtx.getTaskTmpDir();
                    tt_desc = oldMjCtx.getTTDesc();
                    rootOp = oldMjCtx.getRootMapJoinOp();
                }
                GenMapRedUtils.setTaskPlan(taskTmpDir, taskTmpDir, rootOp, plan, local, tt_desc);
                GenMapRedUtils.setupBucketMapJoinInfo(plan, abstractMapJoinOperator, createLocalWork);
            }
            opProcCtx.setCurrMapJoinOp(null);
            if (oldTask != null && parTasks != null) {
                for (Task task2 : parTasks) {
                    task2.addDependentTask(currTask);
                    if (!opProcCtx.getRootTasks().contains(currTask)) continue;
                    opProcCtx.getRootTasks().remove(currTask);
                }
            }
        }
        opProcCtx.setCurrTask(currTask);
    }

    public static void splitPlan(ReduceSinkOperator op, GenMRProcContext opProcCtx) throws SemanticException {
        ParseContext parseCtx = opProcCtx.getParseCtx();
        MapredWork cplan = GenMapRedUtils.getMapRedWork(parseCtx);
        Task<MapredWork> redTask = TaskFactory.get(cplan, parseCtx.getConf(), new Task[0]);
        Operator<Serializable> reducer = op.getChildOperators().get(0);
        cplan.setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
        cplan.setNumReduceTasks(new Integer(desc.getNumReducers()));
        HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
        opTaskMap.put(reducer, redTask);
        Task<? extends Serializable> currTask = opProcCtx.getCurrTask();
        GenMapRedUtils.splitTasks(op, currTask, redTask, opProcCtx, true, false, 0);
        opProcCtx.getRootOps().add(op);
    }

    public static void setTaskPlan(String alias_id, Operator<? extends Serializable> topOp, MapredWork plan, boolean local, GenMRProcContext opProcCtx) throws SemanticException {
        GenMapRedUtils.setTaskPlan(alias_id, topOp, plan, local, opProcCtx, null);
    }

    public static void setTaskPlan(String alias_id, Operator<? extends Serializable> topOp, MapredWork plan, boolean local, GenMRProcContext opProcCtx, PrunedPartitionList pList) throws SemanticException {
        ParseContext parseCtx = opProcCtx.getParseCtx();
        Set<ReadEntity> inputs = opProcCtx.getInputs();
        ArrayList<Path> partDir = new ArrayList<Path>();
        ArrayList<PartitionDesc> partDesc = new ArrayList<PartitionDesc>();
        Path tblDir = null;
        TableDesc tblDesc = null;
        PrunedPartitionList partsList = pList;
        plan.setNameToSplitSample(parseCtx.getNameToSplitSample());
        if (partsList == null) {
            try {
                partsList = parseCtx.getOpToPartList().get((TableScanOperator)topOp);
                if (partsList == null) {
                    partsList = PartitionPruner.prune(parseCtx.getTopToTable().get(topOp), parseCtx.getOpToPartPruner().get(topOp), opProcCtx.getConf(), alias_id, parseCtx.getPrunedPartitions());
                    parseCtx.getOpToPartList().put((TableScanOperator)topOp, partsList);
                }
            }
            catch (SemanticException e) {
                throw e;
            }
            catch (HiveException e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new SemanticException(e.getMessage(), e);
            }
        }
        Set<Partition> parts = null;
        parts = partsList.getConfirmedPartns();
        parts.addAll(partsList.getUnknownPartns());
        PartitionDesc aliasPartnDesc = null;
        try {
            if (!parts.isEmpty()) {
                aliasPartnDesc = Utilities.getPartitionDesc(parts.iterator().next());
            }
        }
        catch (HiveException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        if (aliasPartnDesc == null) {
            aliasPartnDesc = new PartitionDesc(Utilities.getTableDesc(parseCtx.getTopToTable().get(topOp)), null);
        }
        plan.getAliasToPartnInfo().put(alias_id, aliasPartnDesc);
        long sizeNeeded = Integer.MAX_VALUE;
        int fileLimit = -1;
        if (parseCtx.getGlobalLimitCtx().isEnable()) {
            long sizePerRow = HiveConf.getLongVar(parseCtx.getConf(), HiveConf.ConfVars.HIVELIMITMAXROWSIZE);
            sizeNeeded = (long)parseCtx.getGlobalLimitCtx().getGlobalLimit() * sizePerRow;
            fileLimit = HiveConf.getIntVar(parseCtx.getConf(), HiveConf.ConfVars.HIVELIMITOPTLIMITFILE);
            if (sizePerRow <= 0L || fileLimit <= 0) {
                LOG.info((Object)"Skip optimization to reduce input size of 'limit'");
                parseCtx.getGlobalLimitCtx().disableOpt();
            } else if (parts.isEmpty()) {
                LOG.info((Object)"Empty input: skip limit optimiztion");
            } else {
                LOG.info((Object)("Try to reduce input size for 'limit' sizeNeeded: " + sizeNeeded + "  file limit : " + fileLimit));
            }
        }
        boolean isFirstPart = true;
        boolean emptyInput = true;
        boolean singlePartition = parts.size() == 1;
        for (Partition part : parts) {
            if (part.getTable().isPartitioned()) {
                inputs.add(new ReadEntity(part));
            } else {
                inputs.add(new ReadEntity(part.getTable()));
            }
            Path[] paths = null;
            FilterDesc.sampleDesc sampleDescr = parseCtx.getOpToSamplePruner().get(topOp);
            if (sampleDescr != null) {
                paths = SamplePruner.prune(part, sampleDescr);
                parseCtx.getGlobalLimitCtx().disableOpt();
            } else {
                if (parseCtx.getGlobalLimitCtx().isEnable()) {
                    if (isFirstPart) {
                        long sizeLeft = sizeNeeded;
                        ArrayList<Path> retPathList = new ArrayList<Path>();
                        SamplePruner.LimitPruneRetStatus status = SamplePruner.limitPrune(part, sizeLeft, fileLimit, retPathList);
                        if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NoFile)) continue;
                        if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NotQualify)) {
                            LOG.info((Object)("Use full input -- first " + fileLimit + " files are more than " + sizeNeeded + " bytes"));
                            parseCtx.getGlobalLimitCtx().disableOpt();
                        } else {
                            emptyInput = false;
                            paths = new Path[retPathList.size()];
                            int index = 0;
                            for (Path path : retPathList) {
                                paths[index++] = path;
                            }
                            if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NeedAllFiles) && singlePartition) {
                                parseCtx.getGlobalLimitCtx().disableOpt();
                            }
                        }
                        isFirstPart = false;
                    } else {
                        paths = new Path[]{};
                    }
                }
                if (!parseCtx.getGlobalLimitCtx().isEnable()) {
                    paths = part.getPath();
                }
            }
            if (!part.getTable().isPartitioned()) {
                assert (tblDir == null && tblDesc == null);
                tblDir = paths[0];
                tblDesc = Utilities.getTableDesc(part.getTable());
            } else if (tblDesc == null) {
                tblDesc = Utilities.getTableDesc(part.getTable());
            }
            for (Path p : paths) {
                if (p == null) continue;
                String path = p.toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding " + path + " of table" + alias_id));
                }
                partDir.add(p);
                try {
                    partDesc.add(Utilities.getPartitionDescFromTableDesc(tblDesc, part));
                }
                catch (HiveException e) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                    throw new SemanticException(e.getMessage(), e);
                }
            }
        }
        if (emptyInput) {
            parseCtx.getGlobalLimitCtx().disableOpt();
        }
        Iterator iterPath = partDir.iterator();
        Iterator iterPartnDesc = partDesc.iterator();
        if (!local) {
            while (iterPath.hasNext()) {
                assert (iterPartnDesc.hasNext());
                String path = ((Path)iterPath.next()).toString();
                PartitionDesc prtDesc = (PartitionDesc)iterPartnDesc.next();
                if (plan.getPathToAliases().get(path) == null) {
                    plan.getPathToAliases().put(path, new ArrayList());
                }
                plan.getPathToAliases().get(path).add(alias_id);
                plan.getPathToPartitionInfo().put(path, prtDesc);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Information added for path " + path));
            }
            assert (plan.getAliasToWork().get(alias_id) == null);
            plan.getAliasToWork().put(alias_id, topOp);
        } else {
            MapredLocalWork localPlan = plan.getMapLocalWork();
            if (localPlan == null) {
                localPlan = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends Serializable>>(), new LinkedHashMap<String, FetchWork>());
            }
            assert (localPlan.getAliasToWork().get(alias_id) == null);
            assert (localPlan.getAliasToFetchWork().get(alias_id) == null);
            localPlan.getAliasToWork().put(alias_id, topOp);
            if (tblDir == null) {
                localPlan.getAliasToFetchWork().put(alias_id, new FetchWork(FetchWork.convertPathToStringArray(partDir), partDesc));
            } else {
                localPlan.getAliasToFetchWork().put(alias_id, new FetchWork(tblDir.toString(), tblDesc));
            }
            plan.setMapLocalWork(localPlan);
        }
    }

    public static void setTaskPlan(String path, String alias, Operator<? extends Serializable> topOp, MapredWork plan, boolean local, TableDesc tt_desc) throws SemanticException {
        if (path == null || alias == null) {
            return;
        }
        if (!local) {
            if (plan.getPathToAliases().get(path) == null) {
                plan.getPathToAliases().put(path, new ArrayList());
            }
            plan.getPathToAliases().get(path).add(alias);
            plan.getPathToPartitionInfo().put(path, new PartitionDesc(tt_desc, null));
            plan.getAliasToWork().put(alias, topOp);
        } else {
            MapredLocalWork localPlan = plan.getMapLocalWork();
            if (localPlan == null) {
                localPlan = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends Serializable>>(), new LinkedHashMap<String, FetchWork>());
            }
            assert (localPlan.getAliasToWork().get(alias) == null);
            assert (localPlan.getAliasToFetchWork().get(alias) == null);
            localPlan.getAliasToWork().put(alias, topOp);
            localPlan.getAliasToFetchWork().put(alias, new FetchWork(alias, tt_desc));
            plan.setMapLocalWork(localPlan);
        }
    }

    public static void setKeyAndValueDesc(MapredWork plan, Operator<? extends Serializable> topOp) {
        if (topOp == null) {
            return;
        }
        if (topOp instanceof ReduceSinkOperator) {
            ReduceSinkOperator rs = (ReduceSinkOperator)topOp;
            plan.setKeyDesc(((ReduceSinkDesc)rs.getConf()).getKeySerializeInfo());
            int tag = Math.max(0, ((ReduceSinkDesc)rs.getConf()).getTag());
            List<TableDesc> tagToSchema = plan.getTagToValueDesc();
            while (tag + 1 > tagToSchema.size()) {
                tagToSchema.add(null);
            }
            tagToSchema.set(tag, ((ReduceSinkDesc)rs.getConf()).getValueSerializeInfo());
        } else {
            List<Operator<Serializable>> children = topOp.getChildOperators();
            if (children != null) {
                for (Operator<Serializable> op : children) {
                    GenMapRedUtils.setKeyAndValueDesc(plan, op);
                }
            }
        }
    }

    public static MapredWork getMapRedWork(ParseContext parseCtx) {
        MapredWork work = GenMapRedUtils.getMapRedWorkFromConf(parseCtx.getConf());
        work.setNameToSplitSample(parseCtx.getNameToSplitSample());
        return work;
    }

    public static MapredWork getMapRedWorkFromConf(HiveConf conf) {
        MapredWork work = new MapredWork();
        boolean mapperCannotSpanPartns = conf.getBoolVar(HiveConf.ConfVars.HIVE_MAPPER_CANNOT_SPAN_MULTIPLE_PARTITIONS);
        work.setMapperCannotSpanPartns(mapperCannotSpanPartns);
        work.setPathToAliases(new LinkedHashMap<String, ArrayList<String>>());
        work.setPathToPartitionInfo(new LinkedHashMap<String, PartitionDesc>());
        work.setAliasToWork(new LinkedHashMap<String, Operator<? extends Serializable>>());
        work.setTagToValueDesc(new ArrayList<TableDesc>());
        work.setReducer(null);
        work.setHadoopSupportsSplittable(conf.getBoolVar(HiveConf.ConfVars.HIVE_COMBINE_INPUT_FORMAT_SUPPORTS_SPLITTABLE));
        return work;
    }

    private static Operator<? extends Serializable> putOpInsertMap(Operator<? extends Serializable> op, RowResolver rr, ParseContext parseCtx) {
        OpParseContext ctx = new OpParseContext(rr);
        parseCtx.getOpParseCtx().put(op, ctx);
        return op;
    }

    public static void splitTasks(Operator<? extends Serializable> op, Task<? extends Serializable> parentTask, Task<? extends Serializable> childTask, GenMRProcContext opProcCtx, boolean setReducer, boolean local, int posn) throws SemanticException {
        childTask.getWork();
        Operator<? extends Serializable> currTopOp = opProcCtx.getCurrTopOp();
        ParseContext parseCtx = opProcCtx.getParseCtx();
        parentTask.addDependentTask(childTask);
        List<Task<? extends Serializable>> rootTasks = opProcCtx.getRootTasks();
        if (rootTasks.contains(childTask)) {
            rootTasks.remove(childTask);
        }
        Context baseCtx = parseCtx.getContext();
        String taskTmpDir = baseCtx.getMRTmpFileURI();
        Operator<Serializable> parent = op.getParentOperators().get(posn);
        TableDesc tt_desc = PlanUtils.getIntermediateFileTableDesc(PlanUtils.getFieldSchemasFromRowSchema(parent.getSchema(), "temporarycol"));
        boolean compressIntermediate = parseCtx.getConf().getBoolVar(HiveConf.ConfVars.COMPRESSINTERMEDIATE);
        FileSinkDesc desc = new FileSinkDesc(taskTmpDir, tt_desc, compressIntermediate);
        if (compressIntermediate) {
            desc.setCompressCodec(parseCtx.getConf().getVar(HiveConf.ConfVars.COMPRESSINTERMEDIATECODEC));
            desc.setCompressType(parseCtx.getConf().getVar(HiveConf.ConfVars.COMPRESSINTERMEDIATETYPE));
        }
        Operator<? extends Serializable> fs_op = GenMapRedUtils.putOpInsertMap(OperatorFactory.get(desc, parent.getSchema(), new Operator[0]), null, parseCtx);
        List<Operator<? extends Serializable>> childOpList = parent.getChildOperators();
        for (int pos = 0; pos < childOpList.size(); ++pos) {
            if (childOpList.get(pos) != op) continue;
            childOpList.set(pos, fs_op);
            break;
        }
        ArrayList<Operator<? extends Serializable>> parentOpList = new ArrayList<Operator<? extends Serializable>>();
        parentOpList.add(parent);
        fs_op.setParentOperators(parentOpList);
        RowResolver rowResolver = opProcCtx.getParseCtx().getOpParseCtx().get(parent).getRowResolver();
        Operator<? extends Serializable> ts_op = GenMapRedUtils.putOpInsertMap(OperatorFactory.get(TableScanDesc.class, parent.getSchema()), rowResolver, parseCtx);
        childOpList = new ArrayList<Operator<Serializable>>();
        childOpList.add(op);
        ts_op.setChildOperators(childOpList);
        op.getParentOperators().set(posn, ts_op);
        LinkedHashMap<Operator<? extends Serializable>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = opProcCtx.getMapCurrCtx();
        mapCurrCtx.put(ts_op, new GenMRProcContext.GenMapRedCtx(childTask, null, null));
        String streamDesc = taskTmpDir;
        MapredWork cplan = (MapredWork)childTask.getWork();
        if (setReducer) {
            Operator<Serializable> reducer = op.getChildOperators().get(0);
            if (reducer.getClass() == JoinOperator.class) {
                String origStreamDesc = streamDesc = "$INTNAME";
                int pos = 0;
                while (cplan.getAliasToWork().get(streamDesc) != null) {
                    streamDesc = origStreamDesc.concat(String.valueOf(++pos));
                }
            }
            if (reducer.getClass() == JoinOperator.class) {
                cplan.setNeedsTagging(true);
            }
        }
        GenMapRedUtils.setTaskPlan(taskTmpDir, streamDesc, ts_op, cplan, local, tt_desc);
        if (op instanceof AbstractMapJoinOperator) {
            AbstractMapJoinOperator mjOp = (AbstractMapJoinOperator)op;
            opProcCtx.setCurrMapJoinOp(mjOp);
            GenMRProcContext.GenMRMapJoinCtx mjCtx = opProcCtx.getMapJoinCtx(mjOp);
            if (mjCtx == null) {
                mjCtx = new GenMRProcContext.GenMRMapJoinCtx(taskTmpDir, tt_desc, ts_op, null);
            } else {
                mjCtx.setTaskTmpDir(taskTmpDir);
                mjCtx.setTTDesc(tt_desc);
                mjCtx.setRootMapJoinOp(ts_op);
            }
            opProcCtx.setMapJoinCtx(mjOp, mjCtx);
            opProcCtx.getMapCurrCtx().put(parent, new GenMRProcContext.GenMapRedCtx(childTask, null, null));
            GenMapRedUtils.setupBucketMapJoinInfo(cplan, mjOp, false);
        }
        currTopOp = null;
        String currAliasId = null;
        opProcCtx.setCurrTopOp(currTopOp);
        opProcCtx.setCurrAliasId(currAliasId);
        opProcCtx.setCurrTask(childTask);
    }

    public static void mergeMapJoinUnion(UnionOperator union, GenMRProcContext ctx, int pos) throws SemanticException {
        ParseContext parseCtx = ctx.getParseCtx();
        UnionProcContext uCtx = parseCtx.getUCtx();
        UnionProcContext.UnionParseContext uPrsCtx = uCtx.getUnionParseContext(union);
        assert (uPrsCtx != null);
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        GenMRProcContext.GenMRUnionCtx uCtxTask = ctx.getUnionTask(union);
        Task<? extends Serializable> uTask = null;
        union.getParentOperators().get(pos);
        MapredWork uPlan = null;
        if (uCtxTask == null) {
            uCtxTask = new GenMRProcContext.GenMRUnionCtx();
            uPlan = GenMapRedUtils.getMapRedWork(parseCtx);
            uTask = TaskFactory.get(uPlan, parseCtx.getConf(), new Task[0]);
            uCtxTask.setUTask(uTask);
            ctx.setUnionTask(union, uCtxTask);
        } else {
            uTask = uCtxTask.getUTask();
            uPlan = (MapredWork)uTask.getWork();
        }
        if (uPrsCtx.getMapJoinSubq(pos)) {
            GenMRProcContext.GenMRMapJoinCtx mjCtx = ctx.getMapJoinCtx(ctx.getCurrMapJoinOp());
            String taskTmpDir = mjCtx.getTaskTmpDir();
            if (uPlan.getPathToAliases().get(taskTmpDir) == null) {
                uPlan.getPathToAliases().put(taskTmpDir, new ArrayList());
                uPlan.getPathToAliases().get(taskTmpDir).add(taskTmpDir);
                uPlan.getPathToPartitionInfo().put(taskTmpDir, new PartitionDesc(mjCtx.getTTDesc(), null));
                uPlan.getAliasToWork().put(taskTmpDir, mjCtx.getRootMapJoinOp());
            }
            for (Task<Serializable> t : currTask.getParentTasks()) {
                t.addDependentTask(uTask);
            }
            try {
                boolean notDone = true;
                while (notDone) {
                    for (Task<Serializable> t : currTask.getParentTasks()) {
                        t.removeDependentTask(currTask);
                    }
                    notDone = false;
                }
            }
            catch (ConcurrentModificationException e) {}
        } else {
            GenMapRedUtils.setTaskPlan(ctx.getCurrAliasId(), ctx.getCurrTopOp(), uPlan, false, ctx);
        }
        ctx.setCurrTask(uTask);
        ctx.setCurrAliasId(null);
        ctx.setCurrTopOp(null);
        ctx.setCurrMapJoinOp(null);
        ctx.getMapCurrCtx().put(union, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), null, null));
    }

    private GenMapRedUtils() {
    }
}

