/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.charts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rex.graphics.charts.Chart;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;

public class ChartPickerDialog
extends JDialog
implements LanguageChangedListener {
    boolean[] chartSelected;
    private static final int OPTIONS_COUNT = 6;
    ArrayList retVal;
    JButton jb;

    public ChartPickerDialog(JFrame owner, int[] selChartType) {
        super(owner, I18n.getString("frame.chartPicker"), true);
        this.setDefaultCloseOperation(0);
        this.retVal = new ArrayList();
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new GridLayout(6, 2));
        final Object[][] options = new Object[6][3];
        options[0][0] = "Vertical bar";
        options[0][1] = Chart.getIconForType(0);
        options[0][2] = new Integer(0);
        options[1][0] = "Horizontal bar";
        options[1][1] = Chart.getIconForType(1);
        options[1][2] = new Integer(1);
        options[2][0] = "3D vertical bar";
        options[2][1] = Chart.getIconForType(2);
        options[2][2] = new Integer(2);
        options[3][0] = "3D horizontal bar";
        options[3][1] = Chart.getIconForType(3);
        options[3][2] = new Integer(3);
        options[4][0] = "3D pie chart";
        options[4][1] = Chart.getIconForType(4);
        options[4][2] = new Integer(4);
        options[5][0] = "Combined";
        options[5][1] = Chart.getIconForType(5);
        options[5][2] = new Integer(5);
        this.chartSelected = new boolean[6];
        block0: for (int i = 0; i < 6; ++i) {
            this.chartSelected[i] = false;
            for (int type = 0; selChartType != null && type < selChartType.length; ++type) {
                if ((Integer)options[i][2] != selChartType[type]) continue;
                this.chartSelected[i] = true;
                continue block0;
            }
        }
        for (int i = 0; i < 6; ++i) {
            JCheckBox chkbx = new JCheckBox((String)options[i][0], this.chartSelected[i]);
            chkbx.addItemListener(new ChartPickerListener(i));
            upperPanel.add(new JLabel((ImageIcon)options[i][1]));
            upperPanel.add(chkbx);
        }
        upperPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.getContentPane().add((Component)upperPanel, "Center");
        this.jb = new JButton(I18n.getString("btn.selectedCharts"));
        this.jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < 6; ++i) {
                    if (!ChartPickerDialog.this.chartSelected[i]) continue;
                    ChartPickerDialog.this.retVal.add(options[i][2]);
                }
                ChartPickerDialog.this.setVisible(false);
            }
        });
        this.getContentPane().add((Component)this.jb, "South");
        this.getToolkit();
        Dimension myScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(myScreenSize.width / 2 - 200, myScreenSize.height / 2 - 200);
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public Integer[] getSelectedChartTypes() {
        return this.retVal.toArray(new Integer[0]);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("testing");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ChartPickerDialog dialog = new ChartPickerDialog((JFrame)frame.getRootPane().getParent(), new int[]{1, 3});
        frame.pack();
        frame.setVisible(true);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }

    public void applyI18n() {
        this.jb.setText(I18n.getString("btn.selectedCharts"));
    }

    class ChartPickerListener
    implements ItemListener {
        int myIndex;

        ChartPickerListener(int index) {
            this.myIndex = index;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ChartPickerDialog.this.chartSelected[this.myIndex] = e.getStateChange() == 1;
        }
    }
}

