/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

class ColorMenu
extends JMenu {
    protected ColorPane colorPane;
    Color current = Color.WHITE;

    public ColorMenu(String name) {
        super(name);
        this.colorPane = new ColorPane();
        this.colorPane.setBorder(new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white)));
        SelectListener selectListener = new SelectListener();
        this.colorPane.addMouseListener(selectListener);
        this.add(this.colorPane);
    }

    public void setColor(Color c) {
        if (c == null) {
            return;
        }
    }

    public Color getColor() {
        return this.current;
    }

    public void doSelection() {
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    class ColorPane
    extends JPanel {
        protected Color[] colors;
        protected Dimension paneSize;
        protected Dimension numPane;
        protected Dimension gap;

        public ColorPane() {
            this.initValues();
            this.initColors();
            this.setToolTipText("");
            this.setOpaque(true);
            this.setBackground(Color.white);
        }

        protected void initValues() {
            this.paneSize = new Dimension(10, 10);
            this.numPane = new Dimension(24, 9);
            this.gap = new Dimension(1, 1);
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int row = 0; row < this.numPane.height; ++row) {
                for (int column = 0; column < this.numPane.width; ++column) {
                    g.setColor(this.getColorForCell(column, row));
                    int x = !this.getComponentOrientation().isLeftToRight() ? (this.numPane.width - column - 1) * (this.paneSize.width + this.gap.width) : column * (this.paneSize.width + this.gap.width);
                    int y = row * (this.paneSize.height + this.gap.height);
                    g.fillRect(x, y, this.paneSize.width, this.paneSize.height);
                    g.setColor(Color.black);
                    g.drawLine(x + this.paneSize.width - 1, y, x + this.paneSize.width - 1, y + this.paneSize.height - 1);
                    g.drawLine(x, y + this.paneSize.height - 1, x + this.paneSize.width - 1, y + this.paneSize.height - 1);
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int w = this.numPane.width * (this.paneSize.width + this.gap.width) - 1;
            int h = this.numPane.height * (this.paneSize.height + this.gap.height) - 1;
            return new Dimension(w, h);
        }

        protected void initColors() {
            this.colors = new Color[216];
            int counter = 0;
            int[] values = new int[]{0, 32, 64, 128, 192, 255};
            for (int r = 0; r < values.length; ++r) {
                for (int g = 0; g < values.length; ++g) {
                    for (int b = 0; b < values.length; ++b) {
                        this.colors[counter] = new Color(values[r], values[g], values[b]);
                        ++counter;
                    }
                }
            }
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Color color = this.getColorForLocation(e.getX(), e.getY());
            return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        }

        public Color getColorForLocation(int x, int y) {
            int column = !this.getComponentOrientation().isLeftToRight() ? this.numPane.width - x / (this.paneSize.width + this.gap.width) - 1 : x / (this.paneSize.width + this.gap.width);
            int row = y / (this.paneSize.height + this.gap.height);
            return this.getColorForCell(column, row);
        }

        private Color getColorForCell(int column, int row) {
            return this.colors[row * this.numPane.width + column];
        }
    }

    class SelectListener
    extends MouseAdapter
    implements Serializable {
        SelectListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ColorMenu.this.current = ColorMenu.this.colorPane.getColorForLocation(e.getX(), e.getY());
            MenuSelectionManager.defaultManager().clearSelectedPath();
            ColorMenu.this.doSelection();
        }
    }
}

