/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import rex.graphics.mdxeditor.MdxEditor;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgAcceptAllStringNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgDimensionNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgEnumNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgHierarchyNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgLevelNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgLogicalNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgMemberNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgNumericNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgSetNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgStringNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgTupleNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNode;
import rex.graphics.mdxeditor.mdxfunctions.MdxArrayFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxDimensionFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxHierarchyFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxLevelFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxLogicalFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxMakeTupleFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxMemberFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxNumericFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxOperatorFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxSetFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxStringFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxTupleFunction;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MdxFunctionTree
extends JPanel
implements LanguageChangedListener {
    final JTree tree;
    private JComponent parent;
    private TreePath popUpSource;
    private boolean categorized;
    DefaultMutableTreeNode nonMdxFunctions;
    DefaultMutableTreeNode arrayFunctions;
    DefaultMutableTreeNode stringFunctions;
    DefaultMutableTreeNode dimensionHierarchyAndLevelFunctions;
    DefaultMutableTreeNode dimensionFunctions;
    DefaultMutableTreeNode hierarchyFunctions;
    DefaultMutableTreeNode levelFunctions;
    DefaultMutableTreeNode logicalFunctions;
    DefaultMutableTreeNode tupleFunctions;
    DefaultMutableTreeNode setFunctions;
    DefaultMutableTreeNode otherFunctions;
    DefaultMutableTreeNode numericFunctions;
    DefaultMutableTreeNode memberFunctions;
    DefaultMutableTreeNode allFunctions;
    DefaultMutableTreeNode top = new DefaultMutableTreeNode("");

    public MdxFunctionTree(JComponent _parent) {
        this();
        this.parent = _parent;
    }

    public MdxFunctionTree() {
        this.tree = new JTree(this.top){
            {
                this.setOpaque(false);
            }

            @Override
            public void paintComponent(Graphics g) {
                S.paintWhiteBackground(g, this);
                super.paintComponent(g);
            }
        };
        this.buildFunctionList(this.top);
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setPreferredSize(new Dimension(200, 600));
        treeView.setMaximumSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.add((Component)treeView, "Center");
        this.tree.setCellRenderer(new MdxFunctionTreeRenderer());
        this.tree.addMouseListener(new PopupListener());
        I18n.addOnLanguageChangedListener(this);
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.buildFunctionList(this.top);
        this.tree.updateUI();
        this.tree.repaint();
    }

    public JTree getTree() {
        return this.tree;
    }

    private void buildFunctionList(DefaultMutableTreeNode top) {
        this.nonMdxFunctions = new DefaultMutableTreeNode("Non MDX Functions");
        MdxFunction f = new MdxMakeTupleFunction("make tuple", I18n.getString("nonMDXFunction.makeTuple"), "(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9...])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode(false, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9", true, false)};
            }
        };
        this.nonMdxFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxOperatorFunction("*", I18n.getString("nonMDXFunction.multiplyOpr"), "(\u00d4\u00f8\u03a9Numeric Expression1\u00d4\u00f8\u03a9 * \u00d4\u00f8\u03a9Numeric Expression2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode(true, "\u00d4\u00f8\u03a9NumExp1\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9NumExp2\u00d4\u00f8\u03a9", true, false)};
            }
        };
        this.nonMdxFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxOperatorFunction("/", I18n.getString("nonMDXFunction.divideOpr"), "(\u00d4\u00f8\u03a9Numeric Expression1\u00d4\u00f8\u03a9 / \u00d4\u00f8\u03a9Numeric Expression2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode(true, "\u00d4\u00f8\u03a9NumExp1\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9NumExp2\u00d4\u00f8\u03a9", true, false)};
            }
        };
        this.nonMdxFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxOperatorFunction("+", I18n.getString("nonMDXFunction.addOpr"), "(\u00d4\u00f8\u03a9Numeric Expression1\u00d4\u00f8\u03a9 + \u00d4\u00f8\u03a9Numeric Expression2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode(true, "\u00d4\u00f8\u03a9NumExp1\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9NumExp2\u00d4\u00f8\u03a9", true, false)};
            }
        };
        this.nonMdxFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxOperatorFunction("-", I18n.getString("nonMDXFunction.subtractOpr"), "(\u00d4\u00f8\u03a9Numeric Expression1\u00d4\u00f8\u03a9 + \u00d4\u00f8\u03a9Numeric Expression2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode(true, "\u00d4\u00f8\u03a9NumExp1\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9NumExp2\u00d4\u00f8\u03a9", true, false)};
            }
        };
        this.nonMdxFunctions.add(new DefaultMutableTreeNode(f));
        this.arrayFunctions = new DefaultMutableTreeNode("Array Functions");
        f = new MdxArrayFunction("SetToArray", I18n.getString("arrayFunction.setToArray"), "SetToArray(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9...][, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9]"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode(false, "\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9", true, false), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.arrayFunctions.add(new DefaultMutableTreeNode(f));
        this.stringFunctions = new DefaultMutableTreeNode("String Functions");
        f = new MdxStringFunction("CalculationPassValue", I18n.getString("stringFunction.calcPassValue"), "CalculationPassValue(\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Pass Value\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Access Flag\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Pass Value\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "\u00d4\u00f8\u03a9Access Flag\u00d4\u00f8\u03a9", new String[]{"ABSOLUTE", "RELATIVE"}, false, true)};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("CoalesceEmpty", I18n.getString("stringFunction.coalescesEmpty"), "CoalesceEmpty(\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9]...)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", true, true)};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("Generate", I18n.getString("stringFunction.generate"), "Generate(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9[, ALL])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "ALL", new String[]{"ALL"}, false, true)};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("Generate", I18n.getString("stringFunction.generate"), "Generate(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Delimiter\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9"), new MBTArgStringNode(false, "\u00d4\u00f8\u03a9Delimiter\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("IIf", I18n.getString("stringFunction.iif"), "IIf(\u00d4\u00f8\u03a9Logical Expression\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric or String Expression1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric or String Expression2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLogicalNode("\u00d4\u00f8\u03a9Logical Expression\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9Numeric or String Expression1\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9Numeric or String Expression1\u00d4\u00f8\u03a9")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("LookupCube", I18n.getString("stringFunction.lookUpCube"), "LookupCube(\u00d4\u00f8\u03a9Cube String\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric or String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9Cube String\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9Numeric or String Expression1\u00d4\u00f8\u03a9")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("MemberToStr", I18n.getString("stringFunction.memberToStr"), "MemberToStr(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("Name", I18n.getString("stringFunction.name"), "\u00d4\u00f8\u03a9Dimension|Level|Member|Hierarchy\u00d4\u00f8\u03a9.Name"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode(true, "\u00d4\u00f8\u03a9Dimension|Level|Member|Hierarchy\u00d4\u00f8\u03a9")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("Properties", I18n.getString("stringFunction.properties"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.Properties(\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("SetToStr", I18n.getString("stringFunction.setToStr"), "SetToStr(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("TupleToStr", I18n.getString("stringFunction.tupleToStr"), "TupleToStr(\u00d4\u00f8\u03a9Tuple\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgTupleNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("UniqueName", I18n.getString("stringFunction.uniqueName"), "\u00d4\u00f8\u03a9Dimension/Level/Member/Hierarchy\u00d4\u00f8\u03a9.UniqueName"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00d4\u00f8\u03a9Dimension/Level/Member/Hierarchy\u00d4\u00f8\u03a9")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("UserName", I18n.getString("stringFunction.userName"), "UserName"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return null;
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        this.dimensionHierarchyAndLevelFunctions = new DefaultMutableTreeNode("Dimension, Hierarchy, and Level Functions ");
        this.dimensionFunctions = new DefaultMutableTreeNode("Dimension Functions");
        f = new MdxDimensionFunction("Dimension", I18n.getString("dimensionFunction.dimension"), "\u00d4\u00f8\u03a9Member|Level|Hierarchy\u00d4\u00f8\u03a9.Dimension"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00d4\u00f8\u03a9Member|Level|Hierarchy\u00d4\u00f8\u03a9")};
            }
        };
        this.dimensionFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxDimensionFunction("Dimensions", I18n.getString("dimensionFunction.dimensions"), "Dimensions(\u00d4\u00f8\u03a9Numeric/String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9Numeric or String Expression1\u00d4\u00f8\u03a9")};
            }
        };
        this.dimensionFunctions.add(new DefaultMutableTreeNode(f));
        this.hierarchyFunctions = new DefaultMutableTreeNode("Hierarchy Functions");
        f = new MdxHierarchyFunction("Hierarchy", I18n.getString("hierarchyFunction.hierarchy"), "\u00d4\u00f8\u03a9Member|Level\u00d4\u00f8\u03a9.Hierarchy"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00d4\u00f8\u03a9Member|Level\u00d4\u00f8\u03a9")};
            }
        };
        this.hierarchyFunctions.add(new DefaultMutableTreeNode(f));
        this.levelFunctions = new DefaultMutableTreeNode("Level Functions");
        f = new MdxLevelFunction("Level", I18n.getString("levelFunction.level"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.Level"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9")};
            }
        };
        this.levelFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLevelFunction("Levels", I18n.getString("levelFunction.numeric"), "\u00d4\u00f8\u03a9Dimension\u00d4\u00f8\u03a9.Levels(\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgDimensionNode(true, "\u00d4\u00f8\u03a9Dimension\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.levelFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLevelFunction("Levels", I18n.getString("levelFunction.string"), "Levels(\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.levelFunctions.add(new DefaultMutableTreeNode(f));
        this.dimensionHierarchyAndLevelFunctions.add(this.dimensionFunctions);
        this.dimensionHierarchyAndLevelFunctions.add(this.hierarchyFunctions);
        this.dimensionHierarchyAndLevelFunctions.add(this.levelFunctions);
        this.logicalFunctions = new DefaultMutableTreeNode("Logical Functions");
        f = new MdxLogicalFunction("Is (TO BE DONE!!!!)", I18n.getString("logicalFunction.compare"), "\u00d4\u00f8\u03a9Object 1\u00d4\u00f8\u03a9 IS \u00d4\u00f8\u03a9Object 2\u00d4\u00f8\u03a9"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode(true, "\u00d4\u00f8\u03a9Object 1\u00d4\u00f8\u03a9"), new MBTArgAcceptAllStringNode("\u00d4\u00f8\u03a9Object 2\u00d4\u00f8\u03a9")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLogicalFunction("IsAncestor", I18n.getString("logicalFunction.isAncestor"), "IsAncestor(\u00d4\u00f8\u03a9Member1\u00d4\u00f8\u03a9,\u00d4\u00f8\u03a9Member2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "Member1\u00d4\u00f8\u03a9"), new MBTArgMemberNode("\u00d4\u00f8\u03a9Member2\u00d4\u00f8\u03a9")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLogicalFunction("IsEmpty", I18n.getString("logicalFunction.isEmpty"), "IsEmpty(\u00d4\u00f8\u03a9Value Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode("\u00d4\u00f8\u03a9Value Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLogicalFunction("IsGeneration", I18n.getString("logicalFunction.isGeneration"), "IsGeneration(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9,\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLogicalFunction("IsLeaf", I18n.getString("logicalFunction.isLeaf"), "IsLeaf(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLogicalFunction("IsSibling", I18n.getString("logicalFunction.isSibling"), "IsSibling(\u00d4\u00f8\u03a9Member1\u00d4\u00f8\u03a9,\u00d4\u00f8\u03a9Member2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member1\u00d4\u00f8\u03a9"), new MBTArgMemberNode("\u00d4\u00f8\u03a9Member2\u00d4\u00f8\u03a9")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        this.tupleFunctions = new DefaultMutableTreeNode("Tuple Functions");
        f = new MdxTupleFunction("Current", I18n.getString("tupleFunction.current"), "\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9.Current"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode(true, "\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9")};
            }
        };
        this.tupleFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxTupleFunction("Item", I18n.getString("tupleFunction.item"), "\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9.Item(\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9...] | \u00d4\u00f8\u03a9Index\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode(true, "\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgStringNode(false, "\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9", true, false)};
            }
        };
        this.tupleFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxTupleFunction("StrToTuple", I18n.getString("tupleFunction.strToTuple"), "StrToTuple(\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.tupleFunctions.add(new DefaultMutableTreeNode(f));
        this.memberFunctions = new DefaultMutableTreeNode("Member Functions");
        f = new MdxMemberFunction("Ancestor", I18n.getString("memberFunction.ancestor"), "Ancestor(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgLevelNode("\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Ancestor", I18n.getString("memberFunction.ancestor2"), "Ancestor(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("ClosingPeriod", I18n.getString("memberFunction.closingPeriod"), "ClosingPeriod([\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9]])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLevelNode("\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9"), new MBTArgMemberNode(false, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Cousin", I18n.getString("memberFunction.cousin"), "Cousin(\u00d4\u00f8\u03a9Member1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Member2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member1\u00d4\u00f8\u03a9"), new MBTArgMemberNode("\u00d4\u00f8\u03a9Member2\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("CurrentMember", I18n.getString("memberFunction.currentMember"), "\u00d4\u00f8\u03a9Dimension\u00d4\u00f8\u03a9.CurrentMember"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgDimensionNode(true, "\u00d4\u00f8\u03a9Dimension\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("DataMember", I18n.getString("memberFunction.dataMember"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.DataMember"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("DefaultMember", I18n.getString("memberFunction.defaultMember"), "\u00d4\u00f8\u03a9Dimension\u00d4\u00f8\u03a9.DefaultMember"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgDimensionNode(true, "\u00d4\u00f8\u03a9Dimension\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("FirstChild", I18n.getString("memberFunction.firstChild"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.FirstChild"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("FirstSibling", I18n.getString("memberFunction.firstSibling"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.FirstSibling"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Item", I18n.getString("memberFunction.item"), "\u00d4\u00f8\u03a9Tuple\u00d4\u00f8\u03a9.Item(\u00d4\u00f8\u03a9Index\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgTupleNode(true, "\u00d4\u00f8\u03a9Tuple\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Index\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Lag", I18n.getString("memberFunction.lag"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.Lag(\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("LastChild", I18n.getString("memberFunction.lastChild"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.LastChild"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("LastSibling", I18n.getString("memberFunction.lastSibling"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.LastSibling"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Lead", I18n.getString("memberFunction.lead"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.Lead(\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("LinkMember", I18n.getString("memberFunction.linkMember"), "LinkMember(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Hierarchy\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgHierarchyNode("\u00d4\u00f8\u03a9Hierarchy\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Members", I18n.getString("memberFunction.members"), "\u00d4\u00f8\u03a9Dimension|Hierarchy|Level|String Expression\u00d4\u00f8\u03a9.Members"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00d4\u00f8\u03a9Dimension|Hierarchy|Level|String Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("NextMember", I18n.getString("memberFunction.nextMember"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.NextMember"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("OpeningPeriod", I18n.getString("memberFunction.openingPeriod"), "OpeningPeriod([\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9]])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLevelNode(false, "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9", false, true), new MBTArgMemberNode(false, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("ParallelPeriod", I18n.getString("memberFunction.parallelPeriod"), "ParallelPeriod([\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9]]])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLevelNode(false, "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9", false, true), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true), new MBTArgMemberNode(false, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Parent", I18n.getString("memberFunction.parent"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.Parent"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("PrevMember", I18n.getString("memberFunction.prevMember"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.PrevMember"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("StrToMember", I18n.getString("memberFunction.strToMember"), "StrToMember(\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("ValidMeasure", I18n.getString("memberFunction.validMeasure"), "ValidMeasure(\u00d4\u00f8\u03a9Tuple\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgTupleNode("\u00d4\u00f8\u03a9Tuple\u00d4\u00f8\u03a9")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        this.numericFunctions = new DefaultMutableTreeNode("Numeric Functions");
        f = new MdxNumericFunction("Aggregate", I18n.getString("numericFunction.aggregate"), "Aggregate(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Avg", I18n.getString("numericFunction.avg"), "Avg(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("CalculationCurrentPass()", I18n.getString("numericFunction.calcPass"), "CalculationCurrentPass()"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return null;
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("CalculationPassValue", I18n.getString("numericFunction.clacPassValue"), "CalculationPassValue(\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Pass Value\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Access Flag\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Pass Value\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "\u00d4\u00f8\u03a9Access Flag\u00d4\u00f8\u03a9", new String[]{"ABSOLUTE", "RELATIVE"}, false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("CoalesceEmpty", I18n.getString("numericFunction.coalesceEmpty"), "CoalesceEmpty(\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9]...)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", true, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Correlation", I18n.getString("numericFunction.correlation"), "Correlation(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Dimensions.Count", I18n.getString("numericFunction.dimensionCount"), "Dimensions.Count"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return null;
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Levels.Count", I18n.getString("numericFunction.levelCount"), "\u00d4\u00f8\u03a9Dimension\u00d4\u00f8\u03a9|\u00d4\u00f8\u03a9Hierarchy\u00d4\u00f8\u03a9.Levels.Count"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00d4\u00f8\u03a9Dimension|Hierarchy\u00d4\u00f8\u03a9")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Count", I18n.getString("numericFunction.count"), "Count(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, ExcludeEmpty | IncludeEmpty])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "ExcludeEmpty | IncludeEmpty", new String[]{"ExcludeEmpty", "IncludeEmpty"}, false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Covariance", I18n.getString("numericFunction.covariance"), "Covariance(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("CovarianceN", I18n.getString("numericFunction.covarianceN"), "CovarianceN(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("DistinctCount", I18n.getString("numericFunction.distinctCount"), "DistinctCount(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("IIf", I18n.getString("numericFunction.iif"), "IIf(\u00d4\u00f8\u03a9Logical Expression\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric or String Expression1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric or String Expression2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLogicalNode("\u00d4\u00f8\u03a9Logical Expression\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9Numeric or String Expression1\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9Numeric or String Expression1\u00d4\u00f8\u03a9")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LinRegIntercept", I18n.getString("numericFunction.lineRegIncercept"), "LinRegIntercept(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LinRegPoint", I18n.getString("numericFunction.lineRegPoint"), "LinRegPoint(\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LinRegR2", I18n.getString("numericFunction.lineRegR2"), "LinRegR2(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LinRegSlope", I18n.getString("numericFunction.lineRegSlope"), "LinRegSlope(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LinRegVariance", I18n.getString("numericFunction.lineRegVariance"), "LinRegVariance(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LookupCube", I18n.getString("numericFunction.lookUpCube"), "LookupCube(\u00d4\u00f8\u03a9Cube String\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric|String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9Cube String\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9Numeric|String Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Max", I18n.getString("numericFunction.max"), "Max(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Median", I18n.getString("numericFunction.median"), "Median(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Min", I18n.getString("numericFunction.min"), "Min(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Ordinal", I18n.getString("numericFunction.ordinal"), "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9.Ordinal"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLevelNode(true, "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Predict", I18n.getString("numericFunction.predict"), "Predict(\u00d4\u00f8\u03a9Mining Model Name\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9Mining Model Name\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Rank", I18n.getString("numericFunction.rank"), "Rank(\u00d4\u00f8\u03a9Tuple\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Calc Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgTupleNode("\u00d4\u00f8\u03a9Tuple\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgAcceptAllStringNode(false, "\u00d4\u00f8\u03a9Calc Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("RollupChildren", I18n.getString("numericFunction.rollUpChildren"), "RollupChildren(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Stddev", I18n.getString("numericFunction.stdDev"), "Stdev(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("StddevP", I18n.getString("numericFunction.stdDevP"), "StdevP(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Stdev", I18n.getString("numericFunction.stdev"), "Stdev(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("StdevP", I18n.getString("numericFunction.stdevP"), "StdevP(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("StrToValue", I18n.getString("numericFunction.strToValue"), "StrToValue(\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Sum", I18n.getString("numericFunction.sum"), "Sum(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Value", I18n.getString("numericFunction.value"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.Value"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Var", I18n.getString("numericFunction.var"), "Var(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Variance", I18n.getString("numericFunction.variance"), "Variance(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("VarianceP", I18n.getString("numericFunction.varianceP"), "VarP(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("VarP", I18n.getString("numericFunction.varP"), "VarP(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        this.otherFunctions = new DefaultMutableTreeNode("Other Functions");
        this.setFunctions = new DefaultMutableTreeNode("Set Functions");
        f = new MdxSetFunction("AddCalculatedMembers", I18n.getString("setFunction.addCalcMembers"), "AddCalculatedMembers(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("AllMembers", I18n.getString("setFunction.allMembers"), "\u00d4\u00f8\u03a9Dimension|Level\u00d4\u00f8\u03a9.AllMembers"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00d4\u00f8\u03a9Dimension|Level\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Ancestors", I18n.getString("setFunction.ancestors"), "Ancestors(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Ancestors", I18n.getString("setFunction.ancestors2"), "Ancestors(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgLevelNode("\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Ascendants", I18n.getString("setFunction.ascendants"), "Ascendants(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Axis", I18n.getString("setFunction.axis"), "Axis(\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("BottomCount", I18n.getString("setFunction.bottomCount"), "BottomCount(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("BottomPercent", I18n.getString("setFunction.bottomPercent"), "BottomPercent(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Percentage\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Percentage\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("BottomSum", I18n.getString("setFunction.bottomSum"), "BottomSum(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Value\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Value\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Children", I18n.getString("setFunction.children"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.Children"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Crossjoin", I18n.getString("setFunction.crossJoin"), "Crossjoin(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Descendants", I18n.getString("setFunction.decendants"), "Descendants(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9, [\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Desc_flags\u00d4\u00f8\u03a9]])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgLevelNode(false, "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9", false, true), new MBTArgEnumNode(false, "\u00d4\u00f8\u03a9Desc_flags\u00d4\u00f8\u03a9", new String[]{"SELF", "AFTER", "BEFORE", "BEFORE_AND_AFTER", "SELF_AND_AFTER", "SELF_AND_BEFORE", "SELF_BEFORE_AFTER", "LEAVES"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Descendants", I18n.getString("setFunction.decendants"), "Descendants(\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Distance\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Desc_flags\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Distance\u00d4\u00f8\u03a9", false, true), new MBTArgEnumNode(false, "\u00d4\u00f8\u03a9Desc_flags\u00d4\u00f8\u03a9", new String[]{"SELF", "AFTER", "BEFORE", "BEFORE_AND_AFTER", "SELF_AND_AFTER", "SELF_AND_BEFORE", "SELF_BEFORE_AFTER", "LEAVES"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Distinct", I18n.getString("setFunction.distinct"), "Distinct(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownLevel", I18n.getString("setFunction.drillDownLevel"), "DrilldownLevel(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, {\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9 |  \u00d4\u00f8\u03a9Index\u00d4\u00f8\u03a9}])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgStringNode(false, "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9 |  \u00d4\u00f8\u03a9Index\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownLevelBottom", I18n.getString("setFunction.drillDownLevelBottom"), "DrilldownLevelBottom(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9[, [\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9][, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9]])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9"), new MBTArgLevelNode(false, "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9", false, true), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownLevelTop", I18n.getString("setFunction.drillDownLevelTop"), "DrilldownLevelTop(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9[, [\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9][, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9]])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9"), new MBTArgLevelNode(false, "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9", false, true), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownMember", I18n.getString("setFunction.drillDownMember"), "DrilldownMember(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9[, RECURSIVE])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "RECURSIVE", new String[]{"RECURSIVE"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownMemberBottom", I18n.getString("setFunction.drillDownMemberBottom"), "DrilldownMemberBottom(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9[, [\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9][, RECURSIVE]])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true), new MBTArgEnumNode(false, "RECURSIVE", new String[]{"RECURSIVE"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownMemberTop", I18n.getString("setFunction.drillDownMemberTop"), "DrilldownMemberTop(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9[, [\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9][, RECURSIVE]])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true), new MBTArgEnumNode(false, "RECURSIVE", new String[]{"RECURSIVE"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrillupLevel", I18n.getString("setFunction.drillUpLevel"), "DrillupLevel(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgLevelNode(false, "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrillupMember", I18n.getString("setFunction.drillupMembers"), "DrillupMember(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Except", I18n.getString("setFunction.except"), "Except(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9[, ALL])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "ALL", new String[]{"ALL"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Extract", I18n.getString("setFunction.extract"), "Extract(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Dimension\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Dimension\u00d4\u00f8\u03a9...])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgDimensionNode(false, "\u00d4\u00f8\u03a9Dimension\u00d4\u00f8\u03a9", true, false)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Filter", I18n.getString("setFunction.filter"), "Filter(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Search Condition\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9Search Condition\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Generate", I18n.getString("setFunction.generate"), "Generate(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9[, ALL])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "ALL", new String[]{"ALL"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Generate", I18n.getString("setFunction.generate"), "Generate(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Delimiter\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9"), new MBTArgStringNode(false, "\u00d4\u00f8\u03a9Delimiter\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Head", I18n.getString("setFunction.head"), "Head(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Hierarchize", I18n.getString("setFunction.hierarchize"), "Hierarchize(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, POST])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "POST", new String[]{"POST"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Intersect", I18n.getString("setFunction.intersect"), "Intersect(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9[, ALL])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "ALL", new String[]{"ALL"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("LastPeriods", I18n.getString("setFunction.lastPeriods"), "LastPeriods(\u00d4\u00f8\u03a9Index\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00d4\u00f8\u03a9Index\u00d4\u00f8\u03a9"), new MBTArgMemberNode(false, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Members", I18n.getString("setFunction.members"), "\u00d4\u00f8\u03a9Dimension|Hierarchy|Level\u00d4\u00f8\u03a9.Members"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode(true, "\u00d4\u00f8\u03a9Dimension|Hierarchy|Level\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Members", I18n.getString("setFunction.members"), "Members(\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Mtd", I18n.getString("setFunction.mtd"), "Mtd([\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(false, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("NameToSet", I18n.getString("setFunction.nameToSet"), "NameToSet(\u00d4\u00f8\u03a9Member Name\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9Member Name\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("NonEmptyCrossjoin", I18n.getString("setFunction.nonEmptyJoins"), "NonEmptyCrossjoin(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Set3\u00d4\u00f8\u03a9...][, \u00d4\u00f8\u03a9Crossjoin Set Count\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9"), new MBTArgSetNode(false, "\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9", true, true), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Crossjoin Set Count\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Order", I18n.getString("setFunction.order"), "Order(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, {\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9 | \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9} [, ASC | DESC | BASC | BDESC])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9 | \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "ASC | DESC | BASC | BDESC", new String[]{"ASC", "DESC", "BASC", "BDESC"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("PeriodsToDate", I18n.getString("setFunction.periodsToDate"), "PeriodsToDate([\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9]])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLevelNode(false, "\u00d4\u00f8\u03a9Level\u00d4\u00f8\u03a9", false, true), new MBTArgMemberNode(false, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Qtd", I18n.getString("setFunction.qtd"), "Qtd([\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(false, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Siblings", I18n.getString("setFunction.siblings"), "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9.Siblings"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("StripCalculatedMembers", I18n.getString("setFunction.stripCalcMembers"), "StripCalculatedMembers(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("StrToSet", I18n.getString("setFunction.strToSet"), "StrToSet(\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00d4\u00f8\u03a9String Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Subset", I18n.getString("setFunction.subset"), "Subset(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Start\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Start\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Tail", I18n.getString("setFunction.tail"), "Tail(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("ToggleDrillState", I18n.getString("setFunction.toggleDrillState"), "ToggleDrillState(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9[, RECURSIVE])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "RECURSIVE", new String[]{"RECURSIVE"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("TopCount", I18n.getString("setFunction.topCount"), "TopCount(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9[, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Count\u00d4\u00f8\u03a9"), new MBTArgNumericNode(false, "\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("TopPercent", I18n.getString("setFunction.topPercent"), "TopPercent(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Percentage\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Percentage\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("TopSum", I18n.getString("setFunction.topSum"), "TopSum(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Value\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Value\u00d4\u00f8\u03a9"), new MBTArgNumericNode("\u00d4\u00f8\u03a9Numeric Expression\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Union", I18n.getString("setFunction.union"), "Union(\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9[, ALL])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set1\u00d4\u00f8\u03a9"), new MBTArgSetNode("\u00d4\u00f8\u03a9Set2\u00d4\u00f8\u03a9"), new MBTArgEnumNode(false, "ALL", new String[]{"ALL"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("VisualTotals", I18n.getString("setFunction.visualTotals"), "VisualTotals(\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9, \u00d4\u00f8\u03a9Pattern\u00d4\u00f8\u03a9)"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00d4\u00f8\u03a9Set\u00d4\u00f8\u03a9"), new MBTArgStringNode("\u00d4\u00f8\u03a9Pattern\u00d4\u00f8\u03a9")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Wtd", I18n.getString("setFunction.wtd"), "Wtd([\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(false, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Ytd", I18n.getString("setFunction.ytd"), "Ytd([\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9])"){

            @Override
            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(false, "\u00d4\u00f8\u03a9Member\u00d4\u00f8\u03a9", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        this.allFunctions = new DefaultMutableTreeNode("All Functions");
        DefaultMutableTreeNode[] heads = new DefaultMutableTreeNode[]{this.arrayFunctions, this.dimensionFunctions, this.hierarchyFunctions, this.levelFunctions, this.memberFunctions, this.numericFunctions, this.setFunctions, this.stringFunctions, this.tupleFunctions};
        int[] headIndexes = new int[heads.length];
        boolean sortDone = false;
        while (!sortDone) {
            f = null;
            sortDone = true;
            int selected = 0;
            for (int i = 0; i < heads.length; ++i) {
                if (headIndexes[i] >= heads[i].getChildCount()) continue;
                DefaultMutableTreeNode curr = (DefaultMutableTreeNode)heads[i].getChildAt(headIndexes[i]);
                if (f == null) {
                    f = (MdxFunction)curr.getUserObject();
                    selected = i;
                    continue;
                }
                if (((MdxFunction)curr.getUserObject()).getName().compareTo(f.getName()) >= 0) continue;
                f = (MdxFunction)curr.getUserObject();
                selected = i;
            }
            if (f == null) continue;
            sortDone = false;
            this.allFunctions.add(new DefaultMutableTreeNode(f));
            int n = selected;
            headIndexes[n] = headIndexes[n] + 1;
        }
        this.categorized = false;
        this.toggleTree();
    }

    private void toggleTree() {
        this.categorized = !this.categorized;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        root.removeAllChildren();
        if (this.categorized) {
            root.add(this.nonMdxFunctions);
            root.add(this.arrayFunctions);
            root.add(this.dimensionFunctions);
            root.add(this.hierarchyFunctions);
            root.add(this.levelFunctions);
            root.add(this.memberFunctions);
            root.add(this.numericFunctions);
            root.add(this.setFunctions);
            root.add(this.stringFunctions);
            root.add(this.tupleFunctions);
            root.setUserObject("Mdx Functions (categorized)");
        } else {
            root.add(this.nonMdxFunctions);
            root.add(this.allFunctions);
            this.tree.expandPath(new TreePath(this.allFunctions.getPath()));
            root.setUserObject("Mdx Functions (alphabetical)");
        }
        this.tree.updateUI();
        this.tree.repaint();
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Testing FunctionTree...");
        MdxFunctionTree dst = new MdxFunctionTree();
        frame.setContentPane(dst);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    private class MdxFunctionTreeRenderer
    extends DefaultTreeCellRenderer {
        public MdxFunctionTreeRenderer() {
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (((DefaultMutableTreeNode)value).getUserObject() instanceof MdxFunction) {
                MdxFunction curr = (MdxFunction)((DefaultMutableTreeNode)value).getUserObject();
                this.setText(curr.toString());
                this.setIcon(curr.getIcon());
                this.setToolTipText(curr.getToolTip());
            } else {
                String s = ((DefaultMutableTreeNode)value).getUserObject().toString();
                this.setText(s);
                this.setIcon(null);
                this.setToolTipText(s);
            }
            return this;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int selRow = MdxFunctionTree.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = MdxFunctionTree.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && ((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject() instanceof MdxFunction) {
                    MdxFunction mdxf = (MdxFunction)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
                    if (MdxFunctionTree.this.parent != null && MdxFunctionTree.this.parent instanceof MdxEditor) {
                        ((MdxEditor)MdxFunctionTree.this.parent).addTextToCurrentPosition(mdxf.getSyntax());
                    }
                } else if (selRow != -1 && selPath.getLastPathComponent() == MdxFunctionTree.this.tree.getModel().getRoot()) {
                    MdxFunctionTree.this.toggleTree();
                }
            }
        }
    }
}

