/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.dnd;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import javax.swing.JPanel;

public class DragElement
extends JPanel {
    private Point location = new Point(0, 0);
    String dragLabel;
    private int width;
    private int height;
    private float alpha = 0.7f;
    private boolean visible = true;
    private Rectangle visibleRect = null;

    public DragElement() {
        this.setOpaque(false);
    }

    public void showString(boolean v) {
        this.visible = v;
    }

    public void setImage(String text, int h, int w) {
        this.dragLabel = text;
        this.width = w;
        this.height = h;
    }

    public void setPoint(Point location) {
        this.location = location;
    }

    public Point getPoint() {
        return this.location;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.dragLabel == null || !this.isVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.visibleRect != null) {
            g2.setClip(this.visibleRect);
        }
        if (this.visibleRect != null) {
            Area clip = new Area(this.visibleRect);
            g2.setClip(clip);
        }
        if (this.visible) {
            g2.drawString(this.dragLabel, (int)this.location.getX(), (int)this.location.getY());
        } else {
            g2.drawString("", (int)this.location.getX(), (int)this.location.getY());
        }
    }
}

