/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.nodes;

import java.util.ArrayList;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rex.graphics.dimensiontree.elements.DimensionElement;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.dimensiontree.elements.LevelElement;
import rex.graphics.dimensiontree.elements.MeasureElement;
import rex.graphics.dimensiontree.elements.MemberElement;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTPopUpActions;
import rex.graphics.mdxeditor.mdxbuilder.nodes.RightClickFunction;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MBTMembersNode
extends DefaultMBTNode
implements LanguageChangedListener {
    private String membersMdxExpression;
    private String currentFunction;
    private String dimensionUniqueName;
    private Stack currType;
    private static ArrayList rcFunctions = new ArrayList();
    private static RightClickFunction f = new RightClickFunction("AllMembers", "set", LevelElement.class.getName());
    static ImageIcon icon;

    public MBTMembersNode(DimensionTreeElement dte) {
        I18n.addOnLanguageChangedListener(this);
        this.membersMdxExpression = dte.getUniqueName();
        this.dimensionUniqueName = dte.getDimensionUniqueName();
        this.currType = new Stack();
        this.currType.push(dte.getClass().getName());
        if (dte instanceof MeasureElement || dte instanceof MemberElement) {
            this.currentFunction = "<<none>>";
        } else {
            this.currentFunction = "Members";
            this.currType.push("set");
        }
    }

    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    @Override
    public String getMdx(String indent) {
        if (this.currentFunction.equals("<<none>>")) {
            return indent + this.membersMdxExpression;
        }
        return indent + this.membersMdxExpression + "." + this.currentFunction;
    }

    @Override
    public String toString() {
        return this.getMdx("");
    }

    @Override
    void setAcceptableFlavorsArray() {
    }

    @Override
    public ImageIcon getIcon() {
        return icon;
    }

    @Override
    public void handleDrop(Object droppedData, DefaultMutableTreeNode containerNode, DefaultTreeModel treeModel) {
    }

    @Override
    public String[] getPopUpActionList() {
        int i;
        int i2;
        ArrayList<String> a = new ArrayList<String>();
        a.add(MBTPopUpActions.REMOVE);
        boolean hasBaseFunctions = false;
        String type = (String)this.currType.elementAt(0);
        for (i2 = 0; i2 < rcFunctions.size(); ++i2) {
            if (!((RightClickFunction)rcFunctions.get(i2)).isApplicableTo(type)) continue;
            hasBaseFunctions = true;
            break;
        }
        if (hasBaseFunctions) {
            a.add(MBTPopUpActions.SEPARATOR);
            a.add(MBTPopUpActions.OPEN_SUBMENU);
            a.add("Change function to:");
            for (i2 = 0; i2 < rcFunctions.size(); ++i2) {
                if (!((RightClickFunction)rcFunctions.get(i2)).isApplicableTo(type)) continue;
                a.add(((RightClickFunction)rcFunctions.get(i2)).toString());
            }
            a.add(MBTPopUpActions.CLOSE_SUBMENU);
        }
        boolean canChain = false;
        type = (String)this.currType.peek();
        for (i = 0; this.currType.size() > 1 && i < rcFunctions.size(); ++i) {
            if (!((RightClickFunction)rcFunctions.get(i)).isApplicableTo(type)) continue;
            canChain = true;
            break;
        }
        if (canChain) {
            a.add(MBTPopUpActions.OPEN_SUBMENU);
            a.add("Chain function to:");
            for (i = 0; i < rcFunctions.size(); ++i) {
                if (!((RightClickFunction)rcFunctions.get(i)).isApplicableTo(type)) continue;
                a.add(this.currentFunction + "." + ((RightClickFunction)rcFunctions.get(i)).toString());
            }
            a.add(MBTPopUpActions.CLOSE_SUBMENU);
        }
        return a.toArray(new String[0]);
    }

    @Override
    public void handlePopUpAction(String action, DefaultMutableTreeNode actionNode, DefaultTreeModel treeModel) {
        if (action.equals(MBTPopUpActions.REMOVE)) {
            super.removeMySelfFromTheParent(actionNode, treeModel);
        } else {
            int i;
            for (i = 0; i < rcFunctions.size(); ++i) {
                if (!((RightClickFunction)rcFunctions.get(i)).toString().equals(action)) continue;
                String baseType = (String)this.currType.elementAt(0);
                this.currType.clear();
                this.currType.push(baseType);
                this.currType.push(((RightClickFunction)rcFunctions.get(i)).getReturnValueType());
                this.currentFunction = ((RightClickFunction)rcFunctions.get(i)).toString();
                return;
            }
            for (i = 0; i < rcFunctions.size(); ++i) {
                if (!action.equals(this.currentFunction + "." + ((RightClickFunction)rcFunctions.get(i)).toString())) continue;
                this.currType.push(((RightClickFunction)rcFunctions.get(i)).getReturnValueType());
                this.currentFunction = this.currentFunction + "." + ((RightClickFunction)rcFunctions.get(i)).toString();
                return;
            }
        }
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.REMOVE, I18n.getString("menu.remove"));
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }

    static {
        f.addType(DimensionElement.class.getName());
        rcFunctions.add(f);
        rcFunctions.add(new RightClickFunction("Children", "set", MemberElement.class.getName()));
        rcFunctions.add(new RightClickFunction("CurrentMember", MemberElement.class.getName(), DimensionElement.class.getName()));
        rcFunctions.add(new RightClickFunction("DataMember", MemberElement.class.getName(), MemberElement.class.getName()));
        rcFunctions.add(new RightClickFunction("DefaultMember", MemberElement.class.getName(), DimensionElement.class.getName()));
        rcFunctions.add(new RightClickFunction("FirstChild", MemberElement.class.getName(), MemberElement.class.getName()));
        rcFunctions.add(new RightClickFunction("FirstSibling", MemberElement.class.getName(), MemberElement.class.getName()));
        rcFunctions.add(new RightClickFunction("LastChild", MemberElement.class.getName(), MemberElement.class.getName()));
        rcFunctions.add(new RightClickFunction("LastSibling", MemberElement.class.getName(), MemberElement.class.getName()));
        f = new RightClickFunction("Members", "set", LevelElement.class.getName());
        f.addType(DimensionElement.class.getName());
        rcFunctions.add(f);
        f = new RightClickFunction("Name", "string", LevelElement.class.getName());
        f.addType(DimensionElement.class.getName());
        f.addType(MemberElement.class.getName());
        rcFunctions.add(f);
        rcFunctions.add(new RightClickFunction("NextMember", MemberElement.class.getName(), MemberElement.class.getName()));
        rcFunctions.add(new RightClickFunction("Parent", MemberElement.class.getName(), MemberElement.class.getName()));
        rcFunctions.add(new RightClickFunction("PrevMember", MemberElement.class.getName(), MemberElement.class.getName()));
        rcFunctions.add(new RightClickFunction("Siblings", "set", MemberElement.class.getName()));
        rcFunctions.add(new RightClickFunction("Value", "value", MemberElement.class.getName()));
        f = new RightClickFunction("<<none>>", "none", MemberElement.class.getName());
        f.addType(DimensionElement.class.getName());
        f.addType(LevelElement.class.getName());
        rcFunctions.add(f);
        icon = S.getAppIcon("MBTMembersNode.gif");
    }
}

