/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.hadoop.hive.connection;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;

public class HiveConnection
implements Connection {
    private Connection connection;
    private String jdbcURL;
    private static final Logger logger = Logger.getLogger(HiveConnection.class);
    private final Pattern urlPattern = Pattern.compile("jdbc:hive://(.+):([0-9]+)/default", 2);

    public HiveConnection(String jdbcURL) throws ClassNotFoundException, JRException {
        this.jdbcURL = jdbcURL;
        Class.forName("org.apache.hadoop.hive.jdbc.HiveDriver");
        this.validateURL();
        this.createConnection();
    }

    private void validateURL() throws JRException {
        Matcher matcher = this.urlPattern.matcher(this.jdbcURL);
        if (!matcher.matches()) {
            throw new JRException("Invalid Hive JDBC url: " + this.jdbcURL);
        }
        String hostName = matcher.group(1);
        String port = matcher.group(2);
        this.validateHostAndPort(hostName, Integer.parseInt(port));
    }

    private void validateHostAndPort(String hostName, Integer port) throws JRException {
        InetSocketAddress inetSocket = null;
        Socket socket = null;
        try {
            socket = new Socket();
            inetSocket = new InetSocketAddress(hostName, (int)port);
            if (inetSocket.isUnresolved()) {
                throw new JRException("Failed connecting to: " + inetSocket);
            }
            socket.connect(inetSocket, 10000);
        }
        catch (Exception ex) {
            throw new JRException((Throwable)ex);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.connection = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection == null;
    }

    private void createConnection() {
        if (this.connection == null) {
            block7: {
                if (this.jdbcURL == null) {
                    logger.error((Object)"Hive JDBC url not defined");
                    return;
                }
                try {
                    this.connection = DriverManager.getConnection(this.jdbcURL, "", "");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (this.connection == null) break block7;
                    try {
                        this.connection.close();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    this.connection = null;
                }
            }
            logger.info((Object)"Hive connection created");
        } else {
            logger.info((Object)"Hive connection reused");
        }
    }

    public String test() {
        if (this.connection != null) {
            return "Connected successfully.";
        }
        return "No connection";
    }

    public Connection getSqlConnection() {
        return this.connection;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public static String getJdbcTypeClass(ResultSetMetaData resultSetMetaData, int index) {
        String className = "java.lang.Object";
        try {
            className = resultSetMetaData.getColumnClassName(index);
            className = HiveConnection.getJRFieldType(className);
        }
        catch (Exception ex) {
            try {
                int type = resultSetMetaData.getColumnType(index);
                switch (type) {
                    case -7: 
                    case -6: {
                        className = "java.lang.Byte";
                        break;
                    }
                    case 5: {
                        className = "java.lang.Short";
                        break;
                    }
                    case 4: {
                        className = "java.lang.Integer";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        className = "java.lang.Double";
                        break;
                    }
                    case 1: 
                    case 12: {
                        className = "java.lang.String";
                        break;
                    }
                    case -5: {
                        className = "java.lang.Long";
                        break;
                    }
                    case 91: {
                        className = "java.util.Date";
                        break;
                    }
                    case 92: {
                        className = "java.sql.Time";
                        break;
                    }
                    case 93: {
                        className = "java.sql.Timestamp";
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return className;
    }

    public static String getJRFieldType(String type) {
        if (type == null) {
            return "java.lang.Object";
        }
        if (type.equals("java.lang.Boolean") || type.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (type.equals("java.lang.Byte") || type.equals("byte")) {
            return "java.lang.Byte";
        }
        if (type.equals("java.lang.Integer") || type.equals("int")) {
            return "java.lang.Integer";
        }
        if (type.equals("java.lang.Long") || type.equals("long")) {
            return "java.lang.Long";
        }
        if (type.equals("java.lang.Double") || type.equals("double")) {
            return "java.lang.Double";
        }
        if (type.equals("java.lang.Float") || type.equals("float")) {
            return "java.lang.Float";
        }
        if (type.equals("java.lang.Short") || type.equals("short")) {
            return "java.lang.Short";
        }
        if (type.startsWith("[")) {
            return "java.lang.Object";
        }
        return type;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }
}

