/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.connection;

import com.jaspersoft.mongodb.connection.MongoDbConnection;
import com.jaspersoft.mongodb.connection.MongoDbConnectionFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class MongoDbConnectionManager {
    private GenericObjectPool<MongoDbConnection> connectionsPool;
    private GenericObjectPool.Config poolConfiguration;
    private MongoDbConnectionFactory connectionFactory;
    private final Logger logger = Logger.getLogger(MongoDbConnectionManager.class);

    public MongoDbConnectionManager() {
        this.connectionFactory = new MongoDbConnectionFactory();
        this.poolConfiguration = new GenericObjectPool.Config();
        this.poolConfiguration.testOnBorrow = true;
        this.poolConfiguration.testWhileIdle = true;
        this.poolConfiguration.whenExhaustedAction = (byte)2;
        this.poolConfiguration.maxActive = 4;
        this.poolConfiguration.maxIdle = 2;
        this.poolConfiguration.minIdle = 1;
    }

    private GenericObjectPool<MongoDbConnection> startConnectionsPool() {
        if (this.connectionsPool == null) {
            this.connectionsPool = new GenericObjectPool((PoolableObjectFactory)this.connectionFactory, this.poolConfiguration);
        }
        return this.connectionsPool;
    }

    public MongoDbConnection borrowConnection() throws Exception {
        if (this.connectionsPool == null) {
            this.startConnectionsPool();
        }
        if (this.connectionsPool == null) {
            this.logger.error((Object)"No connection pool created");
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Current active connections before borrow: " + this.connectionsPool.getNumActive()));
        }
        return (MongoDbConnection)this.connectionsPool.borrowObject();
    }

    public void returnConnection(MongoDbConnection connection) {
        if (this.connectionsPool == null) {
            this.logger.error((Object)"No connection pool created");
            return;
        }
        try {
            this.connectionsPool.returnObject((Object)connection);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Current active connections on return: " + this.connectionsPool.getNumActive()));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    public void shutdown() {
        if (this.connectionsPool != null) {
            try {
                this.connectionsPool.clear();
                this.connectionsPool.close();
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    public void setMaxActive(int maxActive) {
        this.poolConfiguration.maxActive = maxActive;
    }

    public void setMaxIdle(int maxIdle) {
        this.poolConfiguration.maxIdle = maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.poolConfiguration.minIdle = minIdle;
    }

    public void setMongoURI(String mongoURI) {
        this.connectionFactory.setMongoURI(mongoURI);
    }

    public void setUsername(String username) {
        this.connectionFactory.setUsername(username);
    }

    public void setPassword(String password) {
        this.connectionFactory.setPassword(password);
    }
}

