/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import nickyb.sqleonardo.environment.ctrl.content.ContentChanges;
import nickyb.sqleonardo.environment.ctrl.content.TaskRetrieve;

public class ContentModel
implements TableModel {
    public static int MAX_BLOCK_RECORDS = 75;
    private Vector columns = new Vector();
    private Vector rows = new Vector();
    private Hashtable content = new Hashtable();
    private ContentChanges changes = new ContentChanges();
    private long ridcounter = 0L;
    private int block = 1;

    public ContentChanges getChanges() {
        return this.changes;
    }

    public int getBlockCount() {
        return this.getFlatRowCount() / MAX_BLOCK_RECORDS + (this.getFlatRowCount() % MAX_BLOCK_RECORDS == 0 ? 0 : 1);
    }

    public int getBlock() {
        return this.block;
    }

    public void setBlock(int idx) {
        this.block = idx;
    }

    public void addColumn(String text, int type) {
        this.columns.add(new Object[]{text, new Integer(type)});
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Class getColumnClass(int idx) {
        return Object.class;
    }

    public String getColumnName(int idx) {
        return ((Object[])this.columns.elementAt(idx))[0].toString();
    }

    public int getColumnIndex(String name) {
        for (int idx = 0; idx < this.columns.size(); ++idx) {
            if (!this.getColumnName(idx).equals(name)) continue;
            return idx;
        }
        return -1;
    }

    public int getColumnType(int idx) {
        return (Integer)((Object[])this.columns.elementAt(idx))[1];
    }

    public void addRow(Object[] rowdata) {
        this.addRow(rowdata, false);
    }

    public void addRow(Object[] rowdata, boolean newrow) {
        Long rid = new Long(this.ridcounter++);
        this.rows.add(rid);
        this.content.put(rid, rowdata);
        if (newrow) {
            this.changes.setInserted(rid);
        }
    }

    public void deleteRow(int row) {
        Long rid = (Long)this.rows.elementAt(this.toFlatRow(row));
        this.rows.removeElement(rid);
        this.changes.setDeleted(rid);
    }

    public void insertRow(int row) {
        Object[] rowdata = new Object[this.getColumnCount()];
        Long rid = new Long(this.ridcounter++);
        this.rows.insertElementAt(rid, this.toFlatRow(row));
        this.content.put(rid, rowdata);
        this.changes.setInserted(rid);
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public int getRowCount() {
        int count = this.rows.size();
        if (count == 0) {
            return 0;
        }
        return (count -= MAX_BLOCK_RECORDS * (this.block - 1)) > MAX_BLOCK_RECORDS ? MAX_BLOCK_RECORDS : count;
    }

    public Object getValueAt(int row, int col) {
        return this.getFlatValueAt(this.toFlatRow(row), col);
    }

    public boolean isCellChanged(int row, int col) {
        return this.isFlatCellChanged(this.toFlatRow(row), col);
    }

    public void resetValueAt(int row, int col) {
        this.resetFlatValueAt(this.toFlatRow(row), col);
    }

    public void setValueAt(Object aValue, int row, int col) {
        this.setFlatValueAt(aValue, this.toFlatRow(row), col);
    }

    public int getFlatRowCount() {
        return this.rows.size();
    }

    public Object getFlatValueAt(int row, int col) {
        Long rid = (Long)this.rows.elementAt(row);
        Object[] rowdata = this.getValues(rid);
        return rowdata[col] instanceof Object[] ? ((Object[])rowdata[col])[0] : rowdata[col];
    }

    public boolean isFlatCellChanged(int row, int col) {
        Long rid = (Long)this.rows.elementAt(row);
        return this.changes.exists(ContentChanges.INSERT, rid) || this.getValues(rid)[col] instanceof Object[];
    }

    private boolean isFlatRowChanged(int row) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.isFlatCellChanged(row, i)) continue;
            return true;
        }
        return false;
    }

    public void resetFlatValueAt(int row, int col) {
        Long rid = (Long)this.rows.elementAt(row);
        Object[] rowdata = this.getValues(rid);
        if (rowdata[col] instanceof Object[]) {
            this.setFlatValueAt(((Object[])rowdata[col])[1], row, col);
        }
    }

    public void setFlatValueAt(Object aValue, int row, int col) {
        Long rid = (Long)this.rows.elementAt(row);
        Object[] rowdata = this.getValues(rid);
        if (this.changes.exists(ContentChanges.INSERT, rid)) {
            rowdata[col] = aValue;
        } else {
            Object[] cell = new Object[]{aValue, null};
            cell[1] = rowdata[col] instanceof Object[] ? ((Object[])rowdata[col])[1] : rowdata[col];
            if (cell[0] == null && cell[1] == null) {
                rowdata[col] = null;
                cell = null;
            } else if (cell[0] != null && cell[1] != null) {
                if (cell[0].toString().equals(cell[1].toString())) {
                    rowdata[col] = aValue;
                    cell = null;
                } else {
                    cell[0] = aValue;
                }
            } else {
                cell[0] = aValue;
            }
            if (cell != null) {
                rowdata[col] = cell;
                this.changes.setUpdated(rid);
            } else if (!this.isFlatRowChanged(row)) {
                this.changes.aborted(rid);
            }
        }
    }

    Object[] getValues(int row) {
        Long rid = (Long)this.rows.elementAt(row);
        return this.getValues(rid);
    }

    Object[] getValues(Long rid) {
        return (Object[])this.content.get(rid);
    }

    int toFlatRow(int row) {
        int gap = (this.block - 1) * MAX_BLOCK_RECORDS;
        return gap < 0 ? row : row + gap;
    }

    private int compare(int col, int row1, int row2, short type) {
        Long rid1 = (Long)this.rows.elementAt(row1);
        Long rid2 = (Long)this.rows.elementAt(row2);
        Object[] rowdata1 = this.getValues(rid1);
        Object[] rowdata2 = this.getValues(rid2);
        Object value1 = rowdata1[col] instanceof Object[] ? ((Object[])rowdata1[col])[0] : rowdata1[col];
        Object value2 = rowdata2[col] instanceof Object[] ? ((Object[])rowdata2[col])[0] : rowdata2[col];
        int cmp = 0;
        if (value1 != null && value2 != null) {
            if (TaskRetrieve.isNumberType(this.getColumnType(col))) {
                if (Float.valueOf(value1.toString()).floatValue() > Float.valueOf(value2.toString()).floatValue()) {
                    cmp = 1;
                } else if (Float.valueOf(value1.toString()).floatValue() < Float.valueOf(value2.toString()).floatValue()) {
                    cmp = -1;
                }
            } else {
                cmp = value1.toString().toLowerCase().compareTo(value2.toString().toLowerCase());
            }
        } else if (value1 != null) {
            cmp = 1;
        } else if (value2 != null) {
            cmp = -1;
        }
        return type == 0 ? cmp : cmp * -1;
    }

    private void swap(int i, int j) {
        Long rid = (Long)this.rows.elementAt(i);
        this.rows.setElementAt(this.rows.elementAt(j), i);
        this.rows.setElementAt(rid, j);
    }

    private void sort(int col, int first, int last, short type) {
        int lower = first + 1;
        int upper = last;
        this.swap(first, (first + last) / 2);
        while (lower <= upper) {
            while (this.compare(col, lower, first, type) < 0) {
                ++lower;
            }
            while (this.compare(col, first, upper, type) < 0) {
                --upper;
            }
            if (lower < upper) {
                this.swap(lower++, upper--);
                continue;
            }
            ++lower;
        }
        this.swap(upper, first);
        if (first < upper - 1) {
            this.sort(col, first, upper - 1, type);
        }
        if (upper + 1 < last) {
            this.sort(col, upper + 1, last, type);
        }
    }

    public void sort(int col, short type) {
        if (this.getFlatRowCount() < 2) {
            return;
        }
        int max = 0;
        for (int i = 1; i < this.getFlatRowCount(); ++i) {
            if (this.compare(col, max, i, type) >= 0) continue;
            max = i;
        }
        this.swap(this.getFlatRowCount() - 1, max);
        this.sort(col, 0, this.getFlatRowCount() - 2, type);
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }
}

