/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.guards;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.guards.GuardedSectionImpl;
import org.netbeans.modules.editor.guards.GuardedSectionsImpl;
import org.netbeans.modules.editor.guards.PositionBounds;

public final class SimpleSectionImpl
extends GuardedSectionImpl {
    private PositionBounds bounds;

    SimpleSectionImpl(String string, PositionBounds positionBounds, GuardedSectionsImpl guardedSectionsImpl) {
        super(string, guardedSectionsImpl);
        this.bounds = positionBounds;
    }

    public void setText(String string) {
        this.setText(this.bounds, string, true);
    }

    void markGuarded(StyledDocument styledDocument) {
        this.markGuarded(styledDocument, this.bounds, true);
    }

    void unmarkGuarded(StyledDocument styledDocument) {
        this.markGuarded(styledDocument, this.bounds, false);
    }

    public Position getCaretPosition() {
        return this.bounds.getBegin();
    }

    public String getText() {
        String string = "";
        try {
            string = this.bounds.getText();
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger("guards").log(Level.ALL, null, badLocationException);
        }
        return string;
    }

    public Position getEndPosition() {
        return this.bounds.getEnd();
    }

    public boolean contains(Position position, boolean bl) {
        return this.bounds.getBegin().getOffset() <= position.getOffset() && this.bounds.getEnd().getOffset() >= position.getOffset();
    }

    public Position getStartPosition() {
        return this.bounds.getBegin();
    }

    public void resolvePositions() throws BadLocationException {
        this.bounds.resolvePositions();
    }
}

