/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.hadoop.hive.jdbc.HiveDriver;
import org.apache.hadoop.hive.jdbc.HiveMetaDataResultSet;
import org.apache.hadoop.hive.jdbc.JdbcColumn;
import org.apache.hadoop.hive.jdbc.JdbcTable;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.service.HiveInterface;
import org.apache.thrift.TException;

public class HiveDatabaseMetaData
implements DatabaseMetaData {
    private final HiveInterface client;
    private static final String CATALOG_SEPARATOR = ".";
    private static final char SEARCH_STRING_ESCAPE = '\\';
    private static final int maxColumnNameLength = 128;

    public HiveDatabaseMetaData(HiveInterface client) {
        this.client = client;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return CATALOG_SEPARATOR;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            ArrayList<String> catalogs = new ArrayList<String>();
            catalogs.add("default");
            return new HiveMetaDataResultSet<String>(Arrays.asList("TABLE_CAT"), Arrays.asList("STRING"), catalogs){
                private int cnt;
                {
                    this.cnt = 0;
                }

                @Override
                public boolean next() throws SQLException {
                    if (this.cnt < this.data.size()) {
                        ArrayList a = new ArrayList(1);
                        a.add(this.data.get(this.cnt));
                        this.row = a;
                        ++this.cnt;
                        return true;
                    }
                    return false;
                }
            };
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    private String convertPattern(String pattern) {
        if (pattern == null) {
            return ".*";
        }
        StringBuilder result = new StringBuilder(pattern.length());
        boolean escaped = false;
        int len = pattern.length();
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (escaped) {
                if (c != '\\') {
                    escaped = false;
                }
                result.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '%') {
                result.append(".*");
                continue;
            }
            if (c == '_') {
                result.append('.');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<JdbcColumn> columns = new ArrayList<JdbcColumn>();
        try {
            if (catalog == null) {
                catalog = "default";
            }
            String regtableNamePattern = this.convertPattern(tableNamePattern);
            String regcolumnNamePattern = this.convertPattern(columnNamePattern);
            List tables = this.client.get_tables(catalog, "*");
            for (String table : tables) {
                if (!table.matches(regtableNamePattern)) continue;
                List fields = this.client.get_schema(catalog, table);
                int ordinalPos = 1;
                for (FieldSchema field : fields) {
                    if (!field.getName().matches(regcolumnNamePattern)) continue;
                    columns.add(new JdbcColumn(field.getName(), table, catalog, field.getType(), field.getComment(), ordinalPos));
                    ++ordinalPos;
                }
            }
            Collections.sort(columns, new GetColumnsComparator());
            return new HiveMetaDataResultSet<JdbcColumn>(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATLOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE"), Arrays.asList("STRING", "STRING", "STRING", "STRING", "INT", "STRING", "INT", "INT", "INT", "INT", "INT", "STRING", "STRING", "INT", "INT", "INT", "INT", "STRING", "STRING", "STRING", "STRING", "INT"), columns){
                private int cnt;
                {
                    this.cnt = 0;
                }

                @Override
                public boolean next() throws SQLException {
                    if (this.cnt < this.data.size()) {
                        ArrayList<Object> a = new ArrayList<Object>(20);
                        JdbcColumn column = (JdbcColumn)this.data.get(this.cnt);
                        a.add(column.getTableCatalog());
                        a.add(null);
                        a.add(column.getTableName());
                        a.add(column.getColumnName());
                        a.add(column.getSqlType());
                        a.add(column.getType());
                        a.add(column.getColumnSize());
                        a.add(null);
                        a.add(column.getDecimalDigits());
                        a.add(column.getNumPrecRadix());
                        a.add(1);
                        a.add(column.getComment());
                        a.add(null);
                        a.add(null);
                        a.add(null);
                        a.add(null);
                        a.add(column.getOrdinalPos());
                        a.add("YES");
                        a.add(null);
                        a.add(null);
                        a.add(null);
                        a.add(null);
                        this.row = a;
                        ++this.cnt;
                        return true;
                    }
                    return false;
                }
            };
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Hive";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            return this.client.getVersion();
        }
        catch (TException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return HiveDriver.getMajorDriverVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return HiveDriver.getMinorDriverVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return HiveDriver.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_TITLE);
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return HiveDriver.fetchManifestAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getFunctionColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getFunctions(String arg0, String arg1, String arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxConnections() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxStatements() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return null;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return new HiveMetaDataResultSet(Arrays.asList("TABLE_SCHEM", "TABLE_CATALOG"), Arrays.asList("STRING", "STRING"), null){

            @Override
            public boolean next() throws SQLException {
                return false;
            }
        };
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return String.valueOf('\\');
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        TableType[] tt = TableType.values();
        HiveMetaDataResultSet<TableType> result = new HiveMetaDataResultSet<TableType>(Arrays.asList("TABLE_TYPE"), Arrays.asList("STRING"), new ArrayList<TableType>(Arrays.asList(tt))){
            private int cnt;
            {
                this.cnt = 0;
            }

            @Override
            public boolean next() throws SQLException {
                if (this.cnt < this.data.size()) {
                    ArrayList<String> a = new ArrayList<String>(1);
                    a.add(HiveDatabaseMetaData.toJdbcTableType(((TableType)this.data.get(this.cnt)).name()));
                    this.row = a;
                    ++this.cnt;
                    return true;
                }
                return false;
            }
        };
        return result;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ArrayList<JdbcTable> resultTables = new ArrayList<JdbcTable>();
        String resultCatalog = catalog == null ? "default" : catalog;
        String regtableNamePattern = this.convertPattern(tableNamePattern);
        try {
            List tablesstr = this.client.get_tables(resultCatalog, "*");
            block2: for (String tablestr : tablesstr) {
                if (!tablestr.matches(regtableNamePattern)) continue;
                Table tbl = this.client.get_table(resultCatalog, tablestr);
                if (types == null) {
                    resultTables.add(new JdbcTable(resultCatalog, tbl.getTableName(), tbl.getTableType(), (String)tbl.getParameters().get("comment")));
                    continue;
                }
                String tableType = HiveDatabaseMetaData.toJdbcTableType(tbl.getTableType());
                for (String type : types) {
                    if (!type.equalsIgnoreCase(tableType)) continue;
                    resultTables.add(new JdbcTable(resultCatalog, tbl.getTableName(), tbl.getTableType(), (String)tbl.getParameters().get("comment")));
                    continue block2;
                }
            }
            Collections.sort(resultTables, new GetTablesComparator());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        HiveMetaDataResultSet<JdbcTable> result = new HiveMetaDataResultSet<JdbcTable>(Arrays.asList("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"), Arrays.asList("STRING", "STRING", "STRING", "STRING", "STRING"), resultTables){
            private int cnt;
            {
                this.cnt = 0;
            }

            @Override
            public boolean next() throws SQLException {
                if (this.cnt < this.data.size()) {
                    ArrayList<String> a = new ArrayList<String>(5);
                    JdbcTable table = (JdbcTable)this.data.get(this.cnt);
                    a.add(table.getTableCatalog());
                    a.add(null);
                    a.add(table.getTableName());
                    try {
                        a.add(table.getSqlTableType());
                    }
                    catch (Exception e) {
                        throw new SQLException(e);
                    }
                    a.add(table.getComment());
                    this.row = a;
                    ++this.cnt;
                    return true;
                }
                return false;
            }
        };
        return result;
    }

    public static String toJdbcTableType(String hivetabletype) {
        if (hivetabletype == null) {
            return null;
        }
        if (hivetabletype.equals(TableType.MANAGED_TABLE.toString())) {
            return "TABLE";
        }
        if (hivetabletype.equals(TableType.VIRTUAL_VIEW.toString())) {
            return "VIEW";
        }
        if (hivetabletype.equals(TableType.EXTERNAL_TABLE.toString())) {
            return "EXTERNAL TABLE";
        }
        return hivetabletype;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return new HiveMetaDataResultSet(Arrays.asList("TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE"), Arrays.asList("STRING", "STRING", "STRING", "STRING", "INT", "STRING", "INT"), null){

            @Override
            public boolean next() throws SQLException {
                return false;
            }
        };
    }

    @Override
    public String getURL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getUserName() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    public static void main(String[] args) throws SQLException {
        HiveDatabaseMetaData meta = new HiveDatabaseMetaData(null);
        System.out.println("DriverName: " + meta.getDriverName());
        System.out.println("DriverVersion: " + meta.getDriverVersion());
    }

    private class GetTablesComparator
    implements Comparator<JdbcTable> {
        private GetTablesComparator() {
        }

        @Override
        public int compare(JdbcTable o1, JdbcTable o2) {
            int compareType = o1.getType().compareTo(o2.getType());
            if (compareType == 0) {
                return o1.getTableName().compareTo(o2.getTableName());
            }
            return compareType;
        }
    }

    private class GetColumnsComparator
    implements Comparator<JdbcColumn> {
        private GetColumnsComparator() {
        }

        @Override
        public int compare(JdbcColumn o1, JdbcColumn o2) {
            int compareName = o1.getTableName().compareTo(o2.getTableName());
            if (compareName == 0) {
                if (o1.getOrdinalPos() > o2.getOrdinalPos()) {
                    return 1;
                }
                if (o1.getOrdinalPos() < o2.getOrdinalPos()) {
                    return -1;
                }
                return 0;
            }
            return compareName;
        }
    }
}

