/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.transformer.tool;

import com.jaspersoft.ireport.addons.transformer.Transformer;
import com.jaspersoft.ireport.addons.transformer.tool.FileEntry;
import com.jaspersoft.ireport.addons.transformer.tool.TransformationFrame;
import com.jaspersoft.ireport.designer.IRURLClassLoader;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriterHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class CompileThread
implements Runnable {
    private TransformationFrame massiveCompilerFrame = null;
    private boolean stop = false;
    private Thread thread = null;
    ReportClassLoader reportClassLoader = null;
    private Transformer transformer = null;
    private boolean compileSelectedOnly = false;

    public CompileThread(TransformationFrame mcf) {
        this.massiveCompilerFrame = mcf;
        this.thread = new Thread(this);
    }

    public void stop() {
        this.stop = true;
    }

    public void start() {
        this.thread.start();
    }

    public void run() {
        if (this.massiveCompilerFrame == null) {
            return;
        }
        final DefaultTableModel dtm = (DefaultTableModel)this.massiveCompilerFrame.getFileTable().getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            final int index = i;
            final FileEntry fe = (FileEntry)dtm.getValueAt(i, 0);
            if (this.isCompileSelectedOnly() && !this.massiveCompilerFrame.getFileTable().isRowSelected(i)) continue;
            String srcFileName = "";
            try {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            try {
                                fe.setStatus(5);
                                dtm.setValueAt(fe, index, 0);
                                dtm.setValueAt(fe.getFile().getCanonicalPath(), index, 1);
                                dtm.setValueAt(fe.decodeStatus(fe.getStatus()), index, 2);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    // empty catch block
                }
                srcFileName = fe.getFile().getCanonicalPath();
                try {
                    IRURLClassLoader cl = new IRURLClassLoader(new URL[]{fe.getFile().toURI().toURL()}, IReportManager.getReportClassLoader());
                    Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                JasperDesign jasperDesign = this.getTransformer().transform(srcFileName);
                if (jasperDesign != null) {
                    CompileThread.writeReport(jasperDesign, new File(srcFileName));
                }
                fe.setStatus(2);
            }
            catch (Exception ex) {
                fe.setStatus(3);
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                fe.setMessage(sw.getBuffer().toString());
                fe.setShortErrorMessage(ex.getMessage());
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            dtm.setValueAt(fe, index, 0);
                            dtm.setValueAt(fe.getFile().getCanonicalPath(), index, 1);
                            dtm.setValueAt(fe.decodeStatus(fe.getStatus()), index, 2);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    CompileThread.this.massiveCompilerFrame.getFileTable().updateUI();
                    CompileThread.this.massiveCompilerFrame.finishedCompiling();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isCompileSelectedOnly() {
        return this.compileSelectedOnly;
    }

    public void setCompileSelectedOnly(boolean compileSelectedOnly) {
        this.compileSelectedOnly = compileSelectedOnly;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public static void writeReport(JasperDesign jd, File outputFile) throws Exception {
        String compatibility = IReportManager.getPreferences().get("compatibility", "");
        String content = "";
        content = compatibility.length() == 0 ? JRXmlWriter.writeReport((JRReport)jd, (String)"UTF-8") : JRXmlWriterHelper.writeReport((JRReport)jd, (String)"UTF-8", (String)compatibility);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
        out.write(content);
        ((Writer)out).close();
    }
}

