/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataAccessor;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;
import org.netbeans.modules.db.metadata.model.spi.CatalogImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCCatalog
extends CatalogImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCCatalog.class.getName());
    protected final JDBCMetadata jdbcMetadata;
    protected final String name;
    protected final boolean _default;
    protected final String defaultSchemaName;
    protected Schema defaultSchema;
    protected Schema syntheticSchema;
    protected Map<String, Schema> schemas;

    public JDBCCatalog(JDBCMetadata jDBCMetadata, String string, boolean bl, String string2) {
        assert (string2 == null || bl);
        this.jdbcMetadata = jDBCMetadata;
        this.name = string;
        this._default = bl;
        this.defaultSchemaName = string2;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean isDefault() {
        return this._default;
    }

    @Override
    public final Schema getDefaultSchema() {
        this.initSchemas();
        return this.defaultSchema;
    }

    @Override
    public final Schema getSyntheticSchema() {
        this.initSchemas();
        return this.syntheticSchema;
    }

    @Override
    public final Collection<Schema> getSchemas() {
        return this.initSchemas().values();
    }

    @Override
    public final Schema getSchema(String string) {
        return MetadataUtilities.find(string, this.initSchemas());
    }

    public String toString() {
        return "JDBCCatalog[name='" + this.name + "',default=" + this._default + "]";
    }

    protected JDBCSchema createJDBCSchema(String string, boolean bl, boolean bl2) {
        return new JDBCSchema(this, string, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSchemas() {
        LinkedHashMap<String, Schema> linkedHashMap = new LinkedHashMap<String, Schema>();
        try {
            ResultSet resultSet = this.jdbcMetadata.getDmd().getSchemas();
            int n = resultSet.getMetaData().getColumnCount();
            if (n < 2) {
                LOGGER.fine("DatabaseMetaData.getSchemas() not JDBC 3.0-compliant");
            }
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString("TABLE_SCHEM");
                    String string2 = n > 1 ? resultSet.getString("TABLE_CATALOG") : this.name;
                    LOGGER.log(Level.FINE, "Read schema ''{0}'' in catalog ''{1}''", new Object[]{string, string2});
                    if (!MetadataUtilities.equals(string2, this.name)) continue;
                    if (this.defaultSchemaName != null && MetadataUtilities.equals(string, this.defaultSchemaName)) {
                        this.defaultSchema = this.createJDBCSchema(this.defaultSchemaName, true, false).getSchema();
                        linkedHashMap.put(this.defaultSchema.getName(), this.defaultSchema);
                        LOGGER.log(Level.FINE, "Created default schema {0}", this.defaultSchema);
                        continue;
                    }
                    Schema schema = this.createJDBCSchema(string, false, false).getSchema();
                    linkedHashMap.put(string, schema);
                    LOGGER.log(Level.FINE, "Created schema {0}", schema);
                }
            }
            finally {
                resultSet.close();
            }
            if (linkedHashMap.isEmpty() && !this.jdbcMetadata.getDmd().supportsSchemasInTableDefinitions()) {
                this.syntheticSchema = this.createJDBCSchema(null, this._default, true).getSchema();
                if (this._default) {
                    this.defaultSchema = this.syntheticSchema;
                }
                LOGGER.log(Level.FINE, "Created synthetic schema {0}", this.syntheticSchema);
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        this.schemas = Collections.unmodifiableMap(linkedHashMap);
    }

    private Map<String, Schema> initSchemas() {
        if (this.schemas != null) {
            return this.schemas;
        }
        LOGGER.log(Level.FINE, "Initializing schemas in {0}", this);
        this.createSchemas();
        return this.schemas;
    }

    public final void refreshTable(String string) {
        if (this.defaultSchema != null) {
            ((JDBCSchema)MetadataAccessor.getDefault().getSchemaImpl(this.defaultSchema)).refreshTable(string);
        }
    }

    public final JDBCMetadata getJDBCMetadata() {
        return this.jdbcMetadata;
    }
}

