/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.AbstractReference;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamedComponentReference<T extends NamedReferenceable>
extends AbstractReference<T>
implements NamedComponentReference<T> {
    protected String prefix;
    protected String localName;
    protected QName qname;

    public AbstractNamedComponentReference(T t, Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent) {
        super(t, clazz, abstractDocumentComponent);
    }

    public AbstractNamedComponentReference(Class<T> clazz, AbstractDocumentComponent abstractDocumentComponent, String string) {
        super(clazz, abstractDocumentComponent, string);
        this.initReferenceString(string);
    }

    @Override
    public boolean references(T t) {
        return t.getName() != null && t.getName().equals(this.getLocalName()) && !this.isBroken() && this.get() == t;
    }

    @Override
    public synchronized String getRefString() {
        if (this.refString == null) {
            NamedReferenceable namedReferenceable = (NamedReferenceable)super.getReferenced();
            assert (namedReferenceable != null);
            String string = this.getEffectiveNamespace();
            this.prefix = this.getParent().lookupPrefix(string);
            if (string != null && this.prefix == null && namedReferenceable instanceof AbstractDocumentComponent) {
                AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)((Object)namedReferenceable);
                this.prefix = abstractDocumentComponent.lookupPrefix(string);
                if (this.prefix != null) {
                    this.getParent().addPrefix(this.prefix, string);
                }
            }
            this.localName = ((NamedReferenceable)super.getReferenced()).getName();
            this.refString = this.prefix == null || this.prefix.length() == 0 ? this.localName : this.prefix + ":" + this.localName;
        }
        return this.refString;
    }

    private void initReferenceString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Reference string null");
        }
        this.refString = string;
        String[] stringArray = this.refString.split(":");
        if (stringArray.length == 2) {
            this.prefix = stringArray[0];
            this.localName = stringArray[1];
        } else {
            this.prefix = null;
            this.localName = stringArray[0];
        }
    }

    protected String getPrefix() {
        this.getRefString();
        return this.prefix;
    }

    protected String getLocalName() {
        this.getRefString();
        return this.localName;
    }

    @Override
    protected T getReferenced() {
        if (super.getReferenced() == null) {
            this.checkParentPartOfModel();
        } else {
            if (super.getParent().getModel() == null) {
                throw new IllegalStateException("Referencing component has been removed from model.");
            }
            if (((NamedReferenceable)super.getReferenced()).getModel() == null) {
                throw new IllegalStateException("Referenced component has been removed from model.");
            }
        }
        return (T)((NamedReferenceable)super.getReferenced());
    }

    @Override
    public synchronized QName getQName() {
        this.checkParentNotRemovedFromModel();
        if (this.qname == null) {
            if (super.getReferenced() == null) {
                this.qname = this.calculateQNameLocally();
            }
            if (this.qname == null && !this.isBroken()) {
                this.qname = new QName(this.getEffectiveNamespace(), ((NamedReferenceable)this.get()).getName());
            }
            if (this.qname == null) {
                return new QName("");
            }
        }
        return this.qname;
    }

    @Override
    protected AbstractDocumentComponent getParent() {
        return (AbstractDocumentComponent)super.getParent();
    }

    protected void checkParentPartOfModel() {
        if (!this.getParent().isInDocumentModel()) {
            throw new IllegalStateException("Referencing component is not part of model.");
        }
    }

    protected void checkParentNotRemovedFromModel() {
        if (this.getParent().getModel() == null) {
            throw new IllegalStateException("Referencing component has been removed from model.");
        }
    }

    protected QName calculateQNameLocally() {
        String string;
        assert (this.localName != null);
        String string2 = null;
        string2 = this.getParent().lookupNamespaceURI(this.prefix);
        if (string2 == null && (string = this.getParent().lookupPrefix(this.prefix)) != null) {
            string2 = this.prefix = string;
        }
        if (this.prefix == null) {
            return new QName(string2, this.localName);
        }
        return new QName(string2, this.localName, this.prefix);
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object != null && this.getClass().equals(object.getClass()) && this.getParent().equals(((AbstractNamedComponentReference)object).getParent()) && this.getQName().equals(((AbstractNamedComponentReference)object).getQName());
    }

    @Override
    public int hashCode() {
        return this.getParent().hashCode();
    }

    public synchronized void refresh() {
        this.getRefString();
        this.setReferenced(null);
    }
}

