/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Stat;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;

public class TableScanOperator
extends Operator<TableScanDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient JobConf jc;
    private transient Configuration hconf;
    private transient String partitionSpecs;
    private transient boolean inputFileChanged = false;
    private TableDesc tableDesc;
    private transient Stat currentStat;
    private transient Map<String, Stat> stats;
    ArrayList<Integer> neededColumnIDs;

    public TableDesc getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(TableDesc tableDesc) {
        this.tableDesc = tableDesc;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (this.conf != null && ((TableScanDesc)this.conf).isGatherStats()) {
            this.gatherStats(row);
        }
        this.forward(row, this.inputObjInspectors[tag]);
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        this.inputFileChanged = true;
    }

    private void gatherStats(Object row) {
        if (this.currentStat == null || this.inputFileChanged) {
            this.inputFileChanged = false;
            if (((TableScanDesc)this.conf).getPartColumns() == null || ((TableScanDesc)this.conf).getPartColumns().size() == 0) {
                this.partitionSpecs = "";
            } else {
                assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
                ArrayList<Object> writable = new ArrayList<Object>(((TableScanDesc)this.conf).getPartColumns().size());
                ArrayList<String> values = new ArrayList<String>(((TableScanDesc)this.conf).getPartColumns().size());
                int dpStartCol = 0;
                StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
                for (StructField structField : soi.getAllStructFieldRefs()) {
                    String fn = structField.getFieldName();
                    if (((TableScanDesc)this.conf).getPartColumns().contains(fn)) break;
                    ++dpStartCol;
                }
                ObjectInspectorUtils.partialCopyToStandardObject(writable, row, dpStartCol, ((TableScanDesc)this.conf).getPartColumns().size(), (StructObjectInspector)this.inputObjInspectors[0], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                for (StructField structField : writable) {
                    assert (structField != null && structField.toString().length() > 0);
                    values.add(structField.toString());
                }
                this.partitionSpecs = FileUtils.makePartName(((TableScanDesc)this.conf).getPartColumns(), values);
                this.LOG.info((Object)("Stats Gathering found a new partition spec = " + this.partitionSpecs));
            }
            int uSizeColumn = -1;
            StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
            for (int i = 0; i < soi.getAllStructFieldRefs().size(); ++i) {
                if (!soi.getAllStructFieldRefs().get(i).getFieldName().equals(VirtualColumn.RAWDATASIZE.getName().toLowerCase())) continue;
                uSizeColumn = i;
                break;
            }
            this.currentStat = this.stats.get(this.partitionSpecs);
            if (this.currentStat == null) {
                this.currentStat = new Stat();
                this.currentStat.setBookkeepingInfo("rawDataSize", uSizeColumn);
                this.stats.put(this.partitionSpecs, this.currentStat);
            }
        }
        this.currentStat.addToStat("numRows", 1L);
        int rdSizeColumn = this.currentStat.getBookkeepingInfo("rawDataSize");
        if (rdSizeColumn != -1) {
            ArrayList<Object> rdSize = new ArrayList<Object>(1);
            ObjectInspectorUtils.partialCopyToStandardObject(rdSize, row, rdSizeColumn, 1, (StructObjectInspector)this.inputObjInspectors[0], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            this.currentStat.addToStat("rawDataSize", ((LongWritable)rdSize.get(0)).get());
        }
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.initializeChildren(hconf);
        this.inputFileChanged = false;
        if (this.conf == null) {
            return;
        }
        if (!((TableScanDesc)this.conf).isGatherStats()) {
            return;
        }
        this.hconf = hconf;
        this.jc = hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf, ExecDriver.class);
        this.currentStat = null;
        this.stats = new HashMap<String, Stat>();
        this.partitionSpecs = null;
        if (((TableScanDesc)this.conf).getPartColumns() == null || ((TableScanDesc)this.conf).getPartColumns().size() == 0) {
            return;
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.conf != null && ((TableScanDesc)this.conf).isGatherStats() && this.stats.size() != 0) {
            this.publishStats();
        }
    }

    @Override
    public String getName() {
        return "TS";
    }

    public void setNeededColumnIDs(ArrayList<Integer> orign_columns) {
        this.neededColumnIDs = orign_columns;
    }

    public ArrayList<Integer> getNeededColumnIDs() {
        return this.neededColumnIDs;
    }

    @Override
    public OperatorType getType() {
        return OperatorType.TABLESCAN;
    }

    private void publishStats() {
        StatsPublisher statsPublisher = Utilities.getStatsPublisher(this.jc);
        if (!statsPublisher.connect((Configuration)this.jc)) {
            this.LOG.info((Object)"StatsPublishing error: cannot connect to database.");
            return;
        }
        String taskID = Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf));
        HashMap<String, String> statsToPublish = new HashMap<String, String>();
        for (String pspecs : this.stats.keySet()) {
            statsToPublish.clear();
            String key = pspecs.isEmpty() ? ((TableScanDesc)this.conf).getStatsAggPrefix() + taskID : ((TableScanDesc)this.conf).getStatsAggPrefix() + pspecs + "/" + taskID;
            for (String statType : this.stats.get(pspecs).getStoredStats()) {
                statsToPublish.put(statType, Long.toString(this.stats.get(pspecs).getStat(statType)));
            }
            statsPublisher.publishStat(key, statsToPublish);
            this.LOG.info((Object)("publishing : " + key + " : " + ((Object)statsToPublish).toString()));
        }
        statsPublisher.closeConnection();
    }
}

