/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.util.ReflectionUtils;

public final class StatsFactory {
    private static final Log LOG = LogFactory.getLog((String)StatsFactory.class.getName());
    private static Class<? extends Serializable> publisherImplementation;
    private static Class<? extends Serializable> aggregatorImplementation;
    private static Configuration jobConf;

    public static boolean setImplementation(String configurationParam, Configuration conf) {
        ClassLoader classLoader = JavaUtils.getClassLoader();
        if (configurationParam.equals("hbase")) {
            try {
                publisherImplementation = Class.forName("org.apache.hadoop.hive.hbase.HBaseStatsPublisher", true, classLoader);
                aggregatorImplementation = Class.forName("org.apache.hadoop.hive.hbase.HBaseStatsAggregator", true, classLoader);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"HBase Publisher/Aggregator classes cannot be loaded.", (Throwable)e);
                return false;
            }
        }
        if (configurationParam.contains("jdbc")) {
            try {
                publisherImplementation = Class.forName("org.apache.hadoop.hive.ql.stats.jdbc.JDBCStatsPublisher", true, classLoader);
                aggregatorImplementation = Class.forName("org.apache.hadoop.hive.ql.stats.jdbc.JDBCStatsAggregator", true, classLoader);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"JDBC Publisher/Aggregator classes cannot be loaded.", (Throwable)e);
                return false;
            }
        }
        String defPublisher = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_STATS_DEFAULT_PUBLISHER);
        String defAggregator = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_STATS_DEFAULT_AGGREGATOR);
        if (defPublisher == null || defAggregator == null) {
            return false;
        }
        try {
            publisherImplementation = Class.forName(defPublisher, true, classLoader);
            aggregatorImplementation = Class.forName(defAggregator, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"JDBC Publisher/Aggregator classes cannot be loaded.", (Throwable)e);
            return false;
        }
        jobConf = conf;
        return true;
    }

    public static StatsPublisher getStatsPublisher() {
        return (StatsPublisher)ReflectionUtils.newInstance(publisherImplementation, (Configuration)jobConf);
    }

    public static StatsAggregator getStatsAggregator() {
        return (StatsAggregator)ReflectionUtils.newInstance(aggregatorImplementation, (Configuration)jobConf);
    }
}

