/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="acos", value="_FUNC_(x) - returns the arc cosine of x if -1<=x<=1 or NULL otherwise", extended="Example:\n  > SELECT _FUNC_(1) FROM src LIMIT 1;\n  0\n  > SELECT _FUNC_(2) FROM src LIMIT 1;\n  NULL")
public class UDFAcos
extends UDF {
    private DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate(DoubleWritable a) {
        if (a == null) {
            return null;
        }
        this.result.set(Math.acos(a.get()));
        return this.result;
    }
}

