/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.outline.nodes.BandNode;
import com.jaspersoft.ireport.designer.outline.nodes.DatasetNode;
import com.jaspersoft.ireport.designer.outline.nodes.FieldsNode;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.outline.nodes.NullBand;
import com.jaspersoft.ireport.designer.outline.nodes.NullBandNode;
import com.jaspersoft.ireport.designer.outline.nodes.ParametersNode;
import com.jaspersoft.ireport.designer.outline.nodes.ScriptletsNode;
import com.jaspersoft.ireport.designer.outline.nodes.StylesNode;
import com.jaspersoft.ireport.designer.outline.nodes.VariablesNode;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ReportChildren
extends Children.Keys {
    JasperDesign jd = null;
    Lookup doLkp = null;

    public ReportChildren(JasperDesign jd, Lookup doLkp) {
        this.jd = jd;
        this.doLkp = doLkp;
    }

    protected Node[] createNodes(Object key) {
        if (key.equals("styles")) {
            return new Node[]{new StylesNode(this.jd, this.doLkp)};
        }
        if (key.equals("parameters")) {
            return new Node[]{new ParametersNode(this.jd, this.doLkp)};
        }
        if (key.equals("fields")) {
            return new Node[]{new FieldsNode(this.jd, this.jd.getMainDesignDataset(), this.doLkp)};
        }
        if (key.equals("variables")) {
            return new Node[]{new VariablesNode(this.jd, this.jd.getMainDesignDataset(), this.doLkp)};
        }
        if (key.equals("scriptlets")) {
            return new Node[]{new ScriptletsNode(this.jd, this.doLkp)};
        }
        if (key instanceof JRDesignDataset) {
            return new Node[]{new DatasetNode(this.jd, (JRDesignDataset)key, this.doLkp)};
        }
        if (key instanceof JRDesignBand) {
            return new Node[]{new BandNode(this.jd, (JRDesignBand)key, this.doLkp)};
        }
        if (key instanceof NullBand) {
            return new Node[]{new NullBandNode(this.jd, (NullBand)key, this.doLkp)};
        }
        IRAbstractNode node = new IRAbstractNode(LEAF, (Lookup)new ProxyLookup(new Lookup[]{this.doLkp, Lookups.singleton((Object)key)}));
        node.setName(key + "");
        return new Node[]{node};
    }

    protected void addNotify() {
        super.addNotify();
        this.updateChildren();
    }

    public void updateChildren() {
        int k;
        JRSection section;
        int i;
        ArrayList<Object> children = new ArrayList<Object>();
        children.add("styles");
        children.add("parameters");
        children.add("fields");
        children.add("variables");
        children.add("scriptlets");
        children.addAll(this.jd.getDatasetsList());
        children.add(this.jd.getTitle() != null ? this.jd.getTitle() : new NullBand(new JROrigin(this.jd.getName(), BandTypeEnum.TITLE)));
        children.add(this.jd.getPageHeader() != null ? this.jd.getPageHeader() : new NullBand(new JROrigin(this.jd.getName(), BandTypeEnum.PAGE_HEADER)));
        children.add(this.jd.getColumnHeader() != null ? this.jd.getColumnHeader() : new NullBand(new JROrigin(this.jd.getName(), BandTypeEnum.COLUMN_HEADER)));
        JRGroup[] groups = this.jd.getGroups();
        for (i = 0; i < groups.length; ++i) {
            if (groups[i].getGroupHeaderSection() == null || groups[i].getGroupHeaderSection().getBands().length == 0) {
                children.add(new NullBand(new JROrigin(this.jd.getName(), groups[i].getName(), BandTypeEnum.GROUP_HEADER)));
                continue;
            }
            section = groups[i].getGroupHeaderSection();
            JRBand[] bands = section.getBands();
            for (k = 0; k < bands.length; ++k) {
                children.add(bands[k]);
            }
        }
        if (this.jd.getDetailSection() == null || this.jd.getDetailSection().getBands().length == 0) {
            children.add(new NullBand(new JROrigin(this.jd.getName(), BandTypeEnum.DETAIL)));
        } else {
            JRSection section2 = this.jd.getDetailSection();
            JRBand[] bands = section2.getBands();
            for (int k2 = 0; k2 < bands.length; ++k2) {
                children.add(bands[k2]);
            }
        }
        for (i = groups.length - 1; i >= 0; --i) {
            if (groups[i].getGroupFooterSection() == null || groups[i].getGroupFooterSection().getBands().length == 0) {
                children.add(new NullBand(new JROrigin(this.jd.getName(), groups[i].getName(), BandTypeEnum.GROUP_FOOTER)));
                continue;
            }
            section = groups[i].getGroupFooterSection();
            JRBand[] bands = section.getBands();
            for (k = 0; k < bands.length; ++k) {
                children.add(bands[k]);
            }
        }
        children.add(this.jd.getColumnFooter() != null ? this.jd.getColumnFooter() : new NullBand(new JROrigin(this.jd.getName(), BandTypeEnum.COLUMN_FOOTER)));
        children.add(this.jd.getPageFooter() != null ? this.jd.getPageFooter() : new NullBand(new JROrigin(this.jd.getName(), BandTypeEnum.PAGE_FOOTER)));
        children.add(this.jd.getLastPageFooter() != null ? this.jd.getLastPageFooter() : new NullBand(new JROrigin(this.jd.getName(), BandTypeEnum.LAST_PAGE_FOOTER)));
        children.add(this.jd.getSummary() != null ? this.jd.getSummary() : new NullBand(new JROrigin(this.jd.getName(), BandTypeEnum.SUMMARY)));
        children.add(this.jd.getNoData() != null ? this.jd.getNoData() : new NullBand(new JROrigin(this.jd.getName(), BandTypeEnum.NO_DATA)));
        children.add(this.jd.getBackground() != null ? this.jd.getBackground() : new NullBand(new JROrigin(this.jd.getName(), BandTypeEnum.BACKGROUND)));
        this.setKeys(children);
    }
}

