/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JasperDesign;

public class AddBandUndoableEdit
extends AggregatedUndoableEdit {
    private JRDesignBand band = null;
    private JasperDesign jasperDesign = null;

    public AddBandUndoableEdit(JRDesignBand band, JasperDesign jasperDesign) {
        this.band = band;
        this.jasperDesign = jasperDesign;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        JROrigin origin = this.getBand().getOrigin();
        if (origin != null) {
            switch (origin.getBandTypeValue()) {
                case BACKGROUND: {
                    this.jasperDesign.setBackground(null);
                    break;
                }
                case TITLE: {
                    this.jasperDesign.setTitle(null);
                    break;
                }
                case PAGE_HEADER: {
                    this.jasperDesign.setPageHeader(null);
                    break;
                }
                case COLUMN_HEADER: {
                    this.jasperDesign.setColumnHeader(null);
                    break;
                }
                case DETAIL: {
                    JRDesignSection section = (JRDesignSection)this.jasperDesign.getDetailSection();
                    section.removeBand((JRBand)this.band);
                    break;
                }
                case COLUMN_FOOTER: {
                    this.jasperDesign.setColumnFooter(null);
                    break;
                }
                case PAGE_FOOTER: {
                    this.jasperDesign.setPageFooter(null);
                    break;
                }
                case LAST_PAGE_FOOTER: {
                    this.jasperDesign.setLastPageFooter(null);
                    break;
                }
                case SUMMARY: {
                    this.jasperDesign.setSummary(null);
                    break;
                }
                case NO_DATA: {
                    this.jasperDesign.setNoData(null);
                    break;
                }
                case GROUP_HEADER: {
                    JRDesignGroup group = (JRDesignGroup)this.jasperDesign.getGroupsMap().get(origin.getGroupName());
                    JRDesignSection section = (JRDesignSection)group.getGroupHeaderSection();
                    section.removeBand((JRBand)this.band);
                    break;
                }
                case GROUP_FOOTER: {
                    JRDesignGroup group = (JRDesignGroup)this.jasperDesign.getGroupsMap().get(origin.getGroupName());
                    JRDesignSection section = (JRDesignSection)group.getGroupFooterSection();
                    section.removeBand((JRBand)this.band);
                    break;
                }
            }
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        JROrigin origin = this.getBand().getOrigin();
        if (origin != null) {
            switch (origin.getBandTypeValue()) {
                case BACKGROUND: {
                    this.jasperDesign.setBackground((JRBand)this.band);
                    break;
                }
                case TITLE: {
                    this.jasperDesign.setTitle((JRBand)this.band);
                    break;
                }
                case PAGE_HEADER: {
                    this.jasperDesign.setPageHeader((JRBand)this.band);
                    break;
                }
                case COLUMN_HEADER: {
                    this.jasperDesign.setColumnHeader((JRBand)this.band);
                    break;
                }
                case DETAIL: {
                    ((JRDesignSection)this.jasperDesign.getDetailSection()).addBand((JRBand)this.band);
                    break;
                }
                case COLUMN_FOOTER: {
                    this.jasperDesign.setColumnFooter((JRBand)this.band);
                    break;
                }
                case PAGE_FOOTER: {
                    this.jasperDesign.setPageFooter((JRBand)this.band);
                    break;
                }
                case LAST_PAGE_FOOTER: {
                    this.jasperDesign.setLastPageFooter((JRBand)this.band);
                    break;
                }
                case SUMMARY: {
                    this.jasperDesign.setSummary((JRBand)this.band);
                    break;
                }
                case NO_DATA: {
                    this.jasperDesign.setNoData((JRBand)this.band);
                    break;
                }
                case GROUP_HEADER: {
                    JRDesignGroup group = (JRDesignGroup)this.jasperDesign.getGroupsMap().get(origin.getGroupName());
                    ((JRDesignSection)group.getGroupHeaderSection()).addBand((JRBand)this.band);
                    break;
                }
                case GROUP_FOOTER: {
                    JRDesignGroup group = (JRDesignGroup)this.jasperDesign.getGroupsMap().get(origin.getGroupName());
                    ((JRDesignSection)group.getGroupFooterSection()).addBand((JRBand)this.band);
                    break;
                }
            }
        }
    }

    public String getPresentationName() {
        return "Add Band " + ModelUtils.nameOf(this.getBand().getOrigin());
    }

    public JRDesignBand getBand() {
        return this.band;
    }

    public void setBand(JRDesignBand band) {
        this.band = band;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }
}

