/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils.query;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.data.queryexecuters.QueryExecuterDef;
import com.jaspersoft.ireport.designer.utils.query.IRQueryExecuterFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactoryBundle;
import net.sf.jasperreports.engine.query.QueryExecuterFactory;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IRQueryExecuterFactoryBundle
implements JRQueryExecuterFactoryBundle {
    private final Log log = LogFactory.getLog(IRQueryExecuterFactory.class);
    private static final JRSingletonCache cache = new JRSingletonCache(QueryExecuterFactory.class);
    private static final IRQueryExecuterFactoryBundle INSTANCE = new IRQueryExecuterFactoryBundle();

    private IRQueryExecuterFactoryBundle() {
    }

    public static IRQueryExecuterFactoryBundle getInstance() {
        return INSTANCE;
    }

    public String[] getLanguages() {
        HashSet<String> langs = new HashSet<String>();
        List bundles = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(JRQueryExecuterFactoryBundle.class);
        for (JRQueryExecuterFactoryBundle bundle : bundles) {
            if (bundle.getClass().equals(this.getClass())) continue;
            String[] l = bundle.getLanguages();
            for (int i = 0; i < l.length; ++i) {
                langs.add(l[i]);
            }
        }
        ArrayList<String> languages = new ArrayList<String>();
        languages.addAll(langs);
        return languages.toArray(new String[languages.size()]);
    }

    public QueryExecuterFactory getQueryExecuterFactory(String language) throws JRException {
        List bundles = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(JRQueryExecuterFactoryBundle.class);
        for (JRQueryExecuterFactoryBundle bundle : bundles) {
            QueryExecuterFactory factory;
            if (bundle.getClass().equals(this.getClass()) || (factory = bundle.getQueryExecuterFactory(language)) == null) continue;
            return factory;
        }
        ArrayList<QueryExecuterDef> qes = IReportManager.getInstance().getQueryExecuters();
        for (QueryExecuterDef qe : qes) {
            if (!qe.getLanguage().equals(language)) continue;
            try {
                return (QueryExecuterFactory)cache.getCachedInstance(qe.getClassName());
            }
            catch (JRException ex) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("Unable to instance the create a QueryExecuterFactory for the language  " + language + ": " + ex.getMessage()));
                }
                System.out.println("Unable to instance the create a QueryExecuterFactory for the language  " + language + ": " + ex.getMessage());
                System.out.flush();
            }
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("No query executer factory class registered for " + language + " queries."));
        }
        return (QueryExecuterFactory)cache.getCachedInstance(IRQueryExecuterFactory.class.getName());
    }
}

