/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui;

import com.jaspersoft.ireport.designer.IRLocalJasperReportsContext;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ThreadUtils;
import com.jaspersoft.ireport.designer.tools.JrxmlPreviewToolbar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.swing.JRViewerController;
import net.sf.jasperreports.swing.JRViewerPanel;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class JRViewerTopComponent
extends TopComponent {
    private static JRViewerTopComponent instance;
    private static final String PREFERRED_ID = "JRViewerTopComponent";
    JRViewerController viewerContext = new JRViewerController((JasperReportsContext)IRLocalJasperReportsContext.getInstance(), null, null);
    JrxmlPreviewToolbar viewerToolbar = new JrxmlPreviewToolbar(this.viewerContext);
    JRViewerPanel viewerPanel = null;

    private JRViewerTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(JRViewerTopComponent.class, (String)"CTL_JRViewerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(JRViewerTopComponent.class, (String)"HINT_JRViewerTopComponent"));
    }

    public void setJasperPrint(final JasperPrint print) {
        ThreadUtils.invokeInAWTThread((Runnable)new Runnable(){

            public void run() {
                JRViewerTopComponent.this.removeAll();
                if (print != null) {
                    if (JRViewerTopComponent.this.viewerPanel == null) {
                        JRViewerTopComponent.this.viewerPanel = new JRViewerPanel(JRViewerTopComponent.this.viewerContext){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected void paintPage(Graphics2D grx) {
                                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                                try {
                                    Thread.currentThread().setContextClassLoader(IReportManager.getJRExtensionsClassLoader());
                                    super.paintPage(grx);
                                }
                                finally {
                                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                                }
                            }
                        };
                    }
                    JRViewerTopComponent.this.add((Component)JRViewerTopComponent.this.viewerPanel, "Center");
                    JRViewerTopComponent.this.add((Component)JRViewerTopComponent.this.viewerToolbar, "North");
                    JRViewerTopComponent.this.viewerToolbar.init();
                    JRViewerTopComponent.this.viewerContext.loadReport(print);
                    JRViewerTopComponent.this.viewerContext.refreshPage();
                    JRViewerTopComponent.this.viewerPanel.updateUI();
                }
                JRViewerTopComponent.this.updateUI();
            }
        });
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized JRViewerTopComponent getDefault() {
        if (instance == null) {
            instance = new JRViewerTopComponent();
        }
        return instance;
    }

    public static synchronized JRViewerTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(JRViewerTopComponent.class.getName()).warning("Cannot find JRViewerTopComponent component. It will not be located properly in the window system.");
            return JRViewerTopComponent.getDefault();
        }
        if (win instanceof JRViewerTopComponent) {
            return (JRViewerTopComponent)win;
        }
        Logger.getLogger(JRViewerTopComponent.class.getName()).warning("There seem to be multiple components with the 'JRViewerTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return JRViewerTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return JRViewerTopComponent.getDefault();
        }
    }
}

