/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.resources;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JRXMLADataSourceConnection;
import com.jaspersoft.ireport.designer.utils.ConfigurablePlainDocument;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.ui.ValidationUtils;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class XMLAConnectionDialog
extends JDialog {
    private int dialogResult = 2;
    private JServer server = null;
    private String parentFolder = null;
    private RepositoryFolder datasourceResource = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private boolean doNotStore = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClose;
    private JButton jButtonImportConnection;
    private JButton jButtonImportConnection1;
    private JButton jButtonSave;
    private JEditorPane jEditorPaneDescription;
    private JLabel jLabel1;
    private JLabel jLabelCatalog;
    private JLabel jLabelDatasource;
    private JLabel jLabelDescription;
    private JLabel jLabelLabel;
    private JLabel jLabelName;
    private JLabel jLabelPassword;
    private JLabel jLabelURL;
    private JLabel jLabelUriString;
    private JLabel jLabelUsername;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPasswordField jPasswordField;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldCatalog;
    private JTextField jTextFieldDatasource;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldName;
    private JTextField jTextFieldURL;
    private JTextField jTextFieldUriString;
    private JTextField jTextFieldUsername;

    public XMLAConnectionDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
        DocumentListener changesListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                XMLAConnectionDialog.this.updateSaveButton();
            }

            public void insertUpdate(DocumentEvent evt) {
                XMLAConnectionDialog.this.updateSaveButton();
            }

            public void removeUpdate(DocumentEvent evt) {
                XMLAConnectionDialog.this.updateSaveButton();
            }
        };
        this.jTextFieldName.setDocument((Document)new ConfigurablePlainDocument(100));
        this.jTextFieldLabel.setDocument((Document)new ConfigurablePlainDocument(100));
        this.jEditorPaneDescription.setDocument((Document)new ConfigurablePlainDocument(250));
        this.jTextFieldLabel.getDocument().addDocumentListener(changesListener);
        this.jTextFieldName.getDocument().addDocumentListener(changesListener);
        this.jTextFieldURL.getDocument().addDocumentListener(changesListener);
        this.jTextFieldCatalog.getDocument().addDocumentListener(changesListener);
        this.jTextFieldDatasource.getDocument().addDocumentListener(changesListener);
        this.applyI18n();
        this.jTextFieldName.requestFocusInWindow();
        this.jButtonImportConnection.setEnabled(true);
    }

    public void applyI18n() {
        this.jButtonClose.setText(JasperServerManager.getString("xmlaConnectionDialog.buttonCancel", "Cancel"));
        this.jButtonImportConnection.setText(JasperServerManager.getString("xmlaConnectionDialog.buttonImportConnection", "Import from iReport"));
        this.jButtonSave.setText(JasperServerManager.getString("xmlaConnectionDialog.buttonSave", "Save"));
        this.jLabel1.setText(JasperServerManager.getString("xmlaConnectionDialog.title", "Data Source"));
        this.jLabelDescription.setText(JasperServerManager.getString("xmlaConnectionDialog.labelDescription", "Description"));
        this.jLabelLabel.setText(JasperServerManager.getString("xmlaConnectionDialog.labelLabel", "Label"));
        this.jLabelName.setText(JasperServerManager.getString("xmlaConnectionDialog.labelName", "Name"));
        this.jLabelUriString.setText(JasperServerManager.getString("xmlaConnectionDialog.labelParentFolder", "Parent folder"));
        this.jLabelPassword.setText(JasperServerManager.getString("xmlaConnectionDialog.labelPassword", "Password"));
        this.jLabelURL.setText(JasperServerManager.getString("xmlaConnectionDialog.labelURI", "URI"));
        this.jLabelCatalog.setText(JasperServerManager.getString("xmlaConnectionDialog.labelCatalog", "Catalog"));
        this.jLabelDatasource.setText(JasperServerManager.getString("xmlaConnectionDialog.labelDatasource", "Data Source"));
        this.jLabelUsername.setText(JasperServerManager.getString("xmlaConnectionDialog.labelUsername", "Username"));
        this.jTabbedPane1.setTitleAt(0, JasperServerManager.getString("xmlaConnectionDialog.tabGeneral", "General"));
        this.jTabbedPane1.setTitleAt(1, JasperServerManager.getString("xmlaConnectionDialog.tabDetails", "XMLA/A connection details"));
    }

    private void updateSaveButton() {
        if (this.jTextFieldLabel.getText().length() > 0 && this.jTextFieldName.getText().length() > 0) {
            boolean ok = false;
            if (this.jTextFieldURL.getText().length() > 0 && this.jTextFieldCatalog.getText().length() > 0 && this.jTextFieldDatasource.getText().length() > 0) {
                ok = true;
            }
            this.jButtonSave.setEnabled(ok);
        } else {
            this.jButtonSave.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabelUriString = new JLabel();
        this.jTextFieldUriString = new JTextField();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPaneDescription = new JEditorPane();
        this.jLabelDescription = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabelURL = new JLabel();
        this.jTextFieldURL = new JTextField();
        this.jLabelCatalog = new JLabel();
        this.jTextFieldCatalog = new JTextField();
        this.jLabelDatasource = new JLabel();
        this.jTextFieldDatasource = new JTextField();
        this.jLabelUsername = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabelPassword = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jButtonImportConnection = new JButton();
        this.jButtonImportConnection1 = new JButton();
        this.jPanel4 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("DataSource");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/jasperserver/res/datasource_new.png")));
        this.jLabel1.setText("XML/A Connection");
        this.jLabel1.setVerticalAlignment(3);
        this.jLabel1.setVerticalTextPosition(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabelUriString.setText("Parent folder");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelUriString, gridBagConstraints);
        this.jTextFieldUriString.setEditable(false);
        this.jTextFieldUriString.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextFieldUriString.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldUriString, gridBagConstraints);
        this.jLabelName.setText("ID");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jSeparator2.setMinimumSize(new Dimension(0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabelLabel.setText("Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(368, 219));
        this.jScrollPane1.setPreferredSize(new Dimension(368, 219));
        this.jScrollPane1.setViewportView(this.jEditorPaneDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelDescription.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jLabelDescription, gridBagConstraints);
        this.jTabbedPane1.addTab("General", this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelURL.setText("URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelURL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 4, 8);
        this.jPanel3.add((Component)this.jTextFieldURL, gridBagConstraints);
        this.jLabelCatalog.setText("Catalog");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelCatalog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 4, 8);
        this.jPanel3.add((Component)this.jTextFieldCatalog, gridBagConstraints);
        this.jLabelDatasource.setText("Datasource");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelDatasource, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanel3.add((Component)this.jTextFieldDatasource, gridBagConstraints);
        this.jLabelUsername.setText("Username");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelUsername, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 4, 8);
        this.jPanel3.add((Component)this.jTextFieldUsername, gridBagConstraints);
        this.jLabelPassword.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 4, 0);
        this.jPanel3.add((Component)this.jLabelPassword, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 8);
        this.jPanel3.add((Component)this.jPasswordField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jButtonImportConnection.setText("Import from iReport");
        this.jButtonImportConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLAConnectionDialog.this.jButtonImportConnectionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel6.add((Component)this.jButtonImportConnection, gridBagConstraints);
        this.jButtonImportConnection1.setText("Import to iReport");
        this.jButtonImportConnection1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLAConnectionDialog.this.jButtonImportConnection1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 8);
        this.jPanel6.add((Component)this.jButtonImportConnection1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel6, gridBagConstraints);
        this.jTabbedPane1.addTab("Connection details", this.jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel4.setMinimumSize(new Dimension(10, 30));
        this.jPanel4.setPreferredSize(new Dimension(10, 30));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jButtonSave.setText("Save");
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLAConnectionDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLAConnectionDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.jButtonClose, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        this.pack();
    }

    private void jButtonImportConnectionActionPerformed(ActionEvent evt) {
        List iReportConnections = IReportManager.getInstance().getConnections();
        Vector<IReportConnection> validConnections = new Vector<IReportConnection>();
        for (IReportConnection conn : iReportConnections) {
            if (!(conn instanceof JRXMLADataSourceConnection)) continue;
            validConnections.add(conn);
        }
        if (validConnections.size() == 0) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getString("xmlaConnectionDialog.message.noXMLAconfigured", "No XML/A datasources currently configured in iReport."));
            return;
        }
        Object[] connections = new JRXMLADataSourceConnection[validConnections.size()];
        for (int i = 0; i < connections.length; ++i) {
            connections[i] = (JRXMLADataSourceConnection)validConnections.elementAt(i);
        }
        JRXMLADataSourceConnection selectedCon = (JRXMLADataSourceConnection)JOptionPane.showInputDialog(this, JasperServerManager.getString("xmlaConnectionDialog.message.selectXMLA", "Select a XML/A datasource:"), JasperServerManager.getString("xmlaConnectionDialog.message.import", "Import..."), 0, null, connections, connections[0]);
        if (selectedCon != null) {
            this.jTextFieldCatalog.setText(selectedCon.getCatalog());
            this.jTextFieldDatasource.setText(selectedCon.getDatasource());
            this.jTextFieldURL.setText(selectedCon.getUrl());
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setDescription(this.jEditorPaneDescription.getText().trim());
        rd.setName(this.jTextFieldName.getText());
        String uri = this.getParentFolder();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + this.jTextFieldName.getText();
        rd.setUriString(uri);
        rd.setLabel(this.jTextFieldLabel.getText().trim());
        rd.setParentFolder(this.getParentFolder());
        rd.setIsNew(this.datasourceResource == null);
        rd.setWsType("olapXmlaCon");
        rd.setResourceProperty("PROP_XMLA_URI", this.jTextFieldURL.getText());
        rd.setResourceProperty("PROP_XMLA_CATALOG", this.jTextFieldCatalog.getText());
        rd.setResourceProperty("PROP_XMLA_DATASOURCE", this.jTextFieldDatasource.getText());
        rd.setResourceProperty("PROP_XMLA_USERNAME", this.jTextFieldUsername.getText());
        rd.setResourceProperty("PROP_XMLA_PASSWORD", new String(this.jPasswordField.getPassword()));
        try {
            this.validate(rd);
            this.newResourceDescriptor = !this.doNotStore ? this.getServer().getWSClient().addOrModifyResource(rd, null) : rd;
            this.setDialogResult(0);
            if (this.datasourceResource != null) {
                this.datasourceResource.setDescriptor(this.newResourceDescriptor);
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return;
        }
    }

    private void jButtonImportConnection1ActionPerformed(ActionEvent evt) {
        String tmpName;
        JRXMLADataSourceConnection conn = new JRXMLADataSourceConnection();
        String name = this.jTextFieldLabel.getText();
        if (name.trim().length() == 0) {
            name = "XMLA Connection";
        }
        List connections = IReportManager.getInstance().getConnections();
        int i = 0;
        while (true) {
            tmpName = name + (i > 0 ? " (" + i + ")" : "");
            boolean found = false;
            for (IReportConnection c : connections) {
                if (!c.getName().equals(tmpName)) continue;
                found = true;
                break;
            }
            if (!found) break;
            ++i;
        }
        name = tmpName;
        conn.setName(name);
        conn.setUsername(this.jTextFieldUsername.getText());
        conn.setPassword(new String(this.jPasswordField.getPassword()));
        conn.setUrl(this.jTextFieldURL.getText());
        conn.setCatalog(this.jTextFieldCatalog.getText());
        conn.setDatasource(this.jTextFieldDatasource.getText());
        conn.setSavePassword(true);
        IReportManager.getInstance().addConnection((IReportConnection)conn);
        IReportManager.getInstance().setDefaultConnection((IReportConnection)conn);
        JOptionPane.showMessageDialog(this, "XML/A Connection successfully imported (" + name + ")");
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
        this.jTextFieldUriString.setText(parentFolder);
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }

    public void setResource(RepositoryFolder resource) {
        this.datasourceResource = resource;
        if (resource != null) {
            this.setResource(resource.getDescriptor());
            this.jTextFieldName.setEditable(false);
            this.jTextFieldName.setOpaque(false);
        }
    }

    public void setResource(ResourceDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.setTitle(JasperServerManager.getFormattedString("properties.title", "{0} - Properties", new Object[]{descriptor.getName()}));
        this.jTextFieldName.setText(descriptor.getName());
        this.jTextFieldLabel.setText(descriptor.getLabel());
        this.jEditorPaneDescription.setText(descriptor.getDescription());
        if (descriptor.getWsType().equals("olapXmlaCon")) {
            this.jTextFieldCatalog.setText(descriptor.getResourcePropertyValue("PROP_XMLA_CATALOG"));
            this.jTextFieldDatasource.setText(descriptor.getResourcePropertyValue("PROP_XMLA_DATASOURCE"));
            this.jTextFieldURL.setText(descriptor.getResourcePropertyValue("PROP_XMLA_URI"));
            this.jTextFieldUsername.setText(descriptor.getResourcePropertyValue("PROP_XMLA_USERNAME"));
            this.jPasswordField.setText(descriptor.getResourcePropertyValue("PROP_XMLA_PASSWORD"));
        }
        this.jButtonSave.setText("Save");
    }

    public boolean isDoNotStore() {
        return this.doNotStore;
    }

    public void setDoNotStore(boolean doNotStore) {
        this.doNotStore = doNotStore;
    }

    public void validate(ResourceDescriptor dataType) throws Exception {
        ValidationUtils.validateName(dataType.getName());
        ValidationUtils.validateLabel(dataType.getLabel());
        ValidationUtils.validateDesc(dataType.getDescription());
    }
}

